/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.lock;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ivy.plugins.lock.AbstractLockStrategy;
import org.apache.ivy.plugins.lock.DeleteOnExitHook;
import org.apache.ivy.util.Message;

public abstract class FileBasedLockStrategy
extends AbstractLockStrategy {
    private static final int SLEEP_TIME = 100;
    private static final long DEFAULT_TIMEOUT = 120000L;
    private FileLocker locker;
    private long timeout = 120000L;
    private static final ConcurrentMap<File, ConcurrentMap<Thread, Integer>> currentLockHolders = new ConcurrentHashMap<File, ConcurrentMap<Thread, Integer>>();

    protected FileBasedLockStrategy() {
        this(new CreateFileLocker(false), false);
    }

    protected FileBasedLockStrategy(boolean debugLocking) {
        this(new CreateFileLocker(debugLocking), debugLocking);
    }

    protected FileBasedLockStrategy(FileLocker locker, boolean debugLocking) {
        super(debugLocking);
        this.locker = locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquireLock(File file2) throws InterruptedException {
        Thread currentThread = Thread.currentThread();
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("acquiring lock on " + file2);
        }
        long start2 = System.currentTimeMillis();
        do {
            ConcurrentMap<File, ConcurrentMap<Thread, Integer>> concurrentMap = currentLockHolders;
            synchronized (concurrentMap) {
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("entered synchronized area (locking)");
                }
                int lockCount = this.hasLock(file2, currentThread);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("current status for " + file2 + " is " + lockCount + " held locks: " + this.getCurrentLockHolderNames(file2));
                }
                if (lockCount < 0) {
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("waiting for another thread to release the lock: " + this.getCurrentLockHolderNames(file2));
                    }
                } else {
                    if (lockCount > 0) {
                        int holdLocks = this.incrementLock(file2, currentThread);
                        if (this.isDebugLocking()) {
                            FileBasedLockStrategy.debugLocking("reentrant lock acquired on " + file2 + " in " + (System.currentTimeMillis() - start2) + "ms - hold locks = " + holdLocks);
                        }
                        return true;
                    }
                    if (this.locker.tryLock(file2)) {
                        if (this.isDebugLocking()) {
                            FileBasedLockStrategy.debugLocking("lock acquired on " + file2 + " in " + (System.currentTimeMillis() - start2) + "ms");
                        }
                        this.incrementLock(file2, currentThread);
                        return true;
                    }
                }
            }
            if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("failed to acquire lock; sleeping for retry...");
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() - start2 < this.timeout);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock(File file2) {
        Thread currentThread = Thread.currentThread();
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("releasing lock on " + file2);
        }
        ConcurrentMap<File, ConcurrentMap<Thread, Integer>> concurrentMap = currentLockHolders;
        synchronized (concurrentMap) {
            int holdLocks;
            if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("entered synchronized area (unlocking)");
            }
            if ((holdLocks = this.decrementLock(file2, currentThread)) == 0) {
                this.locker.unlock(file2);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("lock released on " + file2);
                }
            } else if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("reentrant lock released on " + file2 + " - hold locks = " + holdLocks);
            }
        }
    }

    private static void debugLocking(String msg) {
        Message.info(Thread.currentThread() + " " + System.currentTimeMillis() + " " + msg);
    }

    private int hasLock(File file2, Thread forThread) {
        int counter2;
        ConcurrentMap locksPerThread = (ConcurrentMap)currentLockHolders.get(file2);
        if (locksPerThread == null) {
            return 0;
        }
        if (locksPerThread.isEmpty()) {
            return 0;
        }
        Integer counterObj = (Integer)locksPerThread.get(forThread);
        int n = counter2 = counterObj == null ? 0 : counterObj;
        if (counter2 > 0) {
            return counter2;
        }
        return -1;
    }

    private int incrementLock(File file2, Thread forThread) {
        Integer c;
        ConcurrentHashMap<Thread, Integer> locksPerThread = (ConcurrentHashMap<Thread, Integer>)currentLockHolders.get(file2);
        if (locksPerThread == null) {
            locksPerThread = new ConcurrentHashMap<Thread, Integer>();
            currentLockHolders.put(file2, locksPerThread);
        }
        int holdLocks = (c = (Integer)locksPerThread.get(forThread)) == null ? 1 : c + 1;
        locksPerThread.put(forThread, holdLocks);
        return holdLocks;
    }

    private int decrementLock(File file2, Thread forThread) {
        int oldHeldLocks;
        ConcurrentMap locksPerThread = (ConcurrentMap)currentLockHolders.get(file2);
        if (locksPerThread == null) {
            throw new RuntimeException("Calling decrementLock on a thread which holds no locks");
        }
        Integer c = (Integer)locksPerThread.get(forThread);
        int n = oldHeldLocks = c == null ? 0 : c;
        if (oldHeldLocks <= 0) {
            throw new RuntimeException("Calling decrementLock on a thread which holds no locks");
        }
        int newHeldLocks = oldHeldLocks - 1;
        if (newHeldLocks > 0) {
            locksPerThread.put(forThread, newHeldLocks);
        } else {
            locksPerThread.remove(forThread);
        }
        return newHeldLocks;
    }

    protected String getCurrentLockHolderNames(File file2) {
        StringBuilder sb = new StringBuilder();
        ConcurrentMap m2 = (ConcurrentMap)currentLockHolders.get(file2);
        if (m2 == null) {
            return "(NULL)";
        }
        for (Thread t : m2.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(t.toString());
        }
        return sb.toString();
    }

    public static class NIOFileLocker
    implements FileLocker {
        private ConcurrentMap<File, LockData> locks = new ConcurrentHashMap<File, LockData>();
        private boolean debugLocking;

        public NIOFileLocker(boolean debugLocking) {
            this.debugLocking = debugLocking;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(File file2) {
            block7: {
                try {
                    if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) break block7;
                    RandomAccessFile raf = new RandomAccessFile(file2, "rw");
                    FileLock l = raf.getChannel().tryLock();
                    if (l != null) {
                        NIOFileLocker nIOFileLocker = this;
                        synchronized (nIOFileLocker) {
                            this.locks.put(file2, new LockData(raf, l));
                        }
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("failed to acquire lock on " + file2);
                    }
                }
                catch (IOException e) {
                    Message.verbose("file lock failed due to an exception: " + e.getMessage() + " (" + file2 + ")");
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock(File file2) {
            NIOFileLocker nIOFileLocker = this;
            synchronized (nIOFileLocker) {
                LockData data2 = (LockData)this.locks.get(file2);
                if (data2 == null) {
                    throw new IllegalArgumentException("file not previously locked: " + file2);
                }
                try {
                    this.locks.remove(file2);
                    data2.l.release();
                    data2.raf.close();
                }
                catch (IOException e) {
                    Message.error("problem while releasing lock on " + file2 + ": " + e.getMessage());
                }
            }
        }

        private static class LockData {
            private RandomAccessFile raf;
            private FileLock l;

            LockData(RandomAccessFile raf, FileLock l) {
                this.raf = raf;
                this.l = l;
            }
        }
    }

    public static class CreateFileLocker
    implements FileLocker {
        private boolean debugLocking;

        public CreateFileLocker(boolean debugLocking) {
            this.debugLocking = debugLocking;
        }

        @Override
        public boolean tryLock(File file2) {
            try {
                if (file2.getParentFile().exists() || file2.getParentFile().mkdirs()) {
                    if (file2.createNewFile()) {
                        DeleteOnExitHook.add(file2);
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("file creation failed " + file2);
                    }
                }
            }
            catch (IOException e) {
                Message.verbose("file creation failed due to an exception: " + e.getMessage() + " (" + file2 + ")");
            }
            return false;
        }

        @Override
        public void unlock(File file2) {
            file2.delete();
            DeleteOnExitHook.remove(file2);
        }
    }

    public static interface FileLocker {
        public boolean tryLock(File var1);

        public void unlock(File var1);
    }
}

