/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.Message;

public class ChainedRepository
extends AbstractRepository {
    private List<Repository> repositories;

    public void setRepositories(List<Repository> repositories2) {
        this.repositories = repositories2;
    }

    @Override
    public Resource getResource(String source2) throws IOException {
        for (Repository repository : this.repositories) {
            this.logTry(repository);
            try {
                Resource r = repository.getResource(source2);
                if (r == null || !r.exists()) continue;
                this.logSuccess(repository);
                return r;
            }
            catch (Exception e) {
                this.logFailed(repository, e);
            }
        }
        return new BasicResource(source2, false, 0L, 0L, true);
    }

    @Override
    public void get(String source2, File destination) throws IOException {
        for (Repository repository : this.repositories) {
            this.logTry(repository);
            boolean ok = false;
            try {
                repository.get(source2, destination);
                ok = true;
            }
            catch (Exception e) {
                this.logFailed(repository, e);
            }
            if (!ok) continue;
            this.logSuccess(repository);
            return;
        }
        throw this.newIOEFail("copy " + source2 + " into " + destination);
    }

    @Override
    public List<String> list(String parent) throws IOException {
        for (Repository repository : this.repositories) {
            this.logTry(repository);
            try {
                List<String> list2 = repository.list(parent);
                if (list2 == null) continue;
                this.logSuccess(repository);
                return list2;
            }
            catch (Exception e) {
                this.logFailed(repository, e);
            }
        }
        throw this.newIOEFail("list contents in " + parent);
    }

    private void logTry(Repository repository) {
        Message.debug("Mirrored repository " + this.getName() + ": trying " + repository.getName());
    }

    private void logFailed(Repository repository, Exception e) {
        Message.warn("Mirrored repository " + this.getName() + ": " + repository.getName() + " is not available", e);
        Message.warn("Trying the next one in the mirror list...");
    }

    private void logSuccess(Repository repository) {
        Message.debug("Mirrored repository " + this.getName() + ": success with " + repository.getName());
    }

    private IOException newIOEFail(String action2) {
        return new IOException("Mirrored repository " + this.getName() + ": fail to " + action2 + " with every listed mirror");
    }
}

