/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.AbstractPatternsBasedResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.signer.SignatureGenerator;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.ChecksumHelper;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class RepositoryResolver
extends AbstractPatternsBasedResolver {
    private Repository repository;
    private Boolean alwaysCheckExactRevision = null;
    private String signerName = null;

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public void setName(String name2) {
        super.setName(name2);
        if (this.repository instanceof AbstractRepository) {
            ((AbstractRepository)this.repository).setName(name2);
        }
    }

    public void setSigner(String signerName) {
        this.signerName = signerName;
    }

    @Override
    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId mrid, String pattern2, Artifact artifact, ResourceMDParser rmdparser, Date date2) {
        String name2 = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        try {
            if (!versionMatcher.isDynamic(mrid) || this.isAlwaysCheckExactRevision()) {
                String resourceName = IvyPatternHelper.substitute(pattern2, mrid, artifact);
                Message.debug("\t trying " + resourceName);
                this.logAttempt(resourceName);
                Resource res = this.repository.getResource(resourceName);
                boolean reachable = res.exists();
                if (reachable) {
                    String revision;
                    if (pattern2.contains("revision")) {
                        revision = mrid.getRevision();
                    } else if ("ivy".equals(artifact.getType()) || "pom".equals(artifact.getType())) {
                        File temp = File.createTempFile("ivy", artifact.getExt());
                        temp.deleteOnExit();
                        this.repository.get(res.getName(), temp);
                        ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(res);
                        ModuleDescriptor md = parser.parseDescriptor(this.getParserSettings(), temp.toURI().toURL(), res, false);
                        revision = md.getRevision();
                        if (StringUtils.isNullOrEmpty(revision)) {
                            revision = "working@" + name2;
                        }
                    } else {
                        revision = "working@" + name2;
                    }
                    return new ResolvedResource(res, revision);
                }
                if (versionMatcher.isDynamic(mrid)) {
                    return this.findDynamicResourceUsingPattern(rmdparser, mrid, pattern2, artifact, date2);
                }
                Message.debug("\t" + name2 + ": resource not reachable for " + mrid + ": res=" + res);
                return null;
            }
            return this.findDynamicResourceUsingPattern(rmdparser, mrid, pattern2, artifact, date2);
        }
        catch (IOException | ParseException ex) {
            throw new RuntimeException(name2 + ": unable to get resource for " + mrid + ": res=" + IvyPatternHelper.substitute(pattern2, mrid, artifact) + ": " + ex, ex);
        }
    }

    private ResolvedResource findDynamicResourceUsingPattern(ResourceMDParser rmdparser, ModuleRevisionId mrid, String pattern2, Artifact artifact, Date date2) {
        String name2 = this.getName();
        this.logAttempt(IvyPatternHelper.substitute(pattern2, ModuleRevisionId.newInstance(mrid, IvyPatternHelper.getTokenString("revision")), artifact));
        ResolvedResource[] rress = this.listResources(this.repository, mrid, pattern2, artifact);
        if (rress == null) {
            Message.debug("\t" + name2 + ": unable to list resources for " + mrid + ": pattern=" + pattern2);
            return null;
        }
        ResolvedResource found = this.findResource(rress, rmdparser, mrid, date2);
        if (found == null) {
            Message.debug("\t" + name2 + ": no resource found for " + mrid + ": pattern=" + pattern2);
        }
        return found;
    }

    @Override
    protected Resource getResource(String source2) throws IOException {
        return this.repository.getResource(source2);
    }

    protected ResolvedResource[] listResources(Repository repository, ModuleRevisionId mrid, String pattern2, Artifact artifact) {
        return ResolverHelper.findAll(repository, mrid, pattern2, artifact);
    }

    @Override
    protected long get(Resource resource, File dest) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + dest);
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        this.repository.get(resource.getName(), dest);
        return dest.length();
    }

    @Override
    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        String destPattern;
        if ("ivy".equals(artifact.getType()) && !this.getIvyPatterns().isEmpty()) {
            destPattern = this.getIvyPatterns().get(0);
        } else if (!this.getArtifactPatterns().isEmpty()) {
            destPattern = this.getArtifactPatterns().get(0);
        } else {
            throw new IllegalStateException("impossible to publish " + artifact + " using " + this + ": no artifact pattern defined");
        }
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        String dest = this.getDestination(destPattern, artifact, mrid);
        this.put(artifact, src, dest, overwrite);
        Message.info("\tpublished " + artifact.getName() + " to " + this.hidePassword(this.repository.standardize(dest)));
    }

    protected String getDestination(String pattern2, Artifact artifact, ModuleRevisionId mrid) {
        return IvyPatternHelper.substitute(pattern2, mrid, artifact);
    }

    protected void put(Artifact artifact, File src, String dest, boolean overwrite) throws IOException {
        String[] checksums;
        for (String checksum : checksums = this.getChecksumAlgorithms()) {
            if (ChecksumHelper.isKnownAlgorithm(checksum)) continue;
            throw new IllegalArgumentException("Unknown checksum algorithm: " + checksum);
        }
        this.repository.put(artifact, src, dest, overwrite);
        for (String checksum : checksums) {
            this.putChecksum(artifact, src, dest, overwrite, checksum);
        }
        if (this.signerName != null) {
            this.putSignature(artifact, src, dest, overwrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putChecksum(Artifact artifact, File src, String dest, boolean overwrite, String algorithm) throws IOException {
        File csFile = File.createTempFile("ivytemp", algorithm);
        try {
            FileUtil.copy((InputStream)new ByteArrayInputStream(ChecksumHelper.computeAsString(src, algorithm).getBytes()), csFile, null);
            this.repository.put(DefaultArtifact.cloneWithAnotherTypeAndExt(artifact, algorithm, artifact.getExt() + "." + algorithm), csFile, this.chopQuery(dest, algorithm), overwrite);
        }
        finally {
            csFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSignature(Artifact artifact, File src, String dest, boolean overwrite) throws IOException {
        SignatureGenerator gen = this.getSettings().getSignatureGenerator(this.signerName);
        if (gen == null) {
            throw new IllegalArgumentException("Couldn't sign the artifacts! Unknown signer name: '" + this.signerName + "'");
        }
        File tempFile = File.createTempFile("ivytemp", gen.getExtension());
        try {
            gen.sign(src, tempFile);
            this.repository.put(DefaultArtifact.cloneWithAnotherTypeAndExt(artifact, gen.getExtension(), artifact.getExt() + "." + gen.getExtension()), tempFile, this.chopQuery(dest, gen.getExtension()), overwrite);
        }
        finally {
            tempFile.delete();
        }
    }

    private String chopQuery(String dest, String algorithm) {
        if (!dest.contains("?")) {
            return dest + "." + algorithm;
        }
        try {
            URL url2 = new URL(dest);
            String query2 = url2.getQuery();
            if (query2 == null) {
                query2 = "";
            }
            return dest.replace("?" + query2, "") + "." + algorithm;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadReport download(Artifact[] artifacts, DownloadOptions options2) {
        EventManager eventManager = this.getEventManager();
        try {
            if (eventManager != null) {
                this.repository.addTransferListener(eventManager);
            }
            DownloadReport downloadReport = super.download(artifacts, options2);
            return downloadReport;
        }
        finally {
            if (eventManager != null) {
                this.repository.removeTransferListener(eventManager);
            }
        }
    }

    @Override
    protected void findTokenValues(Collection<String> names2, List<String> patterns, Map<String, String> tokenValues, String token2) {
        for (String pattern2 : patterns) {
            String partiallyResolvedPattern = IvyPatternHelper.substituteTokens(pattern2, tokenValues);
            String[] values2 = ResolverHelper.listTokenValues(this.repository, partiallyResolvedPattern, token2);
            if (values2 == null) continue;
            names2.addAll(this.filterNames(new ArrayList<String>(Arrays.asList(values2))));
        }
    }

    @Override
    protected String[] listTokenValues(String pattern2, String token2) {
        return ResolverHelper.listTokenValues(this.repository, pattern2, token2);
    }

    @Override
    protected boolean exist(String path2) {
        try {
            Resource resource = this.repository.getResource(path2);
            return resource.exists();
        }
        catch (IOException e) {
            Message.debug(e);
            return false;
        }
    }

    @Override
    public String getTypeName() {
        return "repository";
    }

    @Override
    public void dumpSettings() {
        super.dumpSettings();
        Message.debug("\t\trepository: " + this.getRepository());
    }

    @Override
    public void setSettings(ResolverSettings settings2) {
        super.setSettings(settings2);
        if (settings2 != null && this.alwaysCheckExactRevision == null) {
            this.alwaysCheckExactRevision = Boolean.valueOf(settings2.getVariable("ivy.default.always.check.exact.revision"));
        }
    }

    public boolean isAlwaysCheckExactRevision() {
        return this.alwaysCheckExactRevision == null || this.alwaysCheckExactRevision != false;
    }

    public void setAlwaysCheckExactRevision(boolean alwaysCheckExactRevision) {
        this.alwaysCheckExactRevision = alwaysCheckExactRevision;
    }
}

