/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.URLLister;
import org.apache.ivy.util.Message;

public final class ResolverHelper {
    private ResolverHelper() {
    }

    public static String[] listTokenValues(Repository rep, String pattern2, String token2) {
        String tokenString;
        String fileSep = rep.getFileSeparator();
        int index2 = (pattern2 = rep.standardize(pattern2)).indexOf(tokenString = IvyPatternHelper.getTokenString(token2));
        if (index2 == -1) {
            Message.verbose("unable to list " + token2 + " in " + pattern2 + ": token not found in pattern");
            return null;
        }
        if ((pattern2.length() <= index2 + tokenString.length() || fileSep.equals(pattern2.substring(index2 + tokenString.length(), index2 + tokenString.length() + 1))) && (index2 == 0 || fileSep.equals(pattern2.substring(index2 - 1, index2)))) {
            String root2 = pattern2.substring(0, index2);
            return ResolverHelper.listAll(rep, root2);
        }
        int slashIndex = pattern2.substring(0, index2).lastIndexOf(fileSep);
        String root3 = slashIndex == -1 ? "" : pattern2.substring(0, slashIndex);
        try {
            Message.debug("\tusing " + rep + " to list all in " + root3);
            String[] all2 = ResolverHelper.listAll(rep, root3);
            if (all2 == null) {
                return null;
            }
            Message.debug("\t\tfound " + all2.length + " urls");
            ArrayList<String> ret = new ArrayList<String>(all2.length);
            int endNameIndex = pattern2.indexOf(fileSep, slashIndex + 1);
            String namePattern = endNameIndex != -1 ? pattern2.substring(slashIndex + 1, endNameIndex) : pattern2.substring(slashIndex + 1);
            namePattern = namePattern.replaceAll("\\.", "\\\\.");
            namePattern = IvyPatternHelper.substituteToken(namePattern, token2, "(.+)");
            Pattern p2 = Pattern.compile(namePattern);
            for (String path2 : all2) {
                Matcher m2 = p2.matcher(path2);
                if (!m2.matches()) continue;
                String value2 = m2.group(1);
                ret.add(value2);
            }
            Message.debug("\t\t" + ret.size() + " matched " + pattern2);
            return ret.toArray(new String[ret.size()]);
        }
        catch (Exception e) {
            Message.warn("problem while listing resources in " + root3 + " with " + rep, e);
            return null;
        }
    }

    public static String[] listAll(Repository rep, String parent) {
        try {
            String fileSep = rep.getFileSeparator();
            Message.debug("\tusing " + rep + " to list all in " + parent);
            List<String> all2 = rep.list(parent);
            if (all2 == null) {
                Message.debug("\t\tno resources found");
                return null;
            }
            Message.debug("\t\tfound " + all2.size() + " resources");
            ArrayList<String> names2 = new ArrayList<String>(all2.size());
            for (String path2 : all2) {
                if (path2.endsWith(fileSep)) {
                    path2 = path2.substring(0, path2.length() - 1);
                }
                int slashIndex = path2.lastIndexOf(fileSep);
                names2.add(path2.substring(slashIndex + 1));
            }
            return names2.toArray(new String[names2.size()]);
        }
        catch (IOException e) {
            Message.verbose("problem while listing resources in " + parent + " with " + rep, e);
            return null;
        }
        catch (Exception e) {
            Message.warn("problem while listing resources in " + parent + " with " + rep, e);
            return null;
        }
    }

    public static ResolvedResource[] findAll(Repository rep, ModuleRevisionId mrid, String pattern2, Artifact artifact) {
        String partiallyResolvedPattern = IvyPatternHelper.substitute(pattern2, ModuleRevisionId.newInstance(mrid, IvyPatternHelper.getTokenString("revision")), artifact);
        Message.debug("\tlisting all in " + partiallyResolvedPattern);
        String[] revs = ResolverHelper.listTokenValues(rep, partiallyResolvedPattern, "revision");
        if (revs != null) {
            Message.debug("\tfound revs: " + Arrays.asList(revs));
            ArrayList<ResolvedResource> ret = new ArrayList<ResolvedResource>(revs.length);
            for (String rev : revs) {
                String rres = IvyPatternHelper.substituteToken(partiallyResolvedPattern, "revision", rev);
                try {
                    Resource res = rep.getResource(rres);
                    if (res == null) continue;
                    ret.add(new ResolvedResource(res, rev));
                }
                catch (IOException e) {
                    Message.warn("impossible to get resource from name listed by repository: " + rres, e);
                }
            }
            if (revs.length != ret.size()) {
                Message.debug("\tfound resolved res: " + ret);
            }
            return ret.toArray(new ResolvedResource[ret.size()]);
        }
        if (!partiallyResolvedPattern.contains("[revision]")) {
            try {
                Resource res = rep.getResource(partiallyResolvedPattern);
                if (res.exists()) {
                    Message.debug("\tonly one resource found without real listing: using and defining it as working@" + rep.getName() + " revision: " + res.getName());
                    return new ResolvedResource[]{new ResolvedResource(res, "working@" + rep.getName())};
                }
            }
            catch (IOException e) {
                Message.debug("\timpossible to get resource from name listed by repository: " + partiallyResolvedPattern, e);
            }
            Message.debug("\tno revision found");
        }
        return null;
    }

    public static String[] listTokenValues(URLLister lister, String pattern2, String token2) {
        if (lister.accept(pattern2 = ResolverHelper.standardize(pattern2))) {
            String tokenString = IvyPatternHelper.getTokenString(token2);
            int index2 = pattern2.indexOf(tokenString);
            if (index2 == -1) {
                Message.verbose("unable to list " + token2 + " in " + pattern2 + ": token not found in pattern");
                return null;
            }
            if ((pattern2.length() <= index2 + tokenString.length() || "/".equals(pattern2.substring(index2 + tokenString.length(), index2 + tokenString.length() + 1))) && (index2 == 0 || "/".equals(pattern2.substring(index2 - 1, index2)))) {
                String root2 = pattern2.substring(0, index2);
                try {
                    return ResolverHelper.listAll(lister, new URL(root2));
                }
                catch (MalformedURLException e) {
                    Message.warn("malformed url from pattern root: " + root2 + ": " + e.getMessage());
                    return null;
                }
            }
            int slashIndex = pattern2.substring(0, index2).lastIndexOf(47);
            String root3 = slashIndex == -1 ? "" : pattern2.substring(0, slashIndex);
            try {
                Message.debug("\tusing " + lister + " to list all in " + root3);
                List<URL> all2 = lister.listAll(new URL(root3));
                Message.debug("\t\tfound " + all2.size() + " urls");
                ArrayList<String> ret = new ArrayList<String>(all2.size());
                int endNameIndex = pattern2.indexOf(47, slashIndex + 1);
                String namePattern = endNameIndex != -1 ? pattern2.substring(slashIndex + 1, endNameIndex) : pattern2.substring(slashIndex + 1);
                String acceptNamePattern = ".*" + IvyPatternHelper.substituteToken(namePattern, token2, "([^/]+)") + ".*";
                Pattern p2 = Pattern.compile(acceptNamePattern);
                for (URL url2 : all2) {
                    String path2 = ResolverHelper.standardize(url2.getPath());
                    Matcher m2 = p2.matcher(path2);
                    if (!m2.matches()) continue;
                    String value2 = m2.group(1);
                    ret.add(value2);
                }
                Message.debug("\t\t" + ret.size() + " matched " + pattern2);
                return ret.toArray(new String[ret.size()]);
            }
            catch (Exception e) {
                Message.warn("problem while listing files in " + root3, e);
                return null;
            }
        }
        return null;
    }

    private static String standardize(String path2) {
        return path2.replace('\\', '/');
    }

    public static String[] listAll(URLLister lister, URL root2) {
        try {
            if (lister.accept(root2.toExternalForm())) {
                Message.debug("\tusing " + lister + " to list all in " + root2);
                List<URL> all2 = lister.listAll(root2);
                Message.debug("\t\tfound " + all2.size() + " urls");
                ArrayList<String> names2 = new ArrayList<String>(all2.size());
                for (URL dir : all2) {
                    String path2 = dir.getPath();
                    if (path2.endsWith("/")) {
                        path2 = path2.substring(0, path2.length() - 1);
                    }
                    int slashIndex = path2.lastIndexOf(47);
                    names2.add(path2.substring(slashIndex + 1));
                }
                return names2.toArray(new String[names2.size()]);
            }
            return null;
        }
        catch (Exception e) {
            Message.warn("problem while listing directories in " + root2, e);
            return null;
        }
    }
}

