/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.url.BasicURLHandler;
import org.apache.ivy.util.url.TimeoutConstrainedURLHandler;
import org.apache.ivy.util.url.URLHandler;

public class URLHandlerDispatcher
implements TimeoutConstrainedURLHandler {
    private final Map<String, URLHandler> handlers = new HashMap<String, URLHandler>();
    private URLHandler defaultHandler = new BasicURLHandler();

    @Override
    public boolean isReachable(URL url2) {
        return this.isReachable(url2, null);
    }

    @Override
    public boolean isReachable(URL url2, int timeout) {
        return this.isReachable(url2, URLHandlerDispatcher.createTimeoutConstraints(timeout));
    }

    @Override
    public boolean isReachable(URL url2, TimeoutConstraint timeoutConstraint) {
        URLHandler handler = this.getHandler(url2.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).isReachable(url2, timeoutConstraint);
        }
        return handler.isReachable(url2, timeoutConstraint != null ? timeoutConstraint.getConnectionTimeout() : 0);
    }

    @Override
    public long getContentLength(URL url2) {
        return this.getContentLength(url2, null);
    }

    @Override
    public long getContentLength(URL url2, int timeout) {
        return this.getContentLength(url2, URLHandlerDispatcher.createTimeoutConstraints(timeout));
    }

    @Override
    public long getContentLength(URL url2, TimeoutConstraint timeoutConstraint) {
        URLHandler handler = this.getHandler(url2.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).getContentLength(url2, timeoutConstraint);
        }
        return handler.getContentLength(url2, timeoutConstraint != null ? timeoutConstraint.getConnectionTimeout() : 0);
    }

    @Override
    public long getLastModified(URL url2) {
        return this.getLastModified(url2, null);
    }

    @Override
    public long getLastModified(URL url2, int timeout) {
        return this.getLastModified(url2, URLHandlerDispatcher.createTimeoutConstraints(timeout));
    }

    @Override
    public long getLastModified(URL url2, TimeoutConstraint timeoutConstraint) {
        URLHandler handler = this.getHandler(url2.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).getLastModified(url2, timeoutConstraint);
        }
        return handler.getLastModified(url2, timeoutConstraint != null ? timeoutConstraint.getConnectionTimeout() : 0);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url2) {
        return this.getURLInfo(url2, null);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url2, int timeout) {
        return this.getURLInfo(url2, URLHandlerDispatcher.createTimeoutConstraints(timeout));
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url2, TimeoutConstraint timeoutConstraint) {
        URLHandler handler = this.getHandler(url2.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).getURLInfo(url2, timeoutConstraint);
        }
        return handler.getURLInfo(url2, timeoutConstraint != null ? timeoutConstraint.getConnectionTimeout() : 0);
    }

    @Override
    public InputStream openStream(URL url2) throws IOException {
        return this.openStream(url2, null);
    }

    @Override
    public InputStream openStream(URL url2, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = this.getHandler(url2.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).openStream(url2, timeoutConstraint);
        }
        return handler.openStream(url2);
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        this.download(src, dest, l, null);
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener listener2, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = this.getHandler(src.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            ((TimeoutConstrainedURLHandler)handler).download(src, dest, listener2, timeoutConstraint);
            return;
        }
        handler.download(src, dest, listener2);
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener l) throws IOException {
        this.upload(src, dest, l, null);
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener listener2, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = this.getHandler(dest.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            ((TimeoutConstrainedURLHandler)handler).upload(src, dest, listener2, timeoutConstraint);
            return;
        }
        handler.upload(src, dest, listener2);
    }

    @Override
    public void setRequestMethod(int requestMethod) {
        this.defaultHandler.setRequestMethod(requestMethod);
        for (URLHandler handler : this.handlers.values()) {
            handler.setRequestMethod(requestMethod);
        }
    }

    public void setDownloader(String protocol, URLHandler downloader) {
        this.handlers.put(protocol, downloader);
    }

    public URLHandler getHandler(String protocol) {
        URLHandler downloader = this.handlers.get(protocol);
        return downloader == null ? this.defaultHandler : downloader;
    }

    public URLHandler getDefault() {
        return this.defaultHandler;
    }

    public void setDefault(URLHandler default1) {
        this.defaultHandler = default1;
    }

    private static TimeoutConstraint createTimeoutConstraints(final int connectionTimeout) {
        return new TimeoutConstraint(){

            @Override
            public int getConnectionTimeout() {
                return connectionTimeout;
            }

            @Override
            public int getReadTimeout() {
                return -1;
            }
        };
    }
}

