/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExecutorsKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.UnsafeBlocking;
import libraries.io.ThreadUtil;
import org.jetbrains.annotations.NotNull;
import runtime.CoroutineExceptionLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lruntime/ExecutorDispatcher;", "", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "(Ljava/util/concurrent/ScheduledExecutorService;Llibraries/coroutines/extra/Lifetime;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "platform-runtime"})
public final class ExecutorDispatcher {
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final CoroutineContext coroutineContext;

    public ExecutorDispatcher(@NotNull ScheduledExecutorService executorService, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.executorService = executorService;
        this.coroutineContext = ExecutorsKt.from((ExecutorService)this.executorService).plus((CoroutineContext)CoroutineExceptionLogger.create$default(CoroutineExceptionLogger.INSTANCE, null, 1, null));
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ThreadUtil.INSTANCE.getModifyThreadGroupPermission());
        }
        lifetime.add((Function)new Function0<Unit>(){

            public final void invoke() {
                UnsafeBlocking.INSTANCE.executeBlocking((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        executorService.shutdown();
                    }
                });
            }
        });
    }

    @NotNull
    public final CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }
}

