/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.FailureInfo;
import runtime.RpcException;
import runtime.ValidationError;
import runtime.ValidationResult;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"INTERNAL_SERVER_ERROR_MESSAGE", "", "internalFailure", "Lruntime/FailureInfo;", "getInternalFailure", "(Lruntime/FailureInfo;)Ljava/lang/String;", "getFailureMessage", "", "message", "Lruntime/ValidationResult;", "messageQuick", "Lruntime/ValidationError;", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nRpcException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RpcException.kt\nruntime/RpcExceptionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class RpcExceptionKt {
    @NotNull
    public static final String INTERNAL_SERVER_ERROR_MESSAGE = "An internal server error occurred. Please contact the server administrator or see server logs for details.";

    @Nullable
    public static final String getInternalFailure(@NotNull FailureInfo $this$internalFailure) {
        Intrinsics.checkNotNullParameter((Object)$this$internalFailure, (String)"<this>");
        return $this$internalFailure.getAuthenticationError() != null || $this$internalFailure.getValidationError() != null || $this$internalFailure.getSecurityError() != null || $this$internalFailure.getRequestError() != null || $this$internalFailure.getTransportError() != null || $this$internalFailure.getNotFoundError() != null ? null : INTERNAL_SERVER_ERROR_MESSAGE;
    }

    @NotNull
    public static final String message(@NotNull FailureInfo $this$message) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"<this>");
        if ($this$message.getAuthenticationError() != null) {
            string2 = $this$message.getAuthenticationError();
        } else if ($this$message.getSecurityError() != null) {
            string2 = $this$message.getSecurityError();
        } else if ($this$message.getValidationError() != null) {
            string2 = RpcExceptionKt.message($this$message.getValidationError());
        } else if ($this$message.getRequestError() != null) {
            string2 = $this$message.getRequestError();
        } else if ($this$message.getTransportError() != null) {
            string2 = $this$message.getTransportError();
        } else if ($this$message.getNotFoundError() != null) {
            string2 = $this$message.getNotFoundError();
        } else {
            String string3 = RpcExceptionKt.getInternalFailure($this$message);
            string2 = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string2;
    }

    @NotNull
    public static final String message(@NotNull ValidationResult $this$message) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"<this>");
        Object object = (ValidationError)ArraysKt.firstOrNull((Object[])$this$message.getErrors());
        if (object == null || (object = RpcExceptionKt.messageQuick((ValidationError)object)) == null) {
            object = "Validation error";
        }
        return object;
    }

    @NotNull
    public static final String messageQuick(@NotNull ValidationError $this$messageQuick) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
                object = $this$messageQuick.getParameter();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string2 = "Validation of parameter " + it + " failed: " + $this$messageQuick.getMessage();
                object = string2;
                if (string2 != null) break block3;
            }
            object = $this$messageQuick.getMessage();
        }
        return object;
    }

    @NotNull
    public static final String messageQuick(@NotNull ValidationResult $this$messageQuick) {
        Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
        Object object = (ValidationError)ArraysKt.firstOrNull((Object[])$this$messageQuick.getErrors());
        if (object == null || (object = ((ValidationError)object).getMessage()) == null) {
            object = "Validation error";
        }
        return object;
    }

    @NotNull
    public static final String messageQuick(@NotNull FailureInfo $this$messageQuick) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
        if ($this$messageQuick.getAuthenticationError() != null) {
            string2 = $this$messageQuick.getAuthenticationError();
        } else if ($this$messageQuick.getSecurityError() != null) {
            string2 = $this$messageQuick.getSecurityError();
        } else if ($this$messageQuick.getValidationError() != null) {
            string2 = RpcExceptionKt.messageQuick($this$messageQuick.getValidationError());
        } else if ($this$messageQuick.getRequestError() != null) {
            string2 = $this$messageQuick.getRequestError();
        } else if ($this$messageQuick.getTransportError() != null) {
            string2 = $this$messageQuick.getTransportError();
        } else if ($this$messageQuick.getNotFoundError() != null) {
            string2 = $this$messageQuick.getNotFoundError();
        } else {
            String string3 = RpcExceptionKt.getInternalFailure($this$messageQuick);
            string2 = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string2;
    }

    @NotNull
    public static final String getFailureMessage(@NotNull Throwable $this$getFailureMessage) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getFailureMessage, (String)"<this>");
        if ($this$getFailureMessage instanceof RpcException) {
            string2 = RpcExceptionKt.message(((RpcException)$this$getFailureMessage).getFailure());
        } else {
            string2 = $this$getFailureMessage.getMessage();
            if (string2 == null) {
                string2 = $this$getFailureMessage.toString();
            }
        }
        return string2;
    }
}

