/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import klogging.MDCUtilsKt;
import klogging.PlatformMDCKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import libraries.klogging.MDCKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.ScalarsKt;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonDslKt;
import runtime.logging.JsonLogEventsLayoutKt;
import runtime.logging.SuppressedConnectionErrors;
import runtime.logging.SuppressedError;
import runtime.system.JStack;
import runtime.utils.HostKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001bJ\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0002H\u0014J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020\u0002H\u0002J\u001c\u0010*\u001a\u00020\u001e2\n\u0010+\u001a\u00060,j\u0002`-2\u0006\u0010.\u001a\u00020/H\u0002JK\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u00052\n\u0010+\u001a\u00060,j\u0002`-2\u0006\u0010.\u001a\u00020/2\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001e06H\u0002\u00a2\u0006\u0002\u00107J,\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000509*\u00020#2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000509H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0018\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lruntime/logging/JsonLogEventsLayout;", "Lch/qos/logback/core/LayoutBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "()V", "app", "", "getApp", "()Ljava/lang/String;", "setApp", "(Ljava/lang/String;)V", "hostName", "getHostName", "setHostName", "mdcKeysAsFields", "", "Llibraries/klogging/MDCKey;", "getMdcKeysAsFields", "()Ljava/util/List;", "mdcKeysToRemove", "getMdcKeysToRemove", "region", "getRegion", "suppressedConnectionErrors", "Lruntime/logging/SuppressedConnectionErrors;", "suppressedErrors", "Ljava/util/HashMap;", "", "Lruntime/logging/SuppressedError;", "Lkotlin/collections/HashMap;", "addSuppressedConnectionErrors", "", "addSuppressedError", "suppressedError", "customJsonFields", "jsonBuilderContext", "Lruntime/json/JsonBuilderContext;", "event", "doLayout", "isOOM", "", "isSuppressed", "maybeThreadDump", "print", "s", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "th", "Lch/qos/logback/classic/spi/IThrowableProxy;", "printEnclosedStackTrace", "caption", "enclosingTrace", "", "Lch/qos/logback/classic/spi/StackTraceElementProxy;", "used", "Ljava/util/IdentityHashMap;", "(Ljava/lang/String;Ljava/lang/StringBuilder;Lch/qos/logback/classic/spi/IThrowableProxy;[Lch/qos/logback/classic/spi/StackTraceElementProxy;Ljava/util/IdentityHashMap;)V", "preProcessMDCMap", "", "initialMDCMap", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nJsonLogEventsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/JsonLogEventsLayout\n+ 2 jsonDsl.kt\nruntime/json/JsonDslKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 jsonDsl.kt\nruntime/json/JsonBuilderContext\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,319:1\n143#2:320\n277#2,3:321\n281#2,3:325\n1#3:324\n1#3:330\n54#4,2:328\n56#4,2:331\n1747#5,3:333\n1855#5,2:338\n1549#5:340\n1620#5,3:341\n1549#5:344\n1620#5,3:345\n1247#6,2:336\n26#7:348\n26#7:349\n*S KotlinDebug\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/JsonLogEventsLayout\n*L\n84#1:320\n84#1:321,3\n84#1:325,3\n84#1:324\n141#1:328,2\n141#1:331,2\n167#1:333,3\n187#1:338,2\n191#1:340\n191#1:341,3\n191#1:344\n191#1:345,3\n184#1:336,2\n200#1:348\n216#1:349\n*E\n"})
public class JsonLogEventsLayout
extends LayoutBase<ILoggingEvent> {
    @Nullable
    private final String region = HostKt.getApplication_region();
    @Nullable
    private String hostName;
    @Nullable
    private String app;
    @NotNull
    private final SuppressedConnectionErrors suppressedConnectionErrors = new SuppressedConnectionErrors();
    @NotNull
    private final HashMap<String, List<SuppressedError>> suppressedErrors = new HashMap();
    @NotNull
    private final List<MDCKey> mdcKeysAsFields = PlatformMDCKey.Companion.getBase();
    @NotNull
    private final List<MDCKey> mdcKeysToRemove = PlatformMDCKey.Companion.getSensitive();

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    @Nullable
    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(@Nullable String string2) {
        this.hostName = string2;
    }

    @Nullable
    public final String getApp() {
        return this.app;
    }

    public final void setApp(@Nullable String string2) {
        this.app = string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String doLayout(@NotNull ILoggingEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        try {
            void $this$doLayout_u24lambda_u240;
            boolean $i$f$jsonObjectText = false;
            ObjectMapper objectMapper = JsonDslKt.getJsonTreeParser();
            Object baseObj$iv$iv = null;
            boolean $i$f$objectNode = false;
            JsonNodeFactory factory$iv$iv = new JsonNodeFactory(false);
            ObjectNode rootNode$iv$iv = factory$iv$iv.objectNode();
            Intrinsics.checkNotNull((Object)rootNode$iv$iv);
            JsonBuilderContext jsonBuilderContext = new JsonBuilderContext(rootNode$iv$iv, factory$iv$iv, JsonDslKt.getJsonTreeParser());
            ObjectMapper objectMapper2 = objectMapper;
            boolean bl = false;
            $this$doLayout_u24lambda_u240.put("@version", 1);
            $this$doLayout_u24lambda_u240.put("@timestamp", JsonLogEventsLayoutKt.dateFormat(event2.getTimeStamp()));
            this.customJsonFields((JsonBuilderContext)$this$doLayout_u24lambda_u240, event2);
            String string2 = objectMapper2.writeValueAsString((Object)rootNode$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
            String logstashEvent = string2;
            return logstashEvent + "\n";
        }
        catch (Throwable e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)stackTrace, true));
            return "FAILED TO LAYOUT A LOG EVENT\nEvent: " + event2 + "\nError: " + e + "\n" + stackTrace;
        }
    }

    public final void addSuppressedConnectionErrors(@NotNull SuppressedConnectionErrors suppressedConnectionErrors) {
        Intrinsics.checkNotNullParameter((Object)suppressedConnectionErrors, (String)"suppressedConnectionErrors");
        this.suppressedConnectionErrors.plusAssign(suppressedConnectionErrors);
    }

    public final void addSuppressedError(@NotNull SuppressedError suppressedError) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)suppressedError, (String)"suppressedError");
            String string2 = suppressedError.getLoggerName();
            if (string2 == null) break block2;
            String it = string2;
            boolean bl = false;
            List<SuppressedError> list2 = this.suppressedErrors.get(it);
            if (list2 != null) {
                list2.add(suppressedError);
            } else {
                JsonLogEventsLayout $this$addSuppressedError_u24lambda_u242_u24lambda_u241 = this;
                boolean bl2 = false;
                Map map2 = $this$addSuppressedError_u24lambda_u242_u24lambda_u241.suppressedErrors;
                Object object = new SuppressedError[]{suppressedError};
                object = CollectionsKt.mutableListOf((Object[])object);
                map2.put(it, object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void customJsonFields(@NotNull JsonBuilderContext jsonBuilderContext, @NotNull ILoggingEvent event2) {
        IThrowableProxy iThrowableProxy;
        JsonBuilderContext jsonBuilderContext2;
        Intrinsics.checkNotNullParameter((Object)jsonBuilderContext, (String)"jsonBuilderContext");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Level level = null;
        level = event2.getLevel();
        if (Intrinsics.areEqual((Object)level, (Object)Level.ERROR) && this.isSuppressed(event2)) {
            level = Level.WARN;
        }
        String threadDump = this.maybeThreadDump(event2);
        JsonBuilderContext $this$customJsonFields_u24lambda_u2410 = jsonBuilderContext2 = jsonBuilderContext;
        boolean bl = false;
        String string2 = this.hostName;
        if (string2 == null) {
            string2 = JsonLogEventsLayoutKt.access$getComputedHostName();
        }
        $this$customJsonFields_u24lambda_u2410.put("source_host", string2);
        String string3 = this.region;
        if (string3 != null) {
            String it = string3;
            boolean bl2 = false;
            $this$customJsonFields_u24lambda_u2410.put("region", it);
        }
        JsonLogEventsLayoutKt.putLogAppVersion($this$customJsonFields_u24lambda_u2410);
        $this$customJsonFields_u24lambda_u2410.put("message", event2.getFormattedMessage());
        String string4 = this.app;
        if (string4 == null) {
            string4 = "platform";
        }
        $this$customJsonFields_u24lambda_u2410.put("app", string4);
        IThrowableProxy iThrowableProxy2 = iThrowableProxy = event2.getThrowableProxy();
        if (iThrowableProxy2 != null) {
            String it;
            void this_$iv;
            Intrinsics.checkNotNull((Object)iThrowableProxy2);
            IThrowableProxy proxy = iThrowableProxy;
            boolean bl3 = false;
            JsonBuilderContext jsonBuilderContext3 = $this$customJsonFields_u24lambda_u2410;
            String $this$put$iv = "exception";
            boolean $i$f$put = false;
            ObjectNode objNode$iv = this_$iv.get__factory().objectNode();
            Intrinsics.checkNotNull((Object)objNode$iv);
            JsonBuilderContext $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = new JsonBuilderContext(objNode$iv, this_$iv.get__factory(), this_$iv.get__mapper());
            boolean bl4 = false;
            CharSequence charSequence = proxy.getClassName();
            String string5 = charSequence;
            if (string5 != null) {
                Intrinsics.checkNotNull((Object)string5);
                it = charSequence;
                boolean bl5 = false;
                $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248.put("exception_class", it);
            }
            charSequence = proxy.getMessage();
            String string6 = charSequence;
            if (string6 != null) {
                Intrinsics.checkNotNull((Object)string6);
                it = charSequence;
                boolean bl6 = false;
                $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248.put("exception_message", it);
            }
            CharSequence $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u246 = charSequence = new StringBuilder();
            boolean bl7 = false;
            this.print((StringBuilder)$this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u246, proxy);
            String string7 = ((StringBuilder)charSequence).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"StringBuilder().apply(builderAction).toString()");
            String it2 = string7;
            boolean bl8 = false;
            $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248.put("stacktrace", it2);
            this_$iv.get__node().set($this$put$iv, (JsonNode)objNode$iv);
        }
        $this$customJsonFields_u24lambda_u2410.put("logger_name", event2.getLoggerName());
        Map map2 = event2.getMDCPropertyMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getMDCPropertyMap(...)");
        $this$customJsonFields_u24lambda_u2410.put("mdc", this.preProcessMDCMap($this$customJsonFields_u24lambda_u2410, map2));
        $this$customJsonFields_u24lambda_u2410.put("level", level.toString());
        $this$customJsonFields_u24lambda_u2410.put("thread_name", event2.getThreadName());
        if (threadDump != null) {
            $this$customJsonFields_u24lambda_u2410.put("thread_dump", threadDump);
        }
    }

    private final boolean isSuppressed(ILoggingEvent event2) {
        Boolean bl;
        List<SuppressedError> list2 = this.suppressedErrors.get(event2.getLoggerName());
        if (list2 != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SuppressedError it = (SuppressedError)element$iv;
                        boolean bl3 = false;
                        if (!it.match(event2)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = null;
        }
        return ScalarsKt.orFalse(bl) || this.suppressedConnectionErrors.match(event2) || this.isOOM(event2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String maybeThreadDump(ILoggingEvent event2) {
        String string2;
        if (!this.isOOM(event2)) return null;
        String string3 = event2.getFormattedMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFormattedMessage(...)");
        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"unable to create native thread", (boolean)false, (int)2, null)) return null;
        try {
            string2 = JStack.dumpThreads$default(JStack.INSTANCE, null, 1, null);
        }
        catch (Throwable t) {
            return null;
        }
        String string4 = string2;
        return string4;
    }

    private final boolean isOOM(ILoggingEvent event2) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = JsonLogEventsLayoutKt.access$getAllCauses(event2.getThrowableProxy());
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IThrowableProxy it = (IThrowableProxy)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)"java.lang.OutOfMemoryError")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final Map<String, String> preProcessMDCMap(JsonBuilderContext $this$preProcessMDCMap, Map<String, String> initialMDCMap) {
        MDCKey it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$forEach$iv = this.getMdcKeysAsFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MDCKey it2 = (MDCKey)element$iv;
            boolean bl = false;
            MDCUtilsKt.extractFieldFromMap($this$preProcessMDCMap, initialMDCMap, it2);
        }
        $this$forEach$iv = this.getMdcKeysToRemove();
        Map map2 = initialMDCMap;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MDCKey mDCKey = (MDCKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        $this$map$iv = this.getMdcKeysAsFields();
        map2 = MapsKt.minus(map2, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MDCKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return MapsKt.minus((Map)map2, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    protected List<MDCKey> getMdcKeysAsFields() {
        return this.mdcKeysAsFields;
    }

    @NotNull
    protected List<MDCKey> getMdcKeysToRemove() {
        return this.mdcKeysToRemove;
    }

    private final void print(StringBuilder s, IThrowableProxy th) {
        IdentityHashMap<IThrowableProxy, Unit> used = new IdentityHashMap<IThrowableProxy, Unit>();
        boolean $i$f$emptyArray = false;
        this.printEnclosedStackTrace("", s, th, new StackTraceElementProxy[0], used);
    }

    /*
     * WARNING - void declaration
     */
    private final void printEnclosedStackTrace(String caption, StringBuilder s, IThrowableProxy th, StackTraceElementProxy[] enclosingTrace, IdentityHashMap<IThrowableProxy, Unit> used) {
        block12: {
            Object object;
            String string2;
            String string3;
            StringBuilder stringBuilder;
            int framesInCommon;
            int m2;
            StackTraceElementProxy[] trace2;
            block14: {
                block13: {
                    void it;
                    StackTraceElementProxy[] stackTraceElementProxyArray;
                    block11: {
                        if (!((Map)used).containsKey(th)) break block11;
                        StringBuilder stringBuilder2 = s.append("\tCIRCULAR: " + th.getClassName());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                        break block12;
                    }
                    ((Map)used).put(th, Unit.INSTANCE);
                    StackTraceElementProxy[] stackTraceElementProxyArray2 = th.getStackTraceElementProxyArray();
                    if (stackTraceElementProxyArray2 == null) {
                        boolean $i$f$emptyArray = false;
                        stackTraceElementProxyArray = new StackTraceElementProxy[]{};
                    } else {
                        stackTraceElementProxyArray = stackTraceElementProxyArray2;
                    }
                    trace2 = stackTraceElementProxyArray;
                    m2 = trace2.length - 1;
                    for (int n = enclosingTrace.length - 1; m2 >= 0 && n >= 0 && Intrinsics.areEqual((Object)trace2[m2], (Object)enclosingTrace[n]); --m2, --n) {
                    }
                    framesInCommon = trace2.length - 1 - m2;
                    stringBuilder = s;
                    string3 = caption;
                    string2 = th.getClassName();
                    object = th.getMessage();
                    if (object == null) break block13;
                    String string4 = object;
                    String string5 = string2;
                    String string6 = string3;
                    boolean bl = false;
                    String string7 = " " + (String)it;
                    string3 = string6;
                    string2 = string5;
                    String string8 = string7;
                    object = string8;
                    if (string8 != null) break block14;
                }
                object = "";
            }
            StringBuilder stringBuilder3 = stringBuilder.append(string3 + string2 + (String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            int i = 0;
            int n = m2;
            if (i <= n) {
                while (true) {
                    StringBuilder stringBuilder4 = s.append("\t" + trace2[i].getSTEAsString());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                    if (i == n) break;
                    ++i;
                }
            }
            if (framesInCommon != 0) {
                StringBuilder stringBuilder5 = s.append("\t... " + framesInCommon + " more");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            }
            IThrowableProxy[] iThrowableProxyArray = th.getSuppressed();
            Intrinsics.checkNotNullExpressionValue((Object)iThrowableProxyArray, (String)"getSuppressed(...)");
            for (IThrowableProxy se : iThrowableProxyArray) {
                Intrinsics.checkNotNull((Object)se);
                this.printEnclosedStackTrace("Suppressed: ", s, se, trace2, used);
            }
            IThrowableProxy cause = th.getCause();
            if (cause != null) {
                this.printEnclosedStackTrace("Caused by: ", s, cause, trace2, used);
            }
        }
    }
}

