/*
 * Decompiled with CFR 0.152.
 */
package runtime.system;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import runtime.system.JStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a8\u0006\t"}, d2={"Lruntime/system/JStack;", "", "()V", "dumpThreads", "", "threadSelector", "Lkotlin/Function1;", "Ljava/lang/Thread;", "", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nJStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JStack.kt\nruntime/system/JStack\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,98:1\n8541#2,2:99\n8801#2,4:101\n*S KotlinDebug\n*F\n+ 1 JStack.kt\nruntime/system/JStack\n*L\n11#1:99,2\n11#1:101,4\n*E\n"})
public final class JStack {
    @NotNull
    public static final JStack INSTANCE = new JStack();

    private JStack() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpThreads(@NotNull Function1<? super Thread, Boolean> threadSelector) {
        Object object;
        Intrinsics.checkNotNullParameter(threadSelector, (String)"threadSelector");
        StringBuilder $this$dumpThreads_u24lambda_u242 = new StringBuilder();
        boolean bl = false;
        try {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfoArray = bean.dumpAllThreads(true, true);
            Intrinsics.checkNotNullExpressionValue((Object)threadInfoArray, (String)"dumpAllThreads(...)");
            Object[] $this$associateBy$iv = threadInfoArray;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Object[] object2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : object2) {
                void it;
                ThreadInfo threadInfo = (ThreadInfo)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl2 = false;
                map2.put(it.getThreadId(), element$iv$iv);
            }
            object = destination$iv$iv;
        }
        catch (Throwable t) {
            object = MapsKt.emptyMap();
        }
        Map threadsInfos = object;
        Object $this$dumpThreads_u24lambda_u242_u24lambda_u241 = object = new StringBuilder();
        boolean bl3 = false;
        StringBuilder stringBuilder = ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("Full thread dump ").append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.vm.version")).append(" ").append(System.getProperty("java.vm.info"));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        Map<Thread, StackTraceElement[]> map3 = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"getAllStackTraces(...)");
        for (Map.Entry<Thread, StackTraceElement[]> entry : map3.entrySet()) {
            LockInfo[] locks;
            ThreadInfo thInfo;
            ThreadGroup group;
            Thread thread = entry.getKey();
            StackTraceElement[] stackTrace = entry.getValue();
            Intrinsics.checkNotNull((Object)thread);
            if (!((Boolean)threadSelector.invoke((Object)thread)).booleanValue()) continue;
            ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("\"" + thread.getName() + "\" ");
            if (thread.isDaemon()) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("daemon ");
            }
            if ((group = thread.getThreadGroup()) != null) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("group=\"" + group.getName() + "\" ");
            }
            ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("prio=" + thread.getPriority() + " ");
            ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("tid=" + thread.getId() + " ");
            ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("nid=" + thread.getId() + " ");
            Thread.State state2 = thread.getState();
            if (state2 == Thread.State.RUNNABLE) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("runnable ");
            }
            if (state2 == Thread.State.WAITING || state2 == Thread.State.TIMED_WAITING) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("waiting ");
            }
            if (state2 == Thread.State.BLOCKED) {
                ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("blocked ");
            }
            if ((thInfo = (ThreadInfo)threadsInfos.get(thread.getId())) != null) {
                if (thInfo.getLockName() != null) {
                    ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("on " + thInfo.getLockName());
                }
                if (thInfo.getLockOwnerName() != null) {
                    ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append(" owned by \"").append(thInfo.getLockOwnerName()).append("\" Id=").append(thInfo.getLockOwnerId());
                }
                if (thInfo.isSuspended()) {
                    ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append(" (suspended)");
                }
                if (thInfo.isInNative()) {
                    ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append(" (in native)");
                }
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append('\n'), (String)"append('\\n')");
                StringBuilder stringBuilder2 = ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("   java.lang.Thread.State: " + state2.name());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append('\n'), (String)"append('\\n')");
            }
            int i = -1;
            Intrinsics.checkNotNull((Object)stackTrace);
            StackTraceElement[] bl2 = stackTrace;
            int n = bl2.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo[] monitorInfoArray;
                StackTraceElement ste = bl2[j];
                ++i;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("\tat "), (String)"append(...)");
                StringBuilder stringBuilder3 = monitorInfoArray.append(ste.toString());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                if (thInfo == null) continue;
                if (i == 0 && thInfo.getLockInfo() != null) {
                    Thread.State state3 = thInfo.getThreadState();
                    switch (state3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[state3.ordinal()]) {
                        case 1: {
                            StringBuilder stringBuilder8;
                            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("\t\t-  blocked on "), (String)"append(...)");
                            StringBuilder stringBuilder4 = stringBuilder8.append(thInfo.getLockInfo());
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                            break;
                        }
                        case 2: {
                            StringBuilder stringBuilder5;
                            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("\t\t-  waiting on "), (String)"append(...)");
                            StringBuilder stringBuilder6 = stringBuilder5.append(thInfo.getLockInfo());
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
                            break;
                        }
                        case 3: {
                            StringBuilder stringBuilder7;
                            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("\t\t-  waiting on "), (String)"append(...)");
                            StringBuilder stringBuilder8 = stringBuilder7.append(thInfo.getLockInfo());
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
                        }
                    }
                }
                MonitorInfo[] monitorInfoArray2 = thInfo.getLockedMonitors();
                Intrinsics.checkNotNullExpressionValue((Object)monitorInfoArray2, (String)"getLockedMonitors(...)");
                monitorInfoArray = monitorInfoArray2;
                int stringBuilder6 = monitorInfoArray.length;
                for (int k = 0; k < stringBuilder6; ++k) {
                    MonitorInfo mi = monitorInfoArray[k];
                    if (mi.getLockedStackDepth() != i) continue;
                    StringBuilder stringBuilder9 = ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("\t-  locked ");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
                    StringBuilder stringBuilder10 = stringBuilder9.append(mi);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append('\\n')");
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append('\n'), (String)"append('\\n')");
            if (thInfo == null || (locks = thInfo.getLockedSynchronizers()) == null || !(!(locks.length == 0))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder11 = ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("  Locked ownable synchronizers:\n");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
            for (LockInfo lock : locks) {
                StringBuilder stringBuilder12 = ((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append("\t- " + lock);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append('\\n')");
            }
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append('\n'), (String)"append('\\n')");
        }
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$dumpThreads_u24lambda_u242_u24lambda_u241).append('\n'), (String)"append('\\n')");
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String dumpThreads$default(JStack jStack, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = dumpThreads.1.INSTANCE;
        }
        return jStack.dumpThreads((Function1<? super Thread, Boolean>)function1);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Thread.State.values().length];
            try {
                nArray[Thread.State.BLOCKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.WAITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.TIMED_WAITING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

