/*
 * Decompiled with CFR 0.152.
 */
package runtime.text;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.text.BOM;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"detectBOM", "Lruntime/text/BOM;", "bytes", "", "fileContentToString", "", "encoding", "Ljava/nio/charset/Charset;", "defaultEncoding", "isBinaryFileContent", "", "isControlChar", "ch", "", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nFileContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContent.kt\nruntime/text/FileContentKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n288#2:74\n1726#2,3:75\n289#2:78\n1#3:79\n*S KotlinDebug\n*F\n+ 1 FileContent.kt\nruntime/text/FileContentKt\n*L\n55#1:74\n56#1:75,3\n55#1:78\n*E\n"})
public final class FileContentKt {
    public static final boolean isBinaryFileContent(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (FileContentKt.detectBOM(bytes) != null) {
            return false;
        }
        int controlChars = 0;
        for (byte by : bytes) {
            if (!FileContentKt.isControlChar(by)) continue;
            ++controlChars;
        }
        int n = bytes.length;
        if (n == 0) {
            return false;
        }
        int threshold = (1 <= n ? n < 256 : false) ? 1 : Math.min(bytes.length / 100, 100);
        return controlChars >= threshold;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isControlChar(byte ch) {
        boolean bl;
        byte by = ch;
        if (0 <= by) {
            if (by < 8) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        by = ch;
        if (14 > by) return false;
        if (by >= 26) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final BOM detectBOM(@NotNull byte[] bytes) {
        Object element$iv;
        Object v0;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Iterable $this$firstOrNull$iv = (Iterable)BOM.getEntries();
        boolean $i$f$firstOrNull = false;
        Iterator iterator2 = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator2.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator2.next();
            BOM bom = (BOM)((Object)element$iv);
            boolean bl2 = false;
            if (bytes.length >= bom.getBom().length) {
                boolean bl3;
                block7: {
                    Iterable $this$all$iv = (Iterable)ArraysKt.getIndices((byte[])bom.getBom());
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        Iterator iterator3 = $this$all$iv.iterator();
                        while (iterator3.hasNext()) {
                            int element$iv2;
                            int it = element$iv2 = ((IntIterator)iterator3).nextInt();
                            boolean bl4 = false;
                            if (bom.getBom()[it] == bytes[it]) continue;
                            bl3 = false;
                            break block7;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String fileContentToString(@NotNull byte[] bytes, @Nullable String defaultEncoding) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        v0 = bytes;
        v1 = defaultEncoding;
        if (v1 == null) ** GOTO lbl-1000
        var3_3 = var2_2 = v1;
        var5_4 = v0;
        $i$a$-takeIf-FileContentKt$fileContentToString$1 = false;
        var6_6 = Charset.isSupported(it);
        v0 = var5_4;
        v1 = var6_6 != false ? var2_2 : null;
        if (v1 != null) {
            it = v1;
            var5_4 = v0;
            $i$a$-let-FileContentKt$fileContentToString$2 = false;
            v2 = Charset.forName(it);
            v0 = var5_4;
        } else lbl-1000:
        // 2 sources

        {
            v2 = v3 = null;
        }
        if (v2 == null) {
            v3 = Charsets.UTF_8;
        }
        return FileContentKt.fileContentToString(v0, v3);
    }

    public static /* synthetic */ String fileContentToString$default(byte[] byArray, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return FileContentKt.fileContentToString(byArray, string2);
    }

    @NotNull
    public static final String fileContentToString(@NotNull byte[] bytes, @NotNull Charset encoding) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        BOM bom = FileContentKt.detectBOM(bytes);
        if (bom != null) {
            return new String(bytes, bom.getBom().length, bytes.length - bom.getBom().length, bom.getCharset());
        }
        return new String(bytes, encoding);
    }
}

