/*
 * Decompiled with CFR 0.152.
 */
package runtime.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.text.TextRange;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0016\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0011*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0011*\u00020\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a*\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c\u001a\n\u0010\u001d\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u001e\u001a\u00020\u0002*\u00020\n\u001a\n\u0010\u001f\u001a\u00020\r*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006 "}, d2={"end", "", "Lruntime/text/TextRange;", "getEnd", "(Lruntime/text/TextRange;)I", "rangeBetween", "start", "rangeOf", "length", "r", "Lkotlin/ranges/IntRange;", "textRangeFromUrlString", "value", "", "coerce", "limits", "contains", "", "offset", "other", "intersectsStrict", "isEmpty", "isNotEmpty", "shift", "delta", "subtractAll", "", "ranges", "", "toRange", "toTextRange", "toUrlString", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nTextRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRange.kt\nruntime/text/TextRangeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n1045#3:60\n*S KotlinDebug\n*F\n+ 1 TextRange.kt\nruntime/text/TextRangeKt\n*L\n43#1:60\n*E\n"})
public final class TextRangeKt {
    public static final int getEnd(@NotNull TextRange $this$end) {
        Intrinsics.checkNotNullParameter((Object)$this$end, (String)"<this>");
        return $this$end.getStart() + $this$end.getLength();
    }

    @NotNull
    public static final TextRange rangeOf(int start2, int length) {
        if (!(start2 >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(length >= 0)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        return new TextRange(start2, length);
    }

    @NotNull
    public static final TextRange rangeOf(@NotNull IntRange r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new TextRange(r.getFirst(), r.getLast() - r.getFirst() + 1);
    }

    @NotNull
    public static final TextRange rangeBetween(int start2, int end) {
        if (!(start2 >= 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(end >= start2)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        return new TextRange(start2, end - start2);
    }

    @NotNull
    public static final TextRange toTextRange(@NotNull IntRange $this$toTextRange) {
        Intrinsics.checkNotNullParameter((Object)$this$toTextRange, (String)"<this>");
        return TextRangeKt.rangeOf($this$toTextRange);
    }

    @NotNull
    public static final IntRange toRange(@NotNull TextRange $this$toRange) {
        Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"<this>");
        return new IntRange($this$toRange.getStart(), $this$toRange.getStart() + $this$toRange.getLength() - 1);
    }

    public static final boolean intersectsStrict(@NotNull TextRange $this$intersectsStrict, @NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)$this$intersectsStrict, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.max($this$intersectsStrict.getStart(), other.getStart()) < Math.min(TextRangeKt.getEnd($this$intersectsStrict), TextRangeKt.getEnd(other));
    }

    @NotNull
    public static final TextRange shift(@NotNull TextRange $this$shift, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$shift, (String)"<this>");
        return new TextRange($this$shift.getStart() + delta, $this$shift.getLength());
    }

    @NotNull
    public static final TextRange coerce(@NotNull TextRange $this$coerce, @NotNull TextRange limits) {
        Intrinsics.checkNotNullParameter((Object)$this$coerce, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)limits, (String)"limits");
        int start2 = Math.max($this$coerce.getStart(), limits.getStart());
        boolean bl = false;
        return new TextRange(start2, Math.min(TextRangeKt.getEnd($this$coerce), TextRangeKt.getEnd(limits)) - start2);
    }

    public static final boolean contains(@NotNull TextRange $this$contains, @NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$contains.getStart() <= other.getStart() && TextRangeKt.getEnd($this$contains) >= TextRangeKt.getEnd(other);
    }

    public static final boolean contains(@NotNull TextRange $this$contains, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        return $this$contains.getStart() <= offset && offset < TextRangeKt.getEnd($this$contains);
    }

    public static final boolean isEmpty(@NotNull TextRange $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.getLength() <= 0;
    }

    public static final boolean isNotEmpty(@NotNull TextRange $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return $this$isNotEmpty.getLength() > 0;
    }

    @NotNull
    public static final List<TextRange> subtractAll(@NotNull TextRange $this$subtractAll, @NotNull Collection<TextRange> ranges2) {
        Intrinsics.checkNotNullParameter((Object)$this$subtractAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        int pos = $this$subtractAll.getStart();
        Iterable $this$sortedBy$iv = ranges2;
        boolean $i$f$sortedBy = false;
        for (TextRange range3 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
            }
        })) {
            TextRangeKt.subtractAll$tryAddToResult(result2, pos, Math.min(range3.getStart(), TextRangeKt.getEnd($this$subtractAll)));
            pos = Math.max(TextRangeKt.getEnd(range3), pos);
        }
        TextRangeKt.subtractAll$tryAddToResult(result2, pos, TextRangeKt.getEnd($this$subtractAll));
        return result2;
    }

    @NotNull
    public static final String toUrlString(@NotNull TextRange $this$toUrlString) {
        Intrinsics.checkNotNullParameter((Object)$this$toUrlString, (String)"<this>");
        return $this$toUrlString.getStart() + "+" + $this$toUrlString.getLength();
    }

    @NotNull
    public static final TextRange textRangeFromUrlString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return new TextRange(Integer.parseInt(StringsKt.substringBefore$default((String)value2, (String)"+", null, (int)2, null)), Integer.parseInt(StringsKt.substringAfter$default((String)value2, (String)"+", null, (int)2, null)));
    }

    private static final void subtractAll$tryAddToResult(ArrayList<TextRange> result2, int start2, int end) {
        if (start2 < end) {
            result2.add(new TextRange(start2, end - start2));
        }
    }
}

