/*
 * Decompiled with CFR 0.152.
 */
package runtime.ui;

import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import kotlinx.css.Color;
import kotlinx.css.ColorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lruntime/ui/LabColor;", "", "light", "", "a", "b", "(DDD)V", "getA", "()D", "getB", "getLight", "toColor", "Lkotlinx/css/Color;", "Companion", "platform-ui"})
public final class LabColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double light;
    private final double a;
    private final double b;
    private static final int Kn = 18;
    private static final double Xn = 0.95047;
    private static final double Yn = 1.0;
    private static final double Zn = 1.08883;
    private static final double t0 = 0.13793103448275862;
    private static final double t1 = 0.20689655172413793;
    private static final double t2 = 0.12841854934601665;
    private static final double t3 = 0.008856451679035631;

    public LabColor(double light, double a, double b) {
        this.light = light;
        this.a = a;
        this.b = b;
    }

    public final double getLight() {
        return this.light;
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    @NotNull
    public final Color toColor() {
        double l = this.light;
        double a = this.a;
        double b = this.b;
        double y = (l + (double)16) / (double)116;
        double x = Double.isNaN(a) ? y : y + a / (double)500;
        double z = Double.isNaN(b) ? y : y - b / (double)200;
        double y2 = Yn * LabColor.Companion.lab2xyz(y);
        double x2 = Xn * LabColor.Companion.lab2xyz(x);
        double z2 = Zn * LabColor.Companion.lab2xyz(z);
        int red = LabColor.Companion.xyz2rgb(3.2404542 * x2 - 1.5371385 * y2 - 0.4985314 * z2);
        int green = LabColor.Companion.xyz2rgb(-0.969266 * x2 + 1.8760108 * y2 + 0.041556 * z2);
        int blue = LabColor.Companion.xyz2rgb(0.0556434 * x2 - 0.2040259 * y2 + 1.0572252 * z2);
        return ColorKt.rgb((int)red, (int)green, (int)blue);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J2\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lruntime/ui/LabColor$Companion;", "", "()V", "Kn", "", "Xn", "", "Yn", "Zn", "t0", "t1", "t2", "t3", "fromRGB", "Lruntime/ui/LabColor;", "red", "green", "blue", "lab2xyz", "t", "rgb2xyz", "channel", "Lkotlin/Triple;", "xyz2lab", "xyz2rgb", "r", "platform-ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LabColor fromRGB(int red, int green, int blue) {
            Triple<Double, Double, Double> triple = this.rgb2xyz(red, green, blue);
            double x = ((Number)triple.component1()).doubleValue();
            double y = ((Number)triple.component2()).doubleValue();
            double z = ((Number)triple.component3()).doubleValue();
            double light = (double)116 * y - (double)16;
            return new LabColor(RangesKt.coerceAtLeast((double)light, (double)0.0), (double)500 * (x - y), (double)200 * (y - z));
        }

        private final Triple<Double, Double, Double> rgb2xyz(int red, int green, int blue) {
            double r = this.rgb2xyz(red);
            double g = this.rgb2xyz(green);
            double b = this.rgb2xyz(blue);
            double x = this.xyz2lab((0.4124564 * r + 0.3575761 * g + 0.1804375 * b) / Xn);
            double y = this.xyz2lab((0.2126729 * r + 0.7151522 * g + 0.072175 * b) / Yn);
            double z = this.xyz2lab((0.0193339 * r + 0.119192 * g + 0.9503041 * b) / Zn);
            return new Triple((Object)x, (Object)y, (Object)z);
        }

        private final double rgb2xyz(int channel2) {
            double r = (double)channel2 / (double)255;
            return r <= 0.04045 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        }

        private final int xyz2rgb(double r) {
            return (int)((double)255 * (r <= 0.00304 ? 12.92 * r : 1.055 * Math.pow(r, 0.4166666666666667) - 0.055));
        }

        private final double xyz2lab(double t) {
            return t > 0.008856451679035631 ? Math.pow(t, 0.3333333333333333) : t / 0.12841854934601665 + 0.13793103448275862;
        }

        private final double lab2xyz(double t) {
            return t > 0.20689655172413793 ? t * t * t : 0.12841854934601665 * (t - 0.13793103448275862);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

