/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import runtime.utils.NotSupportedInRpc;
import runtime.utils.SHA1Hasher;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u00012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"calculateApiHash", "", "api", "Lkotlin/reflect/KClass;", "calculateDeepHashForMethod", "f", "Lkotlin/reflect/KFunction;", "calculateDeepHashForType", "ktype", "Lkotlin/reflect/KType;", "platform-runtime"})
@JvmName(name="ApiHashCalculatorKt")
@SourceDebugExtension(value={"SMAP\nSHA1Hasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SHA1Hasher.kt\nruntime/utils/ApiHashCalculatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1045#2:93\n1855#2:94\n766#2:95\n857#2,2:96\n1855#2,2:98\n1856#2:100\n766#2:101\n857#2,2:102\n1855#2:104\n1856#2:106\n1855#2,2:107\n766#2:109\n857#2,2:110\n1045#2:112\n1855#2,2:113\n1#3:105\n*S KotlinDebug\n*F\n+ 1 SHA1Hasher.kt\nruntime/utils/ApiHashCalculatorKt\n*L\n12#1:93\n12#1:94\n16#1:95\n16#1:96,2\n16#1:98,2\n12#1:100\n29#1:101\n29#1:102,2\n29#1:104\n29#1:106\n41#1:107,2\n52#1:109\n52#1:110,2\n53#1:112\n54#1:113,2\n*E\n"})
public final class ApiHashCalculatorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateApiHash(@NotNull KClass<?> api2) {
        Intrinsics.checkNotNullParameter(api2, (String)"api");
        SHA1Hasher hash = new SHA1Hasher();
        Iterable $this$sortedBy$iv = KClasses.getDeclaredFunctions(api2);
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KFunction it = (KFunction)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (KFunction)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            KFunction f = (KFunction)element$iv;
            boolean bl = false;
            hash.update(f.getName());
            hash.update(f.getParameters().size());
            Iterable $this$filter$iv = f.getParameters();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KParameter it = (KParameter)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getKind() == KParameter.Kind.VALUE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KParameter p2 = (KParameter)element$iv2;
                boolean bl3 = false;
                String string2 = p2.getName();
                Intrinsics.checkNotNull((Object)string2);
                hash.update(string2);
                hash.update(p2.getType().toString());
            }
            hash.update(f.getReturnType().toString());
        }
        return hash.hashAsString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateDeepHashForMethod(@NotNull KFunction<?> f) {
        Object it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        SHA1Hasher hash = new SHA1Hasher();
        hash.update(f.getName());
        Iterable $this$filter$iv = f.getParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KParameter)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == KParameter.Kind.VALUE && !it.getType().isMarkedNullable())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KParameter it2 = (KParameter)element$iv;
            boolean bl = false;
            KType type2 = it2.getType();
            if (it2.getName() != null) {
                boolean bl2 = false;
                hash.update((String)it);
            }
            hash.update(ApiHashCalculatorKt.calculateDeepHashForType(type2));
        }
        hash.update(ApiHashCalculatorKt.calculateDeepHashForType(f.getReturnType()));
        return hash.hashAsString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateDeepHashForType(@NotNull KType ktype) {
        KTypeProjection it;
        Intrinsics.checkNotNullParameter((Object)ktype, (String)"ktype");
        SHA1Hasher hash = new SHA1Hasher();
        Iterable $this$forEach$iv = ktype.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KType it2;
            it = (KTypeProjection)element$iv;
            boolean bl = false;
            if (it.getType() == null) continue;
            boolean bl2 = false;
            hash.update(ApiHashCalculatorKt.calculateDeepHashForType(it2));
        }
        if (ktype.getClassifier() instanceof KClass) {
            KClassifier kClassifier = ktype.getClassifier();
            Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
            KClass klass = (KClass)kClassifier;
            String string2 = klass.getSimpleName();
            if (string2 == null) {
                throw new NotSupportedInRpc("Anonymous classes are not supported");
            }
            String klassName = string2;
            hash.update(klassName);
            Object object = new String[]{"Array", "List"};
            if (!CollectionsKt.listOf((Object[])object).contains(klassName)) {
                void $this$forEach$iv2;
                Iterable $this$sortedBy$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                object = KClasses.getDeclaredMemberProperties((KClass)klass);
                boolean $i$f$filter = false;
                it = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KProperty1 it3 = (KProperty1)element$iv$iv;
                    boolean bl = false;
                    if (!(!it3.getReturnType().isMarkedNullable() && it3.getVisibility() == KVisibility.PUBLIC)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        KProperty1 it = (KProperty1)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (KProperty1)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    KProperty1 it4 = (KProperty1)element$iv;
                    boolean bl = false;
                    hash.update(it4.getName());
                    hash.update(ApiHashCalculatorKt.calculateDeepHashForType(it4.getReturnType()));
                }
            }
        } else {
            System.out.println((Object)(ktype + " is a type parameter, skipping"));
        }
        return hash.hashAsString();
    }
}

