/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.daemon.FrontendMarkupCacheHighlightersIdStorageKt;
import com.jetbrains.rdclient.daemon.HighlighterStorage;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0016\u0018\u0000 C2\u00020\u0001:\u0001CB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\bJ\u000e\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u0015J\u0006\u0010-\u001a\u00020(J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0/H\u0016J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001e0/J\u0018\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001e020/J\u0018\u00103\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020\bH\u0086\u0002\u00a2\u0006\u0002\u00104J\u0013\u00103\u001a\u0004\u0018\u00010\b2\u0006\u0010)\u001a\u00020\u0007H\u0086\u0002J\u000e\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\bJ\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020(2\u0006\u0010*\u001a\u00020\bH\u0016J\u000e\u0010<\u001a\u00020(2\u0006\u0010,\u001a\u00020\u001eJ\u0016\u0010=\u001a\u00020(2\u0006\u0010*\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u001eJ\u0010\u0010>\u001a\u0004\u0018\u00010\b2\u0006\u0010)\u001a\u00020\u0007J\u0017\u0010?\u001a\u0004\u0018\u0001082\u0006\u00106\u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020:H\u0016J\u000e\u0010B\u001a\u0002082\u0006\u0010,\u001a\u00020\u001eR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00070\u0010j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0007`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0010j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0014j\b\u0012\u0004\u0012\u00020\b`\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010 \u001a\u001e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u0010j\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006D"}, d2={"Lcom/jetbrains/rdclient/daemon/HighlighterStorage;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "all", "", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "getAll", "()Ljava/util/Map;", "count", "", "getCount", "()I", "highlightersBackMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "highlightersMap", "invalidHighlighters", "Ljava/util/HashSet;", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "Lkotlin/collections/HashSet;", "invalidHighlightersCount", "getInvalidHighlightersCount", "queuedForDeletion", "getQueuedForDeletion", "()Ljava/util/HashSet;", "queuedForRegistration", "Ljava/util/LinkedHashMap;", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "queuedForUpdate", "range2Lifetime", "Lcom/intellij/openapi/editor/RangeMarker;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "registeredHighlighters", "", "getRegisteredHighlighters", "()Ljava/util/Collection;", "addHighlighter", "", "id", "highlighter", "addInvalidHighlighter", "model", "clear", "flushNotDeleted", "", "flushNotRegistered", "flushNotUpdated", "", "get", "(Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;)Ljava/lang/Long;", "getLifetime", "rangeMarker", "isFlushed", "", "printQueued", "", "queueDeletion", "queueRegistration", "queueUpdate", "remove", "terminateLifetime", "(Lcom/intellij/openapi/editor/RangeMarker;)Ljava/lang/Boolean;", "toString", "updateRegistration", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nHighlighterStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlighterStorage.kt\ncom/jetbrains/rdclient/daemon/HighlighterStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,153:1\n19#2,4:154\n19#2,4:158\n19#2,4:162\n10#2:175\n1855#3,2:166\n372#4,7:168\n*S KotlinDebug\n*F\n+ 1 HighlighterStorage.kt\ncom/jetbrains/rdclient/daemon/HighlighterStorage\n*L\n72#1:154,4\n77#1:158,4\n90#1:162,4\n15#1:175\n129#1:166,2\n141#1:168,7\n*E\n"})
public class HighlighterStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final HashMap<Long, RangeHighlighterEx> highlightersMap;
    @NotNull
    private final HashMap<RangeHighlighterEx, Long> highlightersBackMap;
    @NotNull
    private final HashSet<HighlighterModel> invalidHighlighters;
    @NotNull
    private final LinkedHashMap<Long, HighlighterElement> queuedForRegistration;
    @NotNull
    private final LinkedHashMap<RangeHighlighterEx, HighlighterElement> queuedForUpdate;
    @NotNull
    private final HashSet<RangeHighlighterEx> queuedForDeletion;
    @NotNull
    private final HashMap<RangeMarker, LifetimeDefinition> range2Lifetime;
    @NotNull
    private static final Logger logger;

    public HighlighterStorage(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.highlightersMap = new HashMap();
        this.highlightersBackMap = new HashMap();
        this.invalidHighlighters = new HashSet();
        this.queuedForRegistration = new LinkedHashMap(30);
        this.queuedForUpdate = new LinkedHashMap(30);
        this.queuedForDeletion = new HashSet();
        this.range2Lifetime = new HashMap();
    }

    @NotNull
    protected final HashSet<RangeHighlighterEx> getQueuedForDeletion() {
        return this.queuedForDeletion;
    }

    @NotNull
    public final Collection<RangeHighlighterEx> getRegisteredHighlighters() {
        Collection<RangeHighlighterEx> collection = this.highlightersMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @NotNull
    public final Map<Long, RangeHighlighterEx> getAll() {
        return this.highlightersMap;
    }

    private final int getInvalidHighlightersCount() {
        return this.invalidHighlighters.size();
    }

    public final int getCount() {
        return this.highlightersMap.size() + this.getInvalidHighlightersCount();
    }

    @Nullable
    public final RangeHighlighterEx get(long id) {
        return this.highlightersMap.get(id);
    }

    @Nullable
    public final Long get(@NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        return this.highlightersBackMap.get(highlighter2);
    }

    @NotNull
    public final List<HighlighterElement> flushNotRegistered() {
        Collection<HighlighterElement> collection = this.queuedForRegistration.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        List queued = CollectionsKt.toList((Iterable)collection);
        this.queuedForRegistration.clear();
        return queued;
    }

    @NotNull
    public final List<Map.Entry<RangeHighlighterEx, HighlighterElement>> flushNotUpdated() {
        Set<Map.Entry<RangeHighlighterEx, HighlighterElement>> set = this.queuedForUpdate.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        List queued = CollectionsKt.toList((Iterable)set);
        this.queuedForUpdate.clear();
        return queued;
    }

    @NotNull
    public List<RangeHighlighterEx> flushNotDeleted() {
        List queued = CollectionsKt.toList((Iterable)this.queuedForDeletion);
        this.queuedForDeletion.clear();
        return queued;
    }

    public final void queueRegistration(@NotNull HighlighterElement model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Deferred registration for " + HighlightersUtilKt.prettyPrint(model.getHighlighter()));
        }
        ((Map)this.queuedForRegistration).put(FrontendMarkupCacheHighlightersIdStorageKt.getCacheAwareId(model.getHighlighter()), model);
    }

    public final void queueUpdate(@NotNull RangeHighlighterEx highlighter2, @NotNull HighlighterElement model) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Deferred update for " + HighlightersUtilKt.prettyPrint(model.getHighlighter()));
        }
        ((Map)this.queuedForUpdate).put(highlighter2, model);
    }

    public final boolean updateRegistration(@NotNull HighlighterElement model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (this.queuedForRegistration.containsKey(FrontendMarkupCacheHighlightersIdStorageKt.getCacheAwareId(model.getHighlighter()))) {
            ((Map)this.queuedForRegistration).put(FrontendMarkupCacheHighlightersIdStorageKt.getCacheAwareId(model.getHighlighter()), model);
            return true;
        }
        return false;
    }

    public void queueDeletion(@NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Deferred deletion from markup for " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter2));
        }
        this.queuedForDeletion.add(highlighter2);
        this.terminateLifetime((RangeMarker)highlighter2);
    }

    public final void addInvalidHighlighter(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.invalidHighlighters.add(model);
    }

    public final void addHighlighter(long id, @NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Long l = id;
        ((Map)this.highlightersMap).put(l, highlighter2);
        l = id;
        ((Map)this.highlightersBackMap).put(highlighter2, l);
    }

    @Nullable
    public final RangeHighlighterEx remove(long id) {
        if (this.queuedForRegistration.remove(id) != null) {
            return null;
        }
        RangeHighlighterEx highlighter2 = this.highlightersMap.get(id);
        if (highlighter2 == null) {
            boolean notFound2;
            boolean bl = id >= 0L && !((Collection)this.invalidHighlighters).isEmpty() && !CollectionsKt.removeAll((Iterable)this.invalidHighlighters, (Function1)((Function1)new Function1<HighlighterModel, Boolean>(id){
                final /* synthetic */ long $id;
                {
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull HighlighterModel it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getId() == this.$id;
                }
            })) ? true : (notFound2 = false);
            if (notFound2) {
                logger.warn("Deleting non-existing highlighter " + id);
            }
            return null;
        }
        this.highlightersMap.remove(id);
        this.highlightersBackMap.remove(highlighter2);
        this.terminateLifetime((RangeMarker)highlighter2);
        return highlighter2;
    }

    public final void clear() {
        this.highlightersMap.clear();
        this.highlightersBackMap.clear();
        this.invalidHighlighters.clear();
        this.queuedForRegistration.clear();
        this.queuedForDeletion.clear();
        this.queuedForUpdate.clear();
        Collection<LifetimeDefinition> collection = this.range2Lifetime.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LifetimeDefinition it = (LifetimeDefinition)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LifetimeDefinition.terminate$default((LifetimeDefinition)it, (boolean)false, (int)1, null);
        }
        this.range2Lifetime.clear();
    }

    @NotNull
    public final String printQueued() {
        String string = CollectionsKt.joinToString$default((Iterable)this.queuedForDeletion, (CharSequence)"\n", (CharSequence)"Not Deleted: {\n", (CharSequence)"},", (int)0, null, (Function1)printQueued.1.INSTANCE, (int)24, null);
        Collection<HighlighterElement> collection = this.queuedForRegistration.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        String string2 = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", (CharSequence)"Not Registered: {\n", (CharSequence)"},", (int)0, null, (Function1)printQueued.2.INSTANCE, (int)24, null);
        Collection<HighlighterElement> collection2 = this.queuedForUpdate.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        return string + string2 + CollectionsKt.joinToString$default((Iterable)collection2, (CharSequence)"\n", (CharSequence)"Not Updated: {\n", (CharSequence)"}", (int)0, null, (Function1)printQueued.3.INSTANCE, (int)24, null);
    }

    public final boolean isFlushed() {
        return this.queuedForDeletion.isEmpty() && this.queuedForRegistration.isEmpty();
    }

    @NotNull
    public final Lifetime getLifetime(@NotNull RangeHighlighterEx rangeMarker) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Map $this$getOrPut$iv = this.range2Lifetime;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(rangeMarker);
        if (value$iv == null) {
            boolean bl = false;
            LifetimeDefinition answer$iv = this.lifetime.createNested();
            $this$getOrPut$iv.put(rangeMarker, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Lifetime)object;
    }

    private final Boolean terminateLifetime(RangeMarker rangeMarker) {
        LifetimeDefinition lifetimeDefinition = this.range2Lifetime.remove(rangeMarker);
        return lifetimeDefinition != null ? Boolean.valueOf(LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null)) : null;
    }

    @NotNull
    public String toString() {
        int registered = this.highlightersMap.size();
        int invalid = this.getInvalidHighlightersCount();
        int notRegistered = this.queuedForRegistration.size();
        int notDeleted = this.queuedForDeletion.size();
        int notUpdated = this.queuedForUpdate.size();
        return "All=" + this.getCount() + "\n; Registered=" + registered + "; Invalid=" + invalid + "; NotRegistered=" + notRegistered + "; NotDeleted=" + notDeleted + "; NotUpdated=" + notUpdated;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HighlighterStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        HighlighterStorage.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/HighlighterStorage$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

