/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.services.uiContext;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.ide.model.uicontext.UiContextModel;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.services.uiContext.DefaultUiContextListener;
import com.jetbrains.rdclient.services.uiContext.UiContextListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J$\u0010\u001b\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0014J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020#J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener;", "Lcom/jetbrains/rdclient/services/uiContext/UiContextListener;", "project", "Lcom/intellij/openapi/project/Project;", "uiContext", "Lcom/jetbrains/ide/model/uicontext/UiContextModel;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/ide/model/uicontext/UiContextModel;Lcom/intellij/openapi/fileEditor/FileDocumentManager;Lcom/intellij/openapi/diagnostic/Logger;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "caretPositionChanged", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "dispose", "focusGained", "editor", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "increaseProperty", "property", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "lazyMessage", "Lkotlin/Function0;", "", "selectionChanged", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nUiContextListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiContextListener.kt\ncom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,77:1\n19#2,4:78\n*S KotlinDebug\n*F\n+ 1 UiContextListener.kt\ncom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener\n*L\n56#1:78,4\n*E\n"})
public class DefaultUiContextListener
implements UiContextListener {
    @NotNull
    private final Project project;
    @NotNull
    private final UiContextModel uiContext;
    @NotNull
    private final FileDocumentManager fileDocumentManager;
    @NotNull
    private final Logger logger;

    public DefaultUiContextListener(@NotNull Project project, @NotNull UiContextModel uiContext, @NotNull FileDocumentManager fileDocumentManager, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)fileDocumentManager, (String)"fileDocumentManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.project = project;
        this.uiContext = uiContext;
        this.fileDocumentManager = fileDocumentManager;
        this.logger = logger;
        MessageBusConnection connection = this.project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic, (Object)this);
        Topic topic2 = FileEditorManagerListener.Before.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic2, (Object)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getSelection(), (Function0<String>)((Function0)selectionChanged.1.INSTANCE));
    }

    public final void caretPositionChanged(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getNewPosition(), (Object)e.getOldPosition())) {
            return;
        }
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getCaret(), (Function0<String>)((Function0)new Function0<String>(e){
            final /* synthetic */ CaretEvent $e;
            {
                this.$e = $e;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Editor editor2 = this.$e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
                return "caret position's changed into editor with id:" + (textControlId != null ? UtilKt.toDebugString((TextControlId)textControlId) : null) + ".";
            }
        }));
    }

    protected void increaseProperty(@NotNull IOptProperty<Integer> property, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        property.set((Object)(((Number)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)property))).intValue() + 1));
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            $this$trace$iv.trace((String)lazyMessage.invoke());
        }
    }

    public final void focusGained(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getFocus(), (Function0<String>)((Function0)focusGained.1.INSTANCE));
    }

    public final void focusLost(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getFocus(), (Function0<String>)((Function0)focusLost.1.INSTANCE));
    }

    public final void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getTextControl(), (Function0<String>)((Function0)selectionChanged.2.INSTANCE));
    }

    public final void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.fileDocumentManager.getFile(event.getDocument()) instanceof LightVirtualFile) {
            return;
        }
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getDocument(), (Function0<String>)((Function0)beforeDocumentChange.1.INSTANCE));
    }

    public final void dispose() {
    }
}

