/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.auth;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.auth.SettingsSyncDefaultAuthService;
import com.intellij.ui.JBAccountInfoService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/settingsSync/auth/SettingsSyncDefaultAuthService;", "Lcom/intellij/settingsSync/auth/SettingsSyncAuthService;", "()V", "invalidatedUserId", "", "getAccountInfoService", "Lcom/intellij/ui/JBAccountInfoService;", "getAccountInfoService$intellij_settingsSync", "getUserData", "Lcom/intellij/ui/JBAccountInfoService$JBAData;", "invalidateJBA", "", "userId", "isLoggedIn", "", "isLoginAvailable", "login", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncDefaultAuthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncDefaultAuthService.kt\ncom/intellij/settingsSync/auth/SettingsSyncDefaultAuthService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n10#2:56\n*S KotlinDebug\n*F\n+ 1 SettingsSyncDefaultAuthService.kt\ncom/intellij/settingsSync/auth/SettingsSyncDefaultAuthService\n*L\n11#1:56\n*E\n"})
public final class SettingsSyncDefaultAuthService
implements SettingsSyncAuthService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile String invalidatedUserId;
    @NotNull
    private static final Logger LOG;

    @Override
    public boolean isLoggedIn() {
        JBAccountInfoService jBAccountInfoService = this.getAccountInfoService$intellij_settingsSync();
        JBAccountInfoService.JBAData userData = jBAccountInfoService != null ? jBAccountInfoService.getUserData() : null;
        return userData != null && !Intrinsics.areEqual((Object)this.invalidatedUserId, (Object)userData.id);
    }

    @Override
    @Nullable
    public JBAccountInfoService.JBAData getUserData() {
        if (ApplicationManagerEx.isInIntegrationTest()) {
            return new JBAccountInfoService.JBAData("integrationTest", "testLogin", "testEmail@example.com");
        }
        JBAccountInfoService jBAccountInfoService = this.getAccountInfoService$intellij_settingsSync();
        return jBAccountInfoService != null ? jBAccountInfoService.getUserData() : null;
    }

    @Override
    public void login() {
        block1: {
            if (this.isLoggedIn()) break block1;
            JBAccountInfoService jBAccountInfoService = this.getAccountInfoService$intellij_settingsSync();
            if (jBAccountInfoService != null) {
                jBAccountInfoService.invokeJBALogin(arg_0 -> SettingsSyncDefaultAuthService.login$lambda$0(login.1.INSTANCE, arg_0), SettingsSyncDefaultAuthService::login$lambda$1);
            }
        }
    }

    @Override
    public boolean isLoginAvailable() {
        return this.getAccountInfoService$intellij_settingsSync() != null;
    }

    @Override
    public void invalidateJBA(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (Intrinsics.areEqual((Object)this.invalidatedUserId, (Object)userId)) {
            return;
        }
        LOG.warn("Invalidating JBA");
        this.invalidatedUserId = userId;
        SettingsSyncEvents.Companion.getInstance().fireLoginStateChanged();
    }

    @Nullable
    public final JBAccountInfoService getAccountInfoService$intellij_settingsSync() {
        return JBAccountInfoService.getInstance();
    }

    private static final void login$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void login$lambda$1() {
        SettingsSyncEvents.Companion.getInstance().fireLoginStateChanged();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncDefaultAuthService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/settingsSync/auth/SettingsSyncDefaultAuthService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

