/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.symbols.psiBased.base;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.base.KtFe10Symbol;
import org.jetbrains.kotlin.analysis.api.descriptors.types.KtFe10ClassErrorType;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbolOrigin;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolKind;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0000\u001a\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"callableIdIfNonLocal", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getCallableIdIfNonLocal", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/name/CallableId;", "ktModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "getKtModality", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/descriptors/Modality;", "ktSymbolKind", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolKind;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getKtSymbolKind", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolKind;", "ktSymbolOrigin", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbolOrigin;", "getKtSymbolOrigin", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbolOrigin;", "ktVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "getKtVisibility", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "calculateCallableId", "allowLocal", "", "createErrorType", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/symbols/base/KtFe10Symbol;", "getResolutionScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lcom/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "analysis-api-fe10"})
@SourceDebugExtension(value={"SMAP\nKtFe10PsiSymbolUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFe10PsiSymbolUtils.kt\norg/jetbrains/kotlin/analysis/api/descriptors/symbols/psiBased/base/KtFe10PsiSymbolUtilsKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,150:1\n125#2:151\n*S KotlinDebug\n*F\n+ 1 KtFe10PsiSymbolUtils.kt\norg/jetbrains/kotlin/analysis/api/descriptors/symbols/psiBased/base/KtFe10PsiSymbolUtilsKt\n*L\n67#1:151\n*E\n"})
public final class KtFe10PsiSymbolUtilsKt {
    @Nullable
    public static final Visibility getKtVisibility(@NotNull KtDeclaration $this$ktVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$ktVisibility, (String)"<this>");
        return $this$ktVisibility.hasModifier(KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : ($this$ktVisibility.hasModifier(KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : ($this$ktVisibility.hasModifier(KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : ($this$ktVisibility.hasModifier(KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }

    @Nullable
    public static final Modality getKtModality(@NotNull KtDeclaration $this$ktModality) {
        Modality modality2;
        Intrinsics.checkNotNullParameter((Object)$this$ktModality, (String)"<this>");
        if ($this$ktModality.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            modality2 = Modality.ABSTRACT;
        } else if ($this$ktModality.hasModifier(KtTokens.FINAL_KEYWORD)) {
            modality2 = Modality.FINAL;
        } else if ($this$ktModality.hasModifier(KtTokens.SEALED_KEYWORD)) {
            modality2 = Modality.SEALED;
        } else if ($this$ktModality.hasModifier(KtTokens.OPEN_KEYWORD)) {
            if ($this$ktModality instanceof KtCallableDeclaration && !KtPsiUtilKt.hasBody((KtDeclaration)$this$ktModality)) {
                KtDeclaration parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration((KtElement)((KtElement)$this$ktModality));
                if (parentDeclaration instanceof KtClass && ((KtClass)parentDeclaration).isInterface()) {
                }
            }
            modality2 = Modality.OPEN;
        } else {
            modality2 = null;
        }
        return modality2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtSymbolKind getKtSymbolKind(@NotNull KtElement $this$ktSymbolKind) {
        Intrinsics.checkNotNullParameter((Object)$this$ktSymbolKind, (String)"<this>");
        if ($this$ktSymbolKind instanceof KtPropertyAccessor) {
            return KtSymbolKind.ACCESSOR;
        }
        if ($this$ktSymbolKind instanceof KtDeclaration) {
            void $this$getParentOfType$iv;
            PsiElement psiElement2 = (PsiElement)$this$ktSymbolKind;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtDeclaration ktDeclaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv);
            return ktDeclaration2 == null ? KtSymbolKind.TOP_LEVEL : ((ktDeclaration2 instanceof KtCallableDeclaration ? true : ktDeclaration2 instanceof KtPropertyAccessor) ? KtSymbolKind.LOCAL : KtSymbolKind.CLASS_MEMBER);
        }
        return KtSymbolKind.LOCAL;
    }

    @Nullable
    public static final CallableId getCallableIdIfNonLocal(@NotNull KtDeclaration $this$callableIdIfNonLocal) {
        Intrinsics.checkNotNullParameter((Object)$this$callableIdIfNonLocal, (String)"<this>");
        return KtFe10PsiSymbolUtilsKt.calculateCallableId($this$callableIdIfNonLocal, false);
    }

    @NotNull
    public static final KtSymbolOrigin getKtSymbolOrigin(@NotNull KtElement $this$ktSymbolOrigin) {
        Intrinsics.checkNotNullParameter((Object)$this$ktSymbolOrigin, (String)"<this>");
        return $this$ktSymbolOrigin.getContainingKtFile().isCompiled() ? KtSymbolOrigin.LIBRARY : KtSymbolOrigin.SOURCE;
    }

    @Nullable
    public static final CallableId calculateCallableId(@NotNull KtDeclaration $this$calculateCallableId, boolean allowLocal) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCallableId, (String)"<this>");
        String string = $this$calculateCallableId.getName();
        if (string == null) {
            return null;
        }
        String selfName = string;
        KtFile ktFile = $this$calculateCallableId.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KtFile containingFile = ktFile;
        KtDeclaration current = CfgContainingDeclarationUtilsKt.getElementParentDeclaration((KtElement)((KtElement)$this$calculateCallableId));
        List localName = new ArrayList();
        List className = new ArrayList();
        while (current != null) {
            KtDeclaration ktDeclaration2 = current;
            if (!(ktDeclaration2 instanceof KtPropertyAccessor)) {
                Collection collection;
                if (ktDeclaration2 instanceof KtCallableDeclaration ? true : ktDeclaration2 instanceof KtEnumEntry) {
                    if (!allowLocal) {
                        return null;
                    }
                    collection = localName;
                    String string2 = current.getName();
                    if (string2 == null) {
                        return null;
                    }
                    collection.add(string2);
                } else if (ktDeclaration2 instanceof KtClassOrObject) {
                    collection = className;
                    String string3 = ((KtClassOrObject)current).getName();
                    if (string3 == null) {
                        return null;
                    }
                    collection.add(string3);
                }
            }
            current = CfgContainingDeclarationUtilsKt.getElementParentDeclaration((KtElement)((KtElement)current));
        }
        FqName fqName2 = containingFile.getPackageFqName();
        FqName fqName3 = !((Collection)className).isEmpty() ? FqName.fromSegments((List)CollectionsKt.asReversedMutable((List)className)) : null;
        Name name2 = Name.identifier((String)selfName);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        return new CallableId(fqName2, fqName3, name2, !((Collection)localName).isEmpty() ? FqName.fromSegments((List)CollectionsKt.asReversedMutable((List)localName)) : null);
    }

    @Nullable
    public static final LexicalScope getResolutionScope(@NotNull PsiElement $this$getResolutionScope, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter((Object)$this$getResolutionScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        for (PsiElement parent2 : PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getResolutionScope)) {
            LexicalScope scope2;
            if (parent2 instanceof KtElement && (scope2 = (LexicalScope)bindingContext2.get((ReadOnlySlice)BindingContext.LEXICAL_SCOPE, (Object)parent2)) != null) {
                return scope2;
            }
            if (parent2 instanceof KtClassBody) {
                ClassDescriptorWithResolutionScopes classDescriptor;
                Object object = bindingContext2.get((ReadOnlySlice)BindingContext.CLASS, (Object)parent2.getParent());
                ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor = object instanceof ClassDescriptorWithResolutionScopes ? (ClassDescriptorWithResolutionScopes)object : null;
                if (classDescriptor != null) {
                    return classDescriptor.getScopeForMemberDeclarationResolution();
                }
            }
            if (!(parent2 instanceof KtFile)) continue;
            break;
        }
        return null;
    }

    @NotNull
    public static final KtType createErrorType(@NotNull KtFe10Symbol $this$createErrorType) {
        Intrinsics.checkNotNullParameter((Object)$this$createErrorType, (String)"<this>");
        String[] stringArray = new String[]{String.valueOf($this$createErrorType.getPsi())};
        ErrorType type2 = ErrorUtils.createErrorType((ErrorTypeKind)ErrorTypeKind.UNAVAILABLE_TYPE_FOR_DECLARATION, (String[])stringArray);
        return new KtFe10ClassErrorType(type2, $this$createErrorType.getAnalysisContext());
    }
}

