/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.lifetime;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisAllowanceManager;
import org.jetbrains.kotlin.analysis.api.KtAnalysisApiInternals;
import org.jetbrains.kotlin.analysis.api.lifetime.KtAllowProhibitedAnalyzeFromWriteAction;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.lifetime.KtReadActionConfinementLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactoryKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/lifetime/KtReadActionConfinementLifetimeToken;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "factory", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "getFactory", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "onCreatedTimeStamp", "", "getInaccessibilityReason", "", "getInvalidationReason", "isAccessible", "", "isValid", "Companion", "analysis-api"})
public final class KtReadActionConfinementLifetimeToken
extends KtLifetimeToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModificationTracker modificationTracker;
    private final long onCreatedTimeStamp;
    @NotNull
    private final KtLifetimeTokenFactory factory;
    @NotNull
    private static final ThreadLocal<Boolean> allowOnEdt;
    @NotNull
    private static final ThreadLocal<Boolean> allowFromWriteAction;

    public KtReadActionConfinementLifetimeToken(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.modificationTracker = KotlinModificationTrackerFactoryKt.createProjectWideOutOfBlockModificationTracker(project2);
        this.onCreatedTimeStamp = this.modificationTracker.getModificationCount();
        this.factory = KtReadActionConfinementLifetimeTokenFactory.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.onCreatedTimeStamp == this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public String getInvalidationReason() {
        if (this.onCreatedTimeStamp != this.modificationTracker.getModificationCount()) {
            return "PSI has changed since creation";
        }
        throw new IllegalStateException("Getting invalidation reason for valid validity token".toString());
    }

    @Override
    public boolean isAccessible() {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() && !allowOnEdt.get().booleanValue()) {
            return false;
        }
        if (application.isWriteAccessAllowed() && !allowFromWriteAction.get().booleanValue()) {
            return false;
        }
        if (KtAnalysisAllowanceManager.INSTANCE.getResolveIsForbiddenInActionWithName().get() != null) {
            return false;
        }
        if (!application.isReadAccessAllowed()) {
            return false;
        }
        if (!KtReadActionConfinementLifetimeTokenFactory.INSTANCE.isInsideAnalysisContext$analysis_api()) {
            return false;
        }
        return Intrinsics.areEqual((Object)KtReadActionConfinementLifetimeTokenFactory.INSTANCE.currentToken$analysis_api(), (Object)this);
    }

    @Override
    @NotNull
    public String getInaccessibilityReason() {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() && !allowOnEdt.get().booleanValue()) {
            return "Called in EDT thread";
        }
        if (application.isWriteAccessAllowed() && !allowFromWriteAction.get().booleanValue()) {
            return "Called from write action";
        }
        if (!application.isReadAccessAllowed()) {
            return "Called outside read action";
        }
        String string = KtAnalysisAllowanceManager.INSTANCE.getResolveIsForbiddenInActionWithName().get();
        if (string != null) {
            String actionName2 = string;
            boolean bl = false;
            return "Resolve is forbidden in " + actionName2;
        }
        if (!KtReadActionConfinementLifetimeTokenFactory.INSTANCE.isInsideAnalysisContext$analysis_api()) {
            return "Called outside analyse method";
        }
        if (!Intrinsics.areEqual((Object)KtReadActionConfinementLifetimeTokenFactory.INSTANCE.currentToken$analysis_api(), (Object)this)) {
            return "Using KtLifetimeOwner from previous analysis";
        }
        throw new IllegalStateException("Getting inaccessibility reason for validity token when it is accessible".toString());
    }

    @Override
    @NotNull
    public KtLifetimeTokenFactory getFactory() {
        return this.factory;
    }

    private static final Boolean allowOnEdt$lambda$1() {
        return false;
    }

    private static final Boolean allowFromWriteAction$lambda$2() {
        return false;
    }

    static {
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(KtReadActionConfinementLifetimeToken::allowOnEdt$lambda$1);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        allowOnEdt = threadLocal;
        ThreadLocal<Boolean> threadLocal2 = ThreadLocal.withInitial(KtReadActionConfinementLifetimeToken::allowFromWriteAction$lambda$2);
        Intrinsics.checkNotNullExpressionValue(threadLocal2, (String)"withInitial(...)");
        allowFromWriteAction = threadLocal2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/analysis/api/lifetime/KtReadActionConfinementLifetimeToken$Companion;", "", "()V", "allowFromWriteAction", "Ljava/lang/ThreadLocal;", "", "getAllowFromWriteAction$annotations", "getAllowFromWriteAction", "()Ljava/lang/ThreadLocal;", "allowOnEdt", "getAllowOnEdt$annotations", "getAllowOnEdt", "analysis-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadLocal<Boolean> getAllowOnEdt() {
            return allowOnEdt;
        }

        @KtAnalysisApiInternals
        public static /* synthetic */ void getAllowOnEdt$annotations() {
        }

        @NotNull
        public final ThreadLocal<Boolean> getAllowFromWriteAction() {
            return allowFromWriteAction;
        }

        @KtAnalysisApiInternals
        @KtAllowProhibitedAnalyzeFromWriteAction
        public static /* synthetic */ void getAllowFromWriteAction$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

