/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextFactory;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibilityKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J&\u0010\u001a\u001a\u0004\u0018\u00010\u0012*\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasDefaultArgumentValues", "", "function", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "isFakeOverride", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "containingClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "findProblematicExpectMembers", "", "Lorg/jetbrains/kotlin/fir/FirExpectActualMatchingContext;", "expectClassSymbol", "actualClassSymbol", "getSingleMatchingExpect", "actualMember", "expectSymbol", "actualSymbol", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDefaultArgumentsInExpectActualizedByFakeOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n36#2:90\n1#3:91\n1#3:116\n800#4,11:92\n766#4:103\n857#4,2:104\n1603#4,9:106\n1855#4:115\n1856#4:117\n1612#4:118\n766#4:119\n857#4,2:120\n661#4,11:122\n1747#4,3:133\n*S KotlinDebug\n*F\n+ 1 FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker\n*L\n33#1:90\n59#1:116\n55#1:92,11\n56#1:103\n56#1:104,2\n59#1:106,9\n59#1:115\n59#1:117\n59#1:118\n60#1:119\n60#1:120,2\n80#1:122,11\n87#1:133,3\n*E\n"})
public final class FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker INSTANCE = new FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker();

    private FirDefaultArgumentsInExpectActualizedByFakeOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirExpectActualMatchingContext matchingContext;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects) || !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitDefaultDefaultArgumentsInExpectActualizedByFakeOverride)) {
            return;
        }
        FirMemberDeclaration $this$isActual$iv = declaration2;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        FirRegularClassSymbol actualClassSymbol = declaration2.getSymbol();
        FirBasedSymbol<?> firBasedSymbol = ExpectActualAttributesKt.getSingleExpectForActualOrNull(actualClassSymbol);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> expectedSingleCandidate = firBasedSymbol;
        FirRegularClassSymbol expectClassSymbol = (FirRegularClassSymbol)expectedSingleCandidate;
        FirExpectActualMatchingContext $this$check_u24lambda_u240 = matchingContext = FirExpectActualMatchingContextFactory.create$default(FirExpectActualMatchingContextKt.getExpectActualMatchingContextFactory(context2.getSession()), context2.getSession(), context2.getScopeSession(), false, 4, null);
        boolean bl = false;
        List<FirNamedFunctionSymbol> problematicExpectMembers = INSTANCE.findProblematicExpectMembers($this$check_u24lambda_u240, expectClassSymbol, actualClassSymbol);
        if (!((Collection)problematicExpectMembers).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_ACTUALIZED_BY_FAKE_OVERRIDE(), (Object)expectClassSymbol, problematicExpectMembers, (DiagnosticContext)context2, null, (int)32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirNamedFunctionSymbol> findProblematicExpectMembers(FirExpectActualMatchingContext $this$findProblematicExpectMembers, FirRegularClassSymbol expectClassSymbol, FirRegularClassSymbol actualClassSymbol) {
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = $this$findProblematicExpectMembers.collectAllMembers(actualClassSymbol, true);
        boolean $i$f$filterIsInstance = false;
        void var7_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirNamedFunctionSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirNamedFunctionSymbol)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isFakeOverride((FirNamedFunctionSymbol)it, actualClassSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List actualFakeOverrideMembers = (List)destination$iv$iv;
        $this$filter$iv = actualFakeOverrideMembers;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            FirNamedFunctionSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            FirNamedFunctionSymbol it2 = (FirNamedFunctionSymbol)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.getSingleMatchingExpect($this$findProblematicExpectMembers, it2, expectClassSymbol, actualClassSymbol) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirFunctionSymbol p0 = (FirFunctionSymbol)element$iv$iv;
            boolean bl = false;
            if (!this.hasDefaultArgumentValues(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isFakeOverride(FirNamedFunctionSymbol member2, FirRegularClassSymbol containingClassSymbol2) {
        ConeSimpleKotlinType coneSimpleKotlinType = member2.getDispatchReceiverType();
        if (coneSimpleKotlinType == null || (coneSimpleKotlinType = ConeTypeUtilsKt.getClassId(coneSimpleKotlinType)) == null) {
            return false;
        }
        ConeSimpleKotlinType memberReceiverClassId = coneSimpleKotlinType;
        if (!Intrinsics.areEqual((Object)memberReceiverClassId, (Object)containingClassSymbol2.getClassId())) {
            return true;
        }
        return ClassMembersKt.isSubstitutionOrIntersectionOverride(member2) || ClassMembersKt.isDelegated(member2);
    }

    private final FirNamedFunctionSymbol getSingleMatchingExpect(FirExpectActualMatchingContext $this$getSingleMatchingExpect, FirNamedFunctionSymbol actualMember, FirRegularClassSymbol expectSymbol, FirRegularClassSymbol actualSymbol) {
        Map.Entry entry;
        Object v0;
        Map potentialExpects;
        block3: {
            potentialExpects = $this$getSingleMatchingExpect.findPotentialExpectClassMembersForActual(expectSymbol, actualSymbol, actualMember, false);
            Iterable $this$singleOrNull$iv = potentialExpects.entrySet();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!ExpectActualCompatibilityKt.getCompatible((ExpectActualCompatibility)((ExpectActualCompatibility)it.getValue()))) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        if (((entry = (Map.Entry)v0) == null || (entry = (DeclarationSymbolMarker)entry.getKey()) == null) && (entry = (DeclarationSymbolMarker)CollectionsKt.singleOrNull((Iterable)potentialExpects.keySet())) == null) {
            return null;
        }
        Map.Entry expectMember = entry;
        return (FirNamedFunctionSymbol)((Object)expectMember);
    }

    private final boolean hasDefaultArgumentValues(FirFunctionSymbol<?> function2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = function2.getValueParameterSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl2 = false;
                    if (!it.getHasDefaultValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

