/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirEqualityCompatibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.TypeInfo;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/ArgumentInfo;", "", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "userType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "originalType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getArgument", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getOriginalType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "originalTypeInfo", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/TypeInfo;", "getOriginalTypeInfo", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/TypeInfo;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "smartCastType", "getSmartCastType", "smartCastType$delegate", "Lkotlin/Lazy;", "smartCastTypeInfo", "getSmartCastTypeInfo", "getUserType", "toString", "", "checkers"})
final class ArgumentInfo {
    @NotNull
    private final FirExpression argument;
    @NotNull
    private final ConeKotlinType userType;
    @NotNull
    private final ConeKotlinType originalType;
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy smartCastType$delegate;

    public ArgumentInfo(@NotNull FirExpression argument2, @NotNull ConeKotlinType userType2, @NotNull ConeKotlinType originalType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)userType2, (String)"userType");
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        this.argument = argument2;
        this.userType = userType2;
        this.originalType = originalType;
        this.session = session2;
        this.smartCastType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConeKotlinType>(this){
            final /* synthetic */ ArgumentInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ConeKotlinType invoke() {
                return !(this.this$0.getArgument() instanceof FirSmartCastExpression) ? this.this$0.getOriginalType() : TypeExpansionUtilsKt.fullyExpandedType(this.this$0.getUserType(), this.this$0.getSession());
            }
        }));
    }

    @NotNull
    public final FirExpression getArgument() {
        return this.argument;
    }

    @NotNull
    public final ConeKotlinType getUserType() {
        return this.userType;
    }

    @NotNull
    public final ConeKotlinType getOriginalType() {
        return this.originalType;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ConeKotlinType getSmartCastType() {
        Lazy lazy = this.smartCastType$delegate;
        return (ConeKotlinType)lazy.getValue();
    }

    @NotNull
    public final TypeInfo getOriginalTypeInfo() {
        return FirEqualityCompatibilityCheckerKt.access$toTypeInfo(this.originalType, this.session);
    }

    @NotNull
    public final TypeInfo getSmartCastTypeInfo() {
        return FirEqualityCompatibilityCheckerKt.access$toTypeInfo(this.getSmartCastType(), this.session);
    }

    @NotNull
    public String toString() {
        KtSourceElement ktSourceElement = this.argument.getSource();
        return (ktSourceElement != null ? KtSourceElementKt.getText((KtSourceElement)ktSourceElement) : null) + " :: " + this.userType;
    }
}

