/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.AnnotationsPosition;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponent;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.declarations.UnresolvedDeprecationProvider;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderImplKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.impl.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveContext;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformerDispatcher;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirDeclarationsResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirExpressionsResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirPartialBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.AbstractFirExpressionsResolveTransformerForAnnotations;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.AbstractFirSpecificAnnotationResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationEnhancementProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationEnhancementProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationsComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirPlaceholderProjection;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirPlaceholderProjectionBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirStarProjectionBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirTypeProjectionWithVarianceBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirUserTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirQualifierPartImpl;
import org.jetbrains.kotlin.fir.types.impl.FirTypeArgumentListImpl;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.PrivateForInline;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0004\u00a2\u0001\u00a3\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010?\u001a\u00020@2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\"J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000b0\"2\u0006\u0010C\u001a\u00020\u000bJ\u0010\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020FH\u0002J\u000e\u0010D\u001a\u00020@2\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020JJ\u0010\u0010L\u001a\u00020@2\u0006\u0010M\u001a\u00020NH\u0002J0\u0010O\u001a\u00020@2\u0006\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020@0S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020@0SH\u0086\b\u00f8\u0001\u0000J\u000e\u0010U\u001a\u0002072\u0006\u0010V\u001a\u00020JJ\u0010\u0010W\u001a\u0002072\u0006\u0010X\u001a\u00020\u000bH&J\u001a\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010^\u001a\u00020Z2\u0006\u0010_\u001a\u00020`2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u0016\u0010^\u001a\u00020@2\u0006\u0010_\u001a\u00020`2\u0006\u0010V\u001a\u00020JJ\u001a\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020b2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010d\u001a\u00020Z2\u0006\u0010e\u001a\u00020f2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J-\u0010g\u001a\u00020Z\"\f\b\u0000\u0010h*\u00020F*\u00020Z2\u0006\u0010E\u001a\u0002Hh2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010iJ-\u0010R\u001a\u0002Hj\"\u0004\b\u0000\u0010j2\u0006\u0010C\u001a\u00020\u000b2\f\u0010k\u001a\b\u0012\u0004\u0012\u0002Hj0SH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ\u001a\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020n2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010p\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020\u000b2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J)\u0010q\u001a\u0002Hr\"\b\b\u0000\u0010r*\u00020s2\u0006\u0010t\u001a\u0002Hr2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010uJ\u001a\u0010v\u001a\u00020Z2\u0006\u0010w\u001a\u00020x2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010y\u001a\u00020n2\u0006\u0010z\u001a\u00020{2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010|\u001a\u00020Z2\u0006\u0010}\u001a\u00020~2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0080\u00012\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u0082\u0001\u001a\u00020Z2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u0085\u0001\u001a\u00020Z2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001b\u0010\u0088\u0001\u001a\u00020Z2\u0006\u0010P\u001a\u00020Q2\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0089\u0001\u001a\u00030\u008a\u00012\b\u0010\u008b\u0001\u001a\u00030\u008a\u00012\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u008d\u00012\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u008f\u0001\u001a\u00030\u0090\u00012\u0007\u0010V\u001a\u00030\u0090\u00012\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u0091\u0001\u001a\u00020Z2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\b\u0010]\u001a\u0004\u0018\u00010\u0002H\u0016J2\u0010\u0094\u0001\u001a\u0002Hh\"\u0004\b\u0000\u0010h2\b\u0010\u0081\u0001\u001a\u00030\u0080\u00012\r\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u0002Hh0SH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0096\u0001J\u001f\u0010\u0097\u0001\u001a\u00020@2\b\u0010\u0081\u0001\u001a\u00030\u0080\u00012\f\u0010k\u001a\b\u0012\u0004\u0012\u00020@0SJ2\u0010\u0098\u0001\u001a\u0002Hh\"\u0004\b\u0000\u0010h2\b\u0010\u0081\u0001\u001a\u00030\u0080\u00012\r\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u0002Hh0SH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0096\u0001J#\u0010\u0099\u0001\u001a\u00020@2\u0006\u0010P\u001a\u00020Q2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020@0SH\u0086\b\u00f8\u0001\u0000J\u000f\u0010\u009a\u0001\u001a\u00030\u009b\u0001*\u00030\u009b\u0001H\u0002J\u000f\u0010\u009a\u0001\u001a\u00030\u009c\u0001*\u00030\u009c\u0001H\u0002J)\u0010\u009d\u0001\u001a\u000207*\u00030\u009e\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0011\u0010\u009f\u0001\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u000eH\u0002J\u000e\u0010\u00a0\u0001\u001a\u00020@*\u00030\u0084\u0001H\u0002J\r\u0010\u00a1\u0001\u001a\u000207*\u00020NH\u0002R\u0018\u0010\r\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u00060\u0012R\u00020\u00008\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\"8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b#\u0010\u0014\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u0014\u001a\u0004\b+\u0010,R \u0010-\u001a\b\u0012\u0004\u0012\u00020.0\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u0014\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u0002078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001c\u0010:\u001a\u00020;8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b<\u0010\u0014\u001a\u0004\b=\u0010>\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00a4\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "computationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;Ljava/util/List;)V", "annotationsFromPlugins", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "argumentsTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformerDispatcher;", "getArgumentsTransformer$annotations", "()V", "getArgumentsTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformerDispatcher;", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getClassDeclarationsStack$annotations", "getClassDeclarationsStack", "()Lkotlin/collections/ArrayDeque;", "getComputationSession$annotations", "getComputationSession", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "metaAnnotationsFromPlugins", "owners", "Lkotlinx/collections/immutable/PersistentList;", "getOwners$annotations", "getOwners", "()Lkotlinx/collections/immutable/PersistentList;", "setOwners", "(Lkotlinx/collections/immutable/PersistentList;)V", "predicateBasedProvider", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "getScopeSession$annotations", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopes", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "getScopes", "()Ljava/util/List;", "setScopes", "(Ljava/util/List;)V", "getSession$annotations", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "shouldRecordIntoPredicateBasedProvider", "", "getShouldRecordIntoPredicateBasedProvider", "()Z", "typeResolverTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "getTypeResolverTransformer$annotations", "getTypeResolverTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "afterTransformingChildren", "", "state", "beforeTransformingChildren", "parentDeclaration", "calculateDeprecations", "callableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "createDeepCopyOfTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "original", "resolveAnnotationsOnAnnotationIfNeeded", "annotationTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "resolveRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformChildren", "Lkotlin/Function0;", "afterChildrenTransform", "shouldRunAnnotationResolve", "typeRef", "shouldTransformDeclaration", "declaration", "transformAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "transformAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "transformAnnotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "annotationContainer", "transformBackingField", "backingField", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "transformCallableDeclarationForDeprecations", "T", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "R", "action", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "transformConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "transformDeclaration", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "transformErrorPrimaryConstructor", "errorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "transformField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "transformRegularClass", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "transformTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "withFile", "f", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withFileAndFileScopes", "withFileScopes", "withRegularClass", "createDeepCopy", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "markedWithMetaAnnotation", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "metaAnnotations", "moveJavaDeprecatedAnnotationToBackingField", "requiredToSave", "FirEnumAnnotationArgumentsTransformer", "FirEnumAnnotationArgumentsTransformerDispatcher", "resolve"})
@SourceDebugExtension(value={"SMAP\nAbstractFirSpecificAnnotationResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFirSpecificAnnotationResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 TransformUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/TransformUtilsKt\n+ 5 FirSpecificTypeResolverTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer\n+ 6 BodyResolveContext.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveContext\n+ 7 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 FirUserTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirUserTypeRefBuilderKt\n+ 10 FirTypeProjectionWithVarianceBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirTypeProjectionWithVarianceBuilderKt\n+ 11 FirStarProjectionBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirStarProjectionBuilderKt\n+ 12 FirPlaceholderProjectionBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirPlaceholderProjectionBuilderKt\n*L\n1#1,530:1\n272#1:538\n288#1:539\n289#1:543\n273#1:544\n274#1,3:546\n487#1,3:549\n277#1,2:552\n491#1:554\n279#1,12:555\n291#1:568\n282#1:569\n288#1:570\n289#1:574\n487#1,5:576\n290#1:581\n291#1:583\n330#1:590\n331#1:595\n332#1:614\n333#1:617\n365#1,2:618\n487#1,5:620\n487#1,5:670\n487#1,5:675\n487#1,5:680\n22#2,4:531\n1747#3,3:535\n1549#3:609\n1620#3,3:610\n1549#3:652\n1620#3,3:653\n1620#3,3:686\n1620#3,3:689\n64#4,3:540\n68#4:545\n69#4:567\n64#4,3:571\n68#4:575\n69#4:582\n64#4,6:584\n47#4,3:599\n51#4,4:628\n55#4:633\n47#4,3:642\n51#4,4:662\n55#4:667\n79#5,4:591\n84#5:634\n79#5,4:635\n84#5,2:668\n380#6,3:596\n383#6:602\n161#6,3:603\n384#6,3:606\n387#6:613\n165#6:627\n380#6,3:639\n383#6:645\n161#6,3:646\n384#6,3:649\n387#6:656\n165#6:661\n155#7,2:615\n157#7,2:625\n155#7,4:657\n1#8:632\n1#8:666\n31#9:685\n42#10,4:692\n36#11,4:696\n36#12,4:700\n*S KotlinDebug\n*F\n+ 1 AbstractFirSpecificAnnotationResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer\n*L\n255#1:538\n255#1:539\n255#1:543\n255#1:544\n255#1:546,3\n255#1:549,3\n255#1:552,2\n255#1:554\n255#1:555,12\n255#1:568\n255#1:569\n272#1:570\n272#1:574\n276#1:576,5\n272#1:581\n272#1:583\n320#1:590\n320#1:595\n320#1:614\n320#1:617\n321#1:618,2\n322#1:620,5\n385#1:670,5\n408#1:675,5\n423#1:680,5\n216#1:531,4\n233#1:535,3\n320#1:609\n320#1:610,3\n331#1:652\n331#1:653,3\n499#1:686,3\n504#1:689,3\n255#1:540,3\n255#1:545\n255#1:567\n272#1:571,3\n272#1:575\n272#1:582\n288#1:584,6\n320#1:599,3\n320#1:628,4\n320#1:633\n331#1:642,3\n331#1:662,4\n331#1:667\n320#1:591,4\n320#1:634\n330#1:635,4\n330#1:668,2\n320#1:596,3\n320#1:602\n320#1:603,3\n320#1:606,3\n320#1:613\n320#1:627\n331#1:639,3\n331#1:645\n331#1:646,3\n331#1:649,3\n331#1:656\n331#1:661\n320#1:615,2\n320#1:625,2\n332#1:657,4\n320#1:632\n331#1:666\n495#1:685\n516#1:692,4\n524#1:696,4\n525#1:700,4\n*E\n"})
public abstract class AbstractFirSpecificAnnotationResolveTransformer
extends FirDefaultTransformer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final CompilerRequiredAnnotationsComputationSession computationSession;
    @NotNull
    private final FirPredicateBasedProvider predicateBasedProvider;
    @NotNull
    private final Set<FqName> annotationsFromPlugins;
    @NotNull
    private final Set<FqName> metaAnnotationsFromPlugins;
    @NotNull
    private final FirSpecificTypeResolverTransformer typeResolverTransformer;
    @NotNull
    private final FirEnumAnnotationArgumentsTransformerDispatcher argumentsTransformer;
    @NotNull
    private PersistentList<? extends FirDeclaration> owners;
    @NotNull
    private final ArrayDeque<FirClass> classDeclarationsStack;
    public List<? extends FirScope> scopes;

    /*
     * WARNING - void declaration
     */
    public AbstractFirSpecificAnnotationResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull CompilerRequiredAnnotationsComputationSession computationSession, @NotNull List<? extends FirDeclaration> containingDeclarations2) {
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)computationSession, (String)"computationSession");
        Intrinsics.checkNotNullParameter(containingDeclarations2, (String)"containingDeclarations");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.computationSession = computationSession;
        this.predicateBasedProvider = FirPredicateBasedProviderKt.getPredicateBasedProvider(this.session);
        this.annotationsFromPlugins = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session).getAnnotations();
        this.metaAnnotationsFromPlugins = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session).getMetaAnnotations();
        this.typeResolverTransformer = new FirSpecificTypeResolverTransformer(this.session, false, false, null, 8, null);
        this.argumentsTransformer = new FirEnumAnnotationArgumentsTransformerDispatcher();
        this.owners = ExtensionsKt.persistentListOf();
        ArrayDeque arrayDeque2 = arrayDeque = new ArrayDeque();
        AbstractFirSpecificAnnotationResolveTransformer abstractFirSpecificAnnotationResolveTransformer = this;
        boolean bl = false;
        for (FirDeclaration firDeclaration : containingDeclarations2) {
            void $this$classDeclarationsStack_u24lambda_u240;
            if (!(firDeclaration instanceof FirClass)) continue;
            $this$classDeclarationsStack_u24lambda_u240.add((Object)firDeclaration);
        }
        abstractFirSpecificAnnotationResolveTransformer.classDeclarationsStack = arrayDeque;
    }

    public /* synthetic */ AbstractFirSpecificAnnotationResolveTransformer(FirSession firSession, ScopeSession scopeSession, CompilerRequiredAnnotationsComputationSession compilerRequiredAnnotationsComputationSession, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(firSession, scopeSession, compilerRequiredAnnotationsComputationSession, list2);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @PrivateForInline
    public static /* synthetic */ void getSession$annotations() {
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @PrivateForInline
    public static /* synthetic */ void getScopeSession$annotations() {
    }

    @NotNull
    public final CompilerRequiredAnnotationsComputationSession getComputationSession() {
        return this.computationSession;
    }

    @PrivateForInline
    public static /* synthetic */ void getComputationSession$annotations() {
    }

    protected boolean getShouldRecordIntoPredicateBasedProvider() {
        return true;
    }

    @NotNull
    public final FirSpecificTypeResolverTransformer getTypeResolverTransformer() {
        return this.typeResolverTransformer;
    }

    @PrivateForInline
    public static /* synthetic */ void getTypeResolverTransformer$annotations() {
    }

    @NotNull
    public final FirEnumAnnotationArgumentsTransformerDispatcher getArgumentsTransformer() {
        return this.argumentsTransformer;
    }

    @PrivateForInline
    public static /* synthetic */ void getArgumentsTransformer$annotations() {
    }

    @NotNull
    public final PersistentList<FirDeclaration> getOwners() {
        return this.owners;
    }

    public final void setOwners(@NotNull PersistentList<? extends FirDeclaration> persistentList) {
        Intrinsics.checkNotNullParameter(persistentList, (String)"<set-?>");
        this.owners = persistentList;
    }

    @PrivateForInline
    public static /* synthetic */ void getOwners$annotations() {
    }

    @NotNull
    public final ArrayDeque<FirClass> getClassDeclarationsStack() {
        return this.classDeclarationsStack;
    }

    @PrivateForInline
    public static /* synthetic */ void getClassDeclarationsStack$annotations() {
    }

    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        FirTypeRef annotationTypeRef = annotationCall.getAnnotationTypeRef();
        if (!(annotationTypeRef instanceof FirUserTypeRef)) {
            return annotationCall;
        }
        if (!this.shouldRunAnnotationResolve((FirUserTypeRef)annotationTypeRef)) {
            return annotationCall;
        }
        this.transformAnnotationCall(annotationCall, (FirUserTypeRef)annotationTypeRef);
        return annotationCall;
    }

    public final void transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirUserTypeRef typeRef) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        FirTypeRef firTypeRef = this.typeResolverTransformer.transformUserTypeRef(this.createDeepCopyOfTypeRef(typeRef), new ScopeClassDeclaration(CollectionsKt.asReversed(this.getScopes()), (List)this.classDeclarationsStack, null, null, 12, null));
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        if (firResolvedTypeRef == null) {
            return;
        }
        FirResolvedTypeRef transformedAnnotationType = firResolvedTypeRef;
        this.resolveAnnotationsOnAnnotationIfNeeded(transformedAnnotationType);
        if (!this.requiredToSave(transformedAnnotationType)) {
            return;
        }
        annotationCall.replaceAnnotationTypeRef(transformedAnnotationType);
        annotationCall.replaceAnnotationResolvePhase(FirAnnotationResolvePhase.CompilerRequiredAnnotations);
        Set<ClassId> requiredAnnotationsWithArguments = FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(this.session).getRequiredAnnotationsWithArguments();
        Iterable iterable = requiredAnnotationsWithArguments;
        FirTypeRef $this$coneTypeSafe$iv = transformedAnnotationType;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if (CollectionsKt.contains((Iterable)iterable, (object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null)) {
            this.argumentsTransformer.transformAnnotation((FirAnnotation)annotationCall, ResolutionMode.ContextDependent.Default);
        }
    }

    private final void resolveAnnotationsOnAnnotationIfNeeded(FirResolvedTypeRef annotationTypeRef) {
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(annotationTypeRef), this.session);
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol symbol2 = firRegularClassSymbol;
        this.computationSession.resolveAnnotationsOnAnnotationIfNeeded(symbol2, this.scopeSession);
    }

    @Override
    @NotNull
    public FirStatement transformAnnotation(@NotNull FirAnnotation annotation, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        throw new IllegalStateException("Should not be there".toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldRunAnnotationResolve(@NotNull FirUserTypeRef typeRef) {
        FqName it;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Name name2 = ((FirQualifierPart)CollectionsKt.last(typeRef.getQualifier())).getName();
        if (!((Collection)this.metaAnnotationsFromPlugins).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) {
            return true;
        }
        if (FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(this.session).getRequiredAnnotationsShortClassNames().contains(name2)) return true;
        Iterable $this$any$iv = this.annotationsFromPlugins;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (FqName)element$iv;
            boolean bl2 = false;
        } while (!Intrinsics.areEqual((Object)it.shortName(), (Object)name2));
        return true;
    }

    private final boolean requiredToSave(FirResolvedTypeRef $this$requiredToSave) {
        ClassId classId = ConeTypeUtilsKt.getClassId($this$requiredToSave.getType());
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        return FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(this.session).getRequiredAnnotations().contains(classId2) ? true : (this.annotationsFromPlugins.contains(classId2.asSingleFqName()) ? true : (this.metaAnnotationsFromPlugins.isEmpty() ? false : this.markedWithMetaAnnotation($this$requiredToSave.getType(), this.session, this.metaAnnotationsFromPlugins)));
    }

    private final boolean markedWithMetaAnnotation(ConeKotlinType $this$markedWithMetaAnnotation, FirSession session2, Set<FqName> metaAnnotations) {
        return FirPredicateBasedProviderImplKt.markedWithMetaAnnotationImpl(TypeUtilsKt.toRegularClassSymbol($this$markedWithMetaAnnotation, session2), session2, metaAnnotations, true, new LinkedHashSet(), (Function1<? super FirRegularClassSymbol, ? extends List<? extends FirAnnotation>>)((Function1)new Function1<FirRegularClassSymbol, List<? extends FirAnnotation>>(this){
            final /* synthetic */ AbstractFirSpecificAnnotationResolveTransformer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<FirAnnotation> invoke(@NotNull FirRegularClassSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getComputationSession().resolveAnnotationsOnAnnotationIfNeeded(it, this.this$0.getScopeSession());
                return it.getAnnotations();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data2) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
            boolean $i$f$resolveRegularClass = false;
            AbstractFirSpecificAnnotationResolveTransformer this_$iv$iv = this_$iv;
            boolean $i$f$withRegularClass = false;
            ArrayDeque<FirClass> classDeclarations$iv$iv$iv = this_$iv$iv.getClassDeclarationsStack();
            boolean $i$f$withClassDeclarationCleanup = false;
            classDeclarations$iv$iv$iv.addLast((Object)regularClass);
            try {
                FirDeclaration firDeclaration;
                boolean bl = false;
                boolean bl2 = false;
                if (!this_$iv.shouldTransformDeclaration(regularClass)) break block7;
                this_$iv.getComputationSession().recordThatAnnotationsAreResolved(regularClass);
                FirDeclaration it$iv = firDeclaration = this_$iv.transformDeclaration((FirDeclaration)regularClass, null);
                boolean bl3 = false;
                AbstractFirSpecificAnnotationResolveTransformer this_$iv$iv2 = this_$iv;
                boolean $i$f$transformChildren = false;
                PersistentList<FirDeclaration> state$iv$iv = this_$iv$iv2.beforeTransformingChildren(regularClass);
                try {
                    boolean bl4 = false;
                    boolean bl5 = false;
                    regularClass.transformDeclarations(this, data2);
                    Unit unit2 = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.afterTransformingChildren(state$iv$iv);
                }
                boolean bl6 = false;
                this.calculateDeprecations(regularClass);
                Unit unit3 = Unit.INSTANCE;
            }
            finally {
                classDeclarations$iv$iv$iv.removeLast();
            }
        }
        return regularClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resolveRegularClass(@NotNull FirRegularClass regularClass, @NotNull Function0<Unit> transformChildren, @NotNull Function0<Unit> afterChildrenTransform) {
        ArrayDeque<FirClass> classDeclarations$iv$iv;
        block7: {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter(transformChildren, (String)"transformChildren");
            Intrinsics.checkNotNullParameter(afterChildrenTransform, (String)"afterChildrenTransform");
            boolean $i$f$resolveRegularClass = false;
            AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
            boolean $i$f$withRegularClass = false;
            classDeclarations$iv$iv = this_$iv.getClassDeclarationsStack();
            boolean $i$f$withClassDeclarationCleanup = false;
            classDeclarations$iv$iv.addLast((Object)regularClass);
            boolean bl = false;
            boolean bl2 = false;
            if (this.shouldTransformDeclaration(regularClass)) break block7;
            InlineMarker.finallyStart((int)2);
            classDeclarations$iv$iv.removeLast();
            InlineMarker.finallyEnd((int)2);
            return;
        }
        try {
            FirDeclaration firDeclaration;
            this.getComputationSession().recordThatAnnotationsAreResolved(regularClass);
            FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)regularClass, null);
            boolean bl = false;
            AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
            boolean $i$f$transformChildren = false;
            PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(regularClass);
            try {
                boolean bl3 = false;
                transformChildren.invoke();
                Unit unit2 = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this_$iv.afterTransformingChildren(state$iv);
                InlineMarker.finallyEnd((int)1);
            }
            afterChildrenTransform.invoke();
            Unit unit3 = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            classDeclarations$iv$iv.removeLast();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withRegularClass(@NotNull FirRegularClass regularClass, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$withRegularClass = false;
        ArrayDeque<FirClass> classDeclarations$iv = this.getClassDeclarationsStack();
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast((Object)regularClass);
        try {
            boolean bl = false;
            action2.invoke();
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            classDeclarations$iv.removeLast();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public FirTypeAlias transformTypeAlias(@NotNull FirTypeAlias typeAlias2, @Nullable Void data2) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)typeAlias2, (String)"typeAlias");
        if (!this.shouldTransformDeclaration(typeAlias2)) {
            return typeAlias2;
        }
        this.computationSession.recordThatAnnotationsAreResolved(typeAlias2);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)typeAlias2, data2);
        boolean bl = false;
        this.calculateDeprecations(typeAlias2);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
        return (FirTypeAlias)firDeclaration2;
    }

    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration2, @Nullable Void data2) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirAnnotationContainer firAnnotationContainer = this.transformAnnotationContainer((FirAnnotationContainer)declaration2, data2);
        Intrinsics.checkNotNull((Object)firAnnotationContainer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirDeclaration");
        FirDeclaration it = firDeclaration = (FirDeclaration)firAnnotationContainer;
        boolean bl = false;
        if (this.getShouldRecordIntoPredicateBasedProvider()) {
            this.predicateBasedProvider.registerAnnotatedDeclaration(declaration2, this.owners);
        }
        return firDeclaration;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.shouldTransformDeclaration(file2)) {
            return file2;
        }
        this.withFileAndFileScopes(file2, (Function0<Unit>)((Function0)new Function0<Unit>(file2, this, data2){
            final /* synthetic */ FirFile $file;
            final /* synthetic */ AbstractFirSpecificAnnotationResolveTransformer this$0;
            final /* synthetic */ Void $data;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$file.transformDeclarations(this.this$0, this.$data);
            }
        }));
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public final void withFileAndFileScopes(@NotNull FirFile file2, @NotNull Function0<Unit> action2) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
            boolean $i$f$withFile = false;
            FirSpecificTypeResolverTransformer this_$iv$iv = this_$iv.getTypeResolverTransformer();
            boolean $i$f$withFile2 = false;
            FirFile oldValue$iv$iv = this_$iv$iv.currentFile;
            this_$iv$iv.currentFile = file2;
            try {
                int n;
                Unit unit2;
                void $this$mapTo$iv$iv$iv$iv;
                void $this$map$iv$iv$iv;
                void this_$iv$iv2;
                FirSpecificTypeResolverTransformer $this$withFile_u24lambda_u2415$iv = this_$iv$iv;
                boolean bl = false;
                BodyResolveContext bodyResolveContext2 = this_$iv.getArgumentsTransformer().getContext();
                SessionHolder holder$iv$iv = this_$iv.getArgumentsTransformer().getComponents();
                boolean $i$f$withFile3 = false;
                this_$iv$iv2.clear();
                this_$iv$iv2.setFile(file2);
                List<FirScope> scopes$iv$iv$iv = this_$iv$iv2.getFileImportsScope();
                boolean $i$f$withScopeCleanup = false;
                int sizeBefore$iv$iv$iv = scopes$iv$iv$iv.size();
                boolean bl2 = false;
                void this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv.getTowerDataContext();
                boolean bl3 = false;
                List importingScopes$iv$iv = ImportingScopesKt.createImportingScopes$default(file2, holder$iv$iv.getSession(), holder$iv$iv.getScopeSession(), false, 8, null);
                CollectionsKt.addAll((Collection)this_$iv$iv2.getFileImportsScope(), (Iterable)importingScopes$iv$iv);
                Iterable iterable = importingScopes$iv$iv;
                void var23_23 = this_$iv$iv2;
                boolean $i$f$map = false;
                void var25_25 = $this$map$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                    void it$iv$iv;
                    FirScope firScope2 = (FirScope)item$iv$iv$iv$iv;
                    Collection collection = destination$iv$iv$iv$iv;
                    boolean bl4 = false;
                    collection.add(ImplicitReceiverUtilsKt.asTowerDataElement((FirScope)it$iv$iv, false));
                }
                var23_23.addNonLocalTowerDataElements((List)destination$iv$iv$iv$iv);
                boolean bl5 = false;
                boolean $i$f$withFileAnalysisExceptionWrapping = false;
                try {
                    boolean bl6 = false;
                    boolean bl7 = false;
                    AbstractFirSpecificAnnotationResolveTransformer this_$iv2 = this;
                    boolean $i$f$withFileScopes = false;
                    this_$iv2.setScopes(ImportingScopesKt.createImportingScopes(file2, this_$iv2.getSession(), this_$iv2.getScopeSession(), this_$iv2.getComputationSession().getUseCacheForImportScope()));
                    boolean bl8 = false;
                    AbstractFirSpecificAnnotationResolveTransformer this_$iv3 = this;
                    boolean $i$f$transformChildren = false;
                    PersistentList<FirDeclaration> state$iv = this_$iv3.beforeTransformingChildren(file2);
                    try {
                        boolean bl9 = false;
                        action2.invoke();
                        Unit unit3 = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv3.afterTransformingChildren(state$iv);
                    }
                    unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable$iv$iv) {
                    UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv$iv);
                    throw null;
                }
                Unit unit4 = unit2;
                this_$iv$iv$iv.replaceTowerDataContext(initialContext$iv$iv$iv);
                Unit unit5 = unit4;
                int n2 = scopes$iv$iv$iv.size();
                int n3 = n = n2 >= sizeBefore$iv$iv$iv ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                n = n2 - sizeBefore$iv$iv$iv;
                for (int j = 0; j < n; ++j) {
                    List<FirScope> list2 = scopes$iv$iv$iv;
                    list2.remove(list2.size() - 1);
                }
                Unit unit6 = unit5;
                break block20;
                {
                    catch (Throwable throwable) {
                        try {
                            this_$iv$iv$iv.replaceTowerDataContext(initialContext$iv$iv$iv);
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            int n4;
                            int size$iv$iv$iv = scopes$iv$iv$iv.size();
                            int n5 = n4 = size$iv$iv$iv >= sizeBefore$iv$iv$iv ? 1 : 0;
                            if (_Assertions.ENABLED && n4 == 0) {
                                String string = "Assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            n4 = size$iv$iv$iv - sizeBefore$iv$iv$iv;
                            int n6 = 0;
                            while (n6 < n4) {
                                int it$iv$iv$iv = n6++;
                                boolean bl10 = false;
                                List<FirScope> it$iv$iv$iv2 = scopes$iv$iv$iv;
                                boolean bl11 = false;
                                it$iv$iv$iv2.remove(it$iv$iv$iv2.size() - 1);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            finally {
                this_$iv$iv.currentFile = oldValue$iv$iv;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public final <T> T withFile(@NotNull FirFile file, @NotNull Function0<? extends T> f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void calculateDeprecations(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        if (Intrinsics.areEqual((Object)classLikeDeclaration.getDeprecationsProvider(), (Object)UnresolvedDeprecationProvider.INSTANCE)) {
            classLikeDeclaration.replaceDeprecationsProvider(DeprecationUtilsKt.getDeprecationsProvider(classLikeDeclaration, this.session));
        }
    }

    private final void calculateDeprecations(FirCallableDeclaration callableDeclaration) {
        if (Intrinsics.areEqual((Object)callableDeclaration.getDeprecationsProvider(), (Object)UnresolvedDeprecationProvider.INSTANCE)) {
            callableDeclaration.replaceDeprecationsProvider(DeprecationUtilsKt.getDeprecationsProvider(callableDeclaration, this.session));
        }
    }

    private final <T extends FirCallableDeclaration> FirStatement transformCallableDeclarationForDeprecations(T callableDeclaration, Void data2) {
        FirDeclaration firDeclaration;
        if (!this.shouldTransformDeclaration(callableDeclaration)) {
            return (FirStatement)((Object)callableDeclaration);
        }
        this.computationSession.recordThatAnnotationsAreResolved(callableDeclaration);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)callableDeclaration, data2);
        boolean bl = false;
        this.calculateDeprecations(callableDeclaration);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration2);
    }

    @NotNull
    public final List<FirScope> getScopes() {
        List<FirScope> list2 = this.scopes;
        if (list2 != null) {
            return list2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scopes");
        return null;
    }

    public final void setScopes(@NotNull List<? extends FirScope> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.scopes = list2;
    }

    public final <T> T withFileScopes(@NotNull FirFile file2, @NotNull Function0<? extends T> f2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        boolean $i$f$withFileScopes = false;
        this.setScopes(ImportingScopesKt.createImportingScopes(file2, this.getSession(), this.getScopeSession(), this.getComputationSession().getUseCacheForImportScope()));
        return (T)f2.invoke();
    }

    public abstract boolean shouldTransformDeclaration(@NotNull FirDeclaration var1);

    @Override
    @NotNull
    public FirStatement transformBackingField(@NotNull FirBackingField backingField2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)backingField2, (String)"backingField");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)backingField2, data2);
    }

    @Override
    @NotNull
    public FirStatement transformPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)propertyAccessor, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property2, @Nullable Void data2) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        if (!this.shouldTransformDeclaration(property2)) {
            return property2;
        }
        this.computationSession.recordThatAnnotationsAreResolved(property2);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)property2, data2);
        boolean bl = false;
        this.moveJavaDeprecatedAnnotationToBackingField(property2);
        AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
        boolean $i$f$transformChildren = false;
        PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(property2);
        try {
            boolean bl2 = false;
            property2.transformSetter(this, data2);
            property2.transformGetter(this, data2);
            FirProperty firProperty = property2.transformBackingField(this, data2);
        }
        finally {
            this_$iv.afterTransformingChildren(state$iv);
        }
        this.calculateDeprecations(property2);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration2);
    }

    private final void moveJavaDeprecatedAnnotationToBackingField(FirProperty $this$moveJavaDeprecatedAnnotationToBackingField) {
        block1: {
            AnnotationsPosition annotationsPosition = FirAnnotationsPlatformSpecificSupportComponent.extractBackingFieldAnnotationsFromProperty$default(FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(this.session), $this$moveJavaDeprecatedAnnotationToBackingField, this.session, null, null, 12, null);
            if (annotationsPosition == null) {
                return;
            }
            AnnotationsPosition newPosition = annotationsPosition;
            $this$moveJavaDeprecatedAnnotationToBackingField.replaceAnnotations(newPosition.getPropertyAnnotations());
            FirBackingField firBackingField = $this$moveJavaDeprecatedAnnotationToBackingField.getBackingField();
            if (firBackingField == null) break block1;
            firBackingField.replaceAnnotations(newPosition.getBackingFieldAnnotations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FirSimpleFunction transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Void data2) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        if (!this.shouldTransformDeclaration(simpleFunction)) {
            return simpleFunction;
        }
        this.computationSession.recordThatAnnotationsAreResolved(simpleFunction);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)simpleFunction, data2);
        boolean bl = false;
        AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
        boolean $i$f$transformChildren = false;
        PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(simpleFunction);
        try {
            boolean bl2 = false;
            FirSimpleFunction firSimpleFunction = simpleFunction.transformValueParameters(this, data2);
        }
        finally {
            this_$iv.afterTransformingChildren(state$iv);
        }
        this.calculateDeprecations(simpleFunction);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSimpleFunction");
        return (FirSimpleFunction)firDeclaration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FirConstructor transformConstructor(@NotNull FirConstructor constructor2, @Nullable Void data2) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        if (!this.shouldTransformDeclaration(constructor2)) {
            return constructor2;
        }
        this.computationSession.recordThatAnnotationsAreResolved(constructor2);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)constructor2, data2);
        boolean bl = false;
        AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
        boolean $i$f$transformChildren = false;
        PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(constructor2);
        try {
            boolean bl2 = false;
            FirConstructor firConstructor = constructor2.transformValueParameters(this, data2);
        }
        finally {
            this_$iv.afterTransformingChildren(state$iv);
        }
        this.calculateDeprecations(constructor2);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirConstructor");
        return (FirConstructor)firDeclaration2;
    }

    @NotNull
    public FirConstructor transformErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)errorPrimaryConstructor, (String)"errorPrimaryConstructor");
        return this.transformConstructor((FirConstructor)errorPrimaryConstructor, data2);
    }

    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)enumEntry, data2);
    }

    @Override
    @NotNull
    public FirStatement transformField(@NotNull FirField field2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)field2, data2);
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)valueParameter2, data2);
    }

    @Override
    @NotNull
    public FirTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        FirAnnotationContainer firAnnotationContainer = this.transformAnnotationContainer((FirAnnotationContainer)typeRef, data2);
        Intrinsics.checkNotNull((Object)firAnnotationContainer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirTypeRef");
        return (FirTypeRef)firAnnotationContainer;
    }

    @Override
    @NotNull
    public FirAnnotationContainer transformAnnotationContainer(@NotNull FirAnnotationContainer annotationContainer, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
        return annotationContainer.transformAnnotations(this, data2);
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element3, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        return element3;
    }

    @NotNull
    public final PersistentList<FirDeclaration> beforeTransformingChildren(@NotNull FirDeclaration parentDeclaration) {
        Intrinsics.checkNotNullParameter((Object)parentDeclaration, (String)"parentDeclaration");
        PersistentList<? extends FirDeclaration> current = this.owners;
        this.owners = this.owners.add((Object)parentDeclaration);
        return current;
    }

    public final void afterTransformingChildren(@Nullable PersistentList<? extends FirDeclaration> state) {
        if (state == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.owners = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R transformChildren(@NotNull FirDeclaration parentDeclaration, @NotNull Function0<? extends R> action2) {
        Intrinsics.checkNotNullParameter((Object)parentDeclaration, (String)"parentDeclaration");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$transformChildren = false;
        PersistentList<FirDeclaration> state = this.beforeTransformingChildren(parentDeclaration);
        try {
            Object object = action2.invoke();
            return (R)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.afterTransformingChildren(state);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirUserTypeRef createDeepCopyOfTypeRef(@NotNull FirUserTypeRef original) {
        void $this$mapTo$iv;
        FirUserTypeRefBuilder firUserTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        boolean $i$f$buildUserTypeRef = false;
        FirUserTypeRefBuilder $this$createDeepCopyOfTypeRef_u24lambda_u2424 = firUserTypeRefBuilder = new FirUserTypeRefBuilder();
        boolean bl = false;
        $this$createDeepCopyOfTypeRef_u24lambda_u2424.setSource(original.getSource());
        $this$createDeepCopyOfTypeRef_u24lambda_u2424.setMarkedNullable(original.isMarkedNullable());
        $this$createDeepCopyOfTypeRef_u24lambda_u2424.getAnnotations().addAll((Collection<FirAnnotation>)original.getAnnotations());
        Iterable iterable = original.getQualifier();
        Collection destination$iv = $this$createDeepCopyOfTypeRef_u24lambda_u2424.getQualifier();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirQualifierPart firQualifierPart = (FirQualifierPart)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(this.createDeepCopy((FirQualifierPart)it));
        }
        return firUserTypeRefBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifierPart createDeepCopy(FirQualifierPart $this$createDeepCopy) {
        void $this$mapTo$iv;
        FirTypeArgumentListImpl firTypeArgumentListImpl;
        FirTypeArgumentListImpl $this$createDeepCopy_u24lambda_u2426 = firTypeArgumentListImpl = new FirTypeArgumentListImpl($this$createDeepCopy.getTypeArgumentList().getSource());
        boolean bl = false;
        Iterable iterable = $this$createDeepCopy.getTypeArgumentList().getTypeArguments();
        Collection destination$iv = $this$createDeepCopy_u24lambda_u2426.getTypeArguments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(this.createDeepCopy((FirTypeProjection)it));
        }
        FirTypeArgumentListImpl newArgumentList2 = firTypeArgumentListImpl;
        return new FirQualifierPartImpl($this$createDeepCopy.getSource(), $this$createDeepCopy.getName(), newArgumentList2);
    }

    private final FirTypeProjection createDeepCopy(FirTypeProjection $this$createDeepCopy) {
        FirTypeProjection firTypeProjection;
        FirTypeProjection original = $this$createDeepCopy;
        if (original instanceof FirTypeProjectionWithVariance) {
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder;
            boolean $i$f$buildTypeProjectionWithVariance = false;
            FirTypeProjectionWithVarianceBuilder $this$createDeepCopy_u24lambda_u2427 = firTypeProjectionWithVarianceBuilder = new FirTypeProjectionWithVarianceBuilder();
            boolean bl = false;
            $this$createDeepCopy_u24lambda_u2427.setSource(original.getSource());
            FirTypeRef originalTypeRef = ((FirTypeProjectionWithVariance)original).getTypeRef();
            $this$createDeepCopy_u24lambda_u2427.setTypeRef(originalTypeRef instanceof FirUserTypeRef ? (FirTypeRef)this.createDeepCopyOfTypeRef((FirUserTypeRef)originalTypeRef) : originalTypeRef);
            $this$createDeepCopy_u24lambda_u2427.setVariance(((FirTypeProjectionWithVariance)original).getVariance());
            firTypeProjection = firTypeProjectionWithVarianceBuilder.build();
        } else if (original instanceof FirStarProjection) {
            FirStarProjectionBuilder firStarProjectionBuilder;
            boolean $i$f$buildStarProjection = false;
            FirStarProjectionBuilder $this$createDeepCopy_u24lambda_u2428 = firStarProjectionBuilder = new FirStarProjectionBuilder();
            boolean bl = false;
            $this$createDeepCopy_u24lambda_u2428.setSource(original.getSource());
            firTypeProjection = firStarProjectionBuilder.build();
        } else if (original instanceof FirPlaceholderProjection) {
            FirPlaceholderProjectionBuilder firPlaceholderProjectionBuilder;
            boolean $i$f$buildPlaceholderProjection = false;
            FirPlaceholderProjectionBuilder $this$createDeepCopy_u24lambda_u2429 = firPlaceholderProjectionBuilder = new FirPlaceholderProjectionBuilder();
            boolean bl = false;
            $this$createDeepCopy_u24lambda_u2429.setSource(original.getSource());
            firTypeProjection = firPlaceholderProjectionBuilder.build();
        } else {
            AddToStdlibKt.shouldNotBeCalled$default(null, (int)1, null);
            throw null;
        }
        return firTypeProjection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\bH\u0002J\u001c\u0010\u0014\u001a\u00020\u0013*\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirExpressionsResolveTransformerForAnnotations;", "transformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;)V", "resolveQualifiedAccessAndSelectCandidate", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "isUsedAsReceiver", "", "callSite", "Lorg/jetbrains/kotlin/fir/FirElement;", "transformFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "data", "Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;", "resolveFromImportScope", "", "updateCallee", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/impl/FirSimpleNamedReference;", "calleeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirEnumEntrySymbol;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nAbstractFirSpecificAnnotationResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFirSpecificAnnotationResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirResolvedQualifierBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirResolvedQualifierBuilderKt\n+ 5 FirPartialBodyResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirPartialBodyResolveTransformer\n+ 6 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n+ 7 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,530:1\n1#2:531\n800#3,11:532\n288#3,2:547\n83#4,4:543\n18#5:549\n42#6,4:550\n26#7:554\n*S KotlinDebug\n*F\n+ 1 AbstractFirSpecificAnnotationResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformer\n*L\n96#1:532,11\n119#1:547,2\n109#1:543,4\n148#1:549\n151#1:550,4\n158#1:554\n*E\n"})
    private final class FirEnumAnnotationArgumentsTransformer
    extends AbstractFirExpressionsResolveTransformerForAnnotations {
        public FirEnumAnnotationArgumentsTransformer(FirAbstractBodyResolveTransformerDispatcher transformer2) {
            Intrinsics.checkNotNullParameter((Object)transformer2, (String)"transformer");
            super(transformer2);
        }

        @Override
        @NotNull
        public FirStatement transformFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull ResolutionMode data2) {
            Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            functionCall.transformChildren(this.getTransformer(), data2);
            return super.transformFunctionCall(functionCall, data2);
        }

        @Override
        @NotNull
        protected FirStatement resolveQualifiedAccessAndSelectCandidate(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, boolean isUsedAsReceiver, @NotNull FirElement callSite) {
            Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
            Intrinsics.checkNotNullParameter((Object)callSite, (String)"callSite");
            this.resolveFromImportScope(qualifiedAccessExpression);
            return qualifiedAccessExpression;
        }

        /*
         * WARNING - void declaration
         */
        private final void resolveFromImportScope(FirQualifiedAccessExpression $this$resolveFromImportScope) {
            FirQualifiedAccessExpression receiver2;
            FirPureAbstractElement firPureAbstractElement = $this$resolveFromImportScope.getCalleeReference();
            FirSimpleNamedReference firSimpleNamedReference = firPureAbstractElement instanceof FirSimpleNamedReference ? (FirSimpleNamedReference)firPureAbstractElement : null;
            if (firSimpleNamedReference == null) {
                return;
            }
            FirSimpleNamedReference calleeReference = firSimpleNamedReference;
            firPureAbstractElement = $this$resolveFromImportScope.getExplicitReceiver();
            FirQualifiedAccessExpression firQualifiedAccessExpression = receiver2 = firPureAbstractElement instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firPureAbstractElement : null;
            if (receiver2 != null) {
                Object v5;
                FirResolvedQualifier resolvedReceiver;
                Object symbol2;
                block15: {
                    Object object;
                    Object it3;
                    block14: {
                        void $this$filterIsInstanceTo$iv$iv;
                        Name name2;
                        FirReference firReference = receiver2.getCalleeReference();
                        FirSimpleNamedReference firSimpleNamedReference2 = firReference instanceof FirSimpleNamedReference ? (FirSimpleNamedReference)firReference : null;
                        if (firSimpleNamedReference2 == null) {
                            return;
                        }
                        FirSimpleNamedReference receiverCalleeReference = firSimpleNamedReference2;
                        Name it2 = name2 = receiverCalleeReference.getName();
                        boolean bl = false;
                        Object object2 = !it2.isSpecial() ? name2 : null;
                        if (object2 == null) {
                            return;
                        }
                        Name receiverName = object2;
                        Iterable $this$filterIsInstance$iv = AbstractFirSpecificAnnotationResolveTransformer.this.getScopes();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo2 = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof FirAbstractImportingScope)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        for (Object it3 : (Iterable)((List)destination$iv$iv)) {
                            boolean bl2 = false;
                            FirClassifierSymbol<?> $i$f$filterIsInstanceTo2 = FirScopeKt.getSingleClassifier((FirScope)it3, receiverName);
                            if ((it3 = $i$f$filterIsInstanceTo2 instanceof FirClassSymbol ? (FirClassSymbol)$i$f$filterIsInstanceTo2 : null) == null) continue;
                            object = it3;
                            break block14;
                        }
                        object = null;
                    }
                    if (object == null) {
                        return;
                    }
                    symbol2 = object;
                    List segments2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)receiver2.getExplicitReceiver(), (Function1)resolveFromImportScope.segments.1.INSTANCE), (Function1)resolveFromImportScope.segments.2.INSTANCE));
                    if (!((Collection)segments2).isEmpty() && !Intrinsics.areEqual((Object)FqName.fromSegments((List)CollectionsKt.asReversed((List)segments2)), (Object)((FirClassLikeSymbol)symbol2).getClassId().getPackageFqName())) {
                        return;
                    }
                    boolean $i$f$buildResolvedQualifier = false;
                    Object $this$resolveFromImportScope_u24lambda_u242 = it3 = new FirResolvedQualifierBuilder();
                    boolean bl = false;
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u242).setSource(receiver2.getSource());
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u242).setPackageFqName(((FirClassLikeSymbol)symbol2).getClassId().getPackageFqName());
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u242).setRelativeClassFqName(((FirClassLikeSymbol)symbol2).getClassId().getRelativeClassName());
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u242).setConeTypeOrNull(this.getSession().getBuiltinTypes().getUnitType().getType());
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u242).setSymbol((FirClassLikeSymbol)symbol2);
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u242).setFullyQualified(!((Collection)segments2).isEmpty());
                    resolvedReceiver = ((FirResolvedQualifierBuilder)it3).build();
                    Iterable $this$firstOrNull$iv = ((FirClass)((FirBasedSymbol)symbol2).getFir()).getDeclarations();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirDeclaration it4 = (FirDeclaration)element$iv;
                        boolean bl3 = false;
                        if (!(it4 instanceof FirEnumEntry && Intrinsics.areEqual((Object)((FirEnumEntry)it4).getName(), (Object)calleeReference.getName()))) continue;
                        v5 = element$iv;
                        break block15;
                    }
                    v5 = null;
                }
                FirDeclaration firDeclaration = v5;
                FirBasedSymbol<? extends FirDeclaration> firBasedSymbol = firDeclaration != null ? firDeclaration.getSymbol() : null;
                FirEnumEntrySymbol firEnumEntrySymbol = firBasedSymbol instanceof FirEnumEntrySymbol ? (FirEnumEntrySymbol)firBasedSymbol : null;
                if (firEnumEntrySymbol == null) {
                    return;
                }
                FirEnumEntrySymbol calleeSymbol = firEnumEntrySymbol;
                Object object = CompilerRequiredAnnotationEnhancementProviderKt.getCompilerRequiredAnnotationEnhancementProvider(this.getSession());
                if (object == null || (object = ((CompilerRequiredAnnotationEnhancementProvider)object).enhance((FirClassSymbol<?>)symbol2, calleeSymbol, this.getSession())) == null) {
                    object = calleeSymbol;
                }
                Object enhancedCalleeSymbol = object;
                this.updateCallee($this$resolveFromImportScope, calleeReference, (FirEnumEntrySymbol)enhancedCalleeSymbol);
                $this$resolveFromImportScope.replaceExplicitReceiver(resolvedReceiver);
                $this$resolveFromImportScope.replaceDispatchReceiver(resolvedReceiver);
            } else {
                FirVariableSymbol firVariableSymbol;
                block16: {
                    for (FirScope it : (Iterable)AbstractFirSpecificAnnotationResolveTransformer.this.getScopes()) {
                        boolean bl = false;
                        FirVariableSymbol firVariableSymbol2 = (FirVariableSymbol)CollectionsKt.firstOrNull(FirScopeKt.getProperties(it, calleeReference.getName()));
                        if (firVariableSymbol2 == null) continue;
                        firVariableSymbol = firVariableSymbol2;
                        break block16;
                    }
                    firVariableSymbol = null;
                }
                FirVariableSymbol firVariableSymbol3 = firVariableSymbol;
                FirEnumEntrySymbol firEnumEntrySymbol = firVariableSymbol3 instanceof FirEnumEntrySymbol ? (FirEnumEntrySymbol)firVariableSymbol3 : null;
                if (firEnumEntrySymbol == null) {
                    return;
                }
                FirEnumEntrySymbol calleeSymbol = firEnumEntrySymbol;
                this.updateCallee($this$resolveFromImportScope, calleeReference, calleeSymbol);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void updateCallee(FirQualifiedAccessExpression $this$updateCallee, FirSimpleNamedReference calleeReference, FirEnumEntrySymbol calleeSymbol) {
            block2: {
                void $this$updateCallee_u24lambda_u245;
                FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
                FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
                if (firLookupTrackerComponent != null) {
                    Name name2 = calleeReference.getName();
                    Object object = calleeSymbol.getDispatchReceiverType();
                    if (object == null || (object = ConeTypeUtilsKt.getClassId((ConeKotlinType)object)) == null || (object = object.asFqNameString()) == null) {
                        String string = calleeSymbol.getCallableId().getPackageName().asString();
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    }
                    FirPartialBodyResolveTransformer this_$iv = this;
                    boolean $i$f$getContext = false;
                    firLookupTrackerComponent.recordLookup(name2, (String)object, $this$updateCallee.getSource(), this_$iv.getTransformer().getContext().getFile().getSource());
                }
                boolean $i$f$buildResolvedNamedReference = false;
                FirResolvedNamedReferenceBuilder $i$f$getContext = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
                FirQualifiedAccessExpression firQualifiedAccessExpression = $this$updateCallee;
                boolean bl = false;
                $this$updateCallee_u24lambda_u245.setSource(calleeReference.getSource());
                $this$updateCallee_u24lambda_u245.setName(calleeReference.getName());
                $this$updateCallee_u24lambda_u245.setResolvedSymbol(calleeSymbol);
                firQualifiedAccessExpression.replaceCalleeReference(firResolvedNamedReferenceBuilder.build());
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(calleeSymbol);
                if (coneClassLikeLookupTag == null) break block2;
                Object it = coneClassLikeLookupTag;
                boolean bl2 = false;
                boolean $i$f$emptyArray = false;
                it = new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)it, new ConeTypeProjection[0], false, null, 8, null);
                boolean bl3 = false;
                $this$updateCallee.replaceConeTypeOrNull((ConeKotlinType)it);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformerDispatcher;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer;)V", "declarationsTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirDeclarationsResolveTransformer;", "getDeclarationsTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirDeclarationsResolveTransformer;", "expressionsTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirExpressionsResolveTransformer;", "getExpressionsTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirExpressionsResolveTransformer;", "resolve"})
    public final class FirEnumAnnotationArgumentsTransformerDispatcher
    extends FirAbstractBodyResolveTransformerDispatcher {
        @NotNull
        private final FirExpressionsResolveTransformer expressionsTransformer;
        @Nullable
        private final FirDeclarationsResolveTransformer declarationsTransformer;

        public FirEnumAnnotationArgumentsTransformerDispatcher() {
            FirSession firSession = AbstractFirSpecificAnnotationResolveTransformer.this.getSession();
            FirResolvePhase firResolvePhase = FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS;
            ScopeSession scopeSession = AbstractFirSpecificAnnotationResolveTransformer.this.getScopeSession();
            super(firSession, firResolvePhase, false, scopeSession, null, null, null, 112, null);
            this.expressionsTransformer = new FirEnumAnnotationArgumentsTransformer(this);
        }

        @Override
        @NotNull
        public FirExpressionsResolveTransformer getExpressionsTransformer() {
            return this.expressionsTransformer;
        }

        @Override
        @Nullable
        public FirDeclarationsResolveTransformer getDeclarationsTransformer() {
            return this.declarationsTransformer;
        }
    }
}

