/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationsComputationSession;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirPartialImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "computationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;)V", "acceptableFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "isAcceptable", "", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "data", "", "resolve"})
final class FirPartialImportResolveTransformer
extends FirImportResolveTransformer {
    @NotNull
    private final CompilerRequiredAnnotationsComputationSession computationSession;
    @NotNull
    private final Set<FqName> acceptableFqNames;

    public FirPartialImportResolveTransformer(@NotNull FirSession session2, @NotNull CompilerRequiredAnnotationsComputationSession computationSession) {
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Intrinsics.checkNotNullParameter((Object)computationSession, (String)"computationSession");
        super(session2, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        this.computationSession = computationSession;
        this.acceptableFqNames = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(session2).getAnnotations();
    }

    @Override
    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptable, (String)"<this>");
        return this.acceptableFqNames.contains($this$isAcceptable);
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.computationSession.importsAreResolved(file2)) {
            return file2;
        }
        FirFile it = firFile = super.transformFile(file2, data2);
        boolean bl = false;
        this.computationSession.recordThatImportsAreResolved(file2);
        return firFile;
    }
}

