/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginReleaseDateProvider;", "", "()V", "fetchPluginReleaseDate", "Ljava/time/LocalDate;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "version", "", "channel", "PluginDTO", "ResponseParseException", "kotlin.plugin-updater"})
@SourceDebugExtension(value={"SMAP\nKotlinPluginUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPluginUpdater.kt\norg/jetbrains/kotlin/idea/KotlinPluginReleaseDateProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,89:1\n1282#2,2:90\n*S KotlinDebug\n*F\n+ 1 KotlinPluginUpdater.kt\norg/jetbrains/kotlin/idea/KotlinPluginReleaseDateProvider\n*L\n74#1:90,2\n*E\n"})
public final class KotlinPluginReleaseDateProvider {
    @NotNull
    public static final KotlinPluginReleaseDateProvider INSTANCE = new KotlinPluginReleaseDateProvider();

    private KotlinPluginReleaseDateProvider() {
    }

    @Nullable
    public final LocalDate fetchPluginReleaseDate(@NotNull PluginId pluginId, @NotNull String version2, @Nullable String channel) throws IOException, ResponseParseException {
        LocalDate localDate;
        PluginDTO pluginDTO;
        block9: {
            PluginDTO[] pluginDTOs;
            PluginDTO[] pluginDTOArray;
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            String url = "https://plugins.jetbrains.com/api/plugins/" + pluginId.getIdString() + "/updates?version=" + version2;
            try {
                pluginDTOArray = HttpRequests.request((String)url).connect(KotlinPluginReleaseDateProvider::fetchPluginReleaseDate$lambda$0);
                Intrinsics.checkNotNull((Object)pluginDTOArray);
                pluginDTOArray = pluginDTOArray;
            }
            catch (JsonIOException ioException) {
                throw new IOException(ioException);
            }
            catch (JsonSyntaxException syntaxException) {
                throw new ResponseParseException("Can't parse json response", (Exception)((Object)syntaxException));
            }
            PluginDTO[] $this$firstOrNull$iv = pluginDTOs = pluginDTOArray;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int j = 0; j < n; ++j) {
                PluginDTO element$iv;
                PluginDTO it = element$iv = $this$firstOrNull$iv[j];
                boolean bl = false;
                if (!(it.getListed() && it.getApprove() && (Intrinsics.areEqual((Object)it.getChannel(), (Object)channel) || Intrinsics.areEqual((Object)it.getChannel(), (Object)"") && channel == null))) continue;
                pluginDTO = element$iv;
                break block9;
            }
            pluginDTO = null;
        }
        if (pluginDTO == null) {
            return null;
        }
        PluginDTO selectedPluginDTO = pluginDTO;
        String string = selectedPluginDTO.getCdate();
        if (string == null) {
            throw new ResponseParseException("Empty cdate", null, 2, null);
        }
        String dateString = string;
        try {
            long dateLong = Long.parseLong(dateString);
            localDate = Instant.ofEpochMilli(dateLong).atZone(ZoneOffset.UTC).toLocalDate();
        }
        catch (NumberFormatException e) {
            throw new ResponseParseException("Can't parse long date", e);
        }
        catch (DateTimeException e) {
            throw new ResponseParseException("Can't convert to date", e);
        }
        return localDate;
    }

    private static final PluginDTO[] fetchPluginReleaseDate$lambda$0(HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Gson gson = new GsonBuilder().create();
        InputStream inputStream = it.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        return (PluginDTO[])gson.fromJson((Reader)new InputStreamReader(inputStream2, charset), PluginDTO[].class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginReleaseDateProvider$PluginDTO;", "", "()V", "approve", "", "getApprove", "()Z", "setApprove", "(Z)V", "cdate", "", "getCdate", "()Ljava/lang/String;", "setCdate", "(Ljava/lang/String;)V", "channel", "getChannel", "setChannel", "listed", "getListed", "setListed", "kotlin.plugin-updater"})
    private static final class PluginDTO {
        @Nullable
        private String cdate;
        @Nullable
        private String channel;
        private boolean listed = true;
        private boolean approve = true;

        @Nullable
        public final String getCdate() {
            return this.cdate;
        }

        public final void setCdate(@Nullable String string) {
            this.cdate = string;
        }

        @Nullable
        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(@Nullable String string) {
            this.channel = string;
        }

        public final boolean getListed() {
            return this.listed;
        }

        public final void setListed(boolean bl) {
            this.listed = bl;
        }

        public final boolean getApprove() {
            return this.approve;
        }

        public final void setApprove(boolean bl) {
            this.approve = bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginReleaseDateProvider$ResponseParseException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "message", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "kotlin.plugin-updater"})
    public static final class ResponseParseException
    extends IllegalStateException {
        public ResponseParseException(@NotNull String message2, @Nullable Exception cause) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2, cause);
        }

        public /* synthetic */ ResponseParseException(String string, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                exception = null;
            }
            this(string, exception);
        }
    }
}

