/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.base.codeInsight.JavaToKotlinConversionUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeatures;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ExternalCodeProcessing;
import org.jetbrains.kotlin.j2k.FilesResult;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.OldJavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabled", "", "update", "Handler", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nJavaToKotlinAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,326:1\n1774#2,4:327\n12474#3,2:331\n12474#3,2:333\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction\n*L\n267#1:327,4\n316#1:331,2\n324#1:333,2\n*E\n"})
public final class JavaToKotlinAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List javaFiles2 = SequencesKt.toList((Sequence)SequencesKt.filter(Handler.INSTANCE.selectedJavaFiles$kotlin_idea(e), (Function1)actionPerformed.javaFiles.1.INSTANCE));
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Module module2 = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        if (javaFiles2.isEmpty()) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project3);
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(KotlinBundle.message("action.j2k.error.nothing.to.convert", new Object[0]), MessageType.ERROR, null).createBalloon().showInCenterOf(statusBar.getComponent());
            return;
        }
        if (!J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).doCheckBeforeConversion(project3, module3)) {
            return;
        }
        PsiErrorElement firstSyntaxError2 = (PsiErrorElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)javaFiles2), (Function1)actionPerformed.firstSyntaxError.1.INSTANCE));
        if (firstSyntaxError2 != null) {
            String string;
            int n;
            Iterable $this$count$iv = javaFiles2;
            boolean $i$f$count2 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    PsiJavaFile it = (PsiJavaFile)element$iv;
                    boolean bl = false;
                    if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int count = n;
            boolean bl = $this$count$iv = count > 0;
            if (_Assertions.ENABLED && !$this$count$iv) {
                String $i$f$count2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$count2);
            }
            String string2 = firstSyntaxError2.getContainingFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String firstFileName = string2;
            if (count == 1) {
                var10_15 = new Object[]{firstFileName};
                string = KotlinBundle.message("action.j2k.correction.errors.single", var10_15);
            } else {
                var10_15 = new Object[]{firstFileName, count - 1};
                string = KotlinBundle.message("action.j2k.correction.errors.multiple", var10_15);
            }
            String question = string;
            String okText = KotlinBundle.message("action.j2k.correction.investigate", new Object[0]);
            String cancelText = KotlinBundle.message("action.j2k.correction.proceed", new Object[0]);
            if (Messages.showOkCancelDialog((Project)project3, (String)question, (String)Handler.INSTANCE.getTitle(), (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon()) == 0) {
                PsiElement psiElement2 = firstSyntaxError2.getNavigationElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNavigationElement(...)");
                NavigationUtil.activateFileWithPsiElement$default((PsiElement)psiElement2, (boolean)false, (int)2, null);
                return;
            }
        }
        Handler.convertFiles$default(Handler.INSTANCE, javaFiles2, project3, module3, false, false, false, 56, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.isEnabled(e));
    }

    private final boolean isEnabled(AnActionEvent e) {
        boolean bl;
        block10: {
            VirtualFile p0;
            VirtualFile element$iv;
            int n;
            int n2;
            boolean $i$f$any;
            VirtualFile[] $this$any$iv;
            if (KotlinPlatformUtils.isCidr()) {
                return false;
            }
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return false;
            }
            VirtualFile[] files2 = virtualFileArray;
            Project project2 = e.getProject();
            if (project2 == null) {
                return false;
            }
            Project project3 = project2;
            if (project3.isDisposed()) {
                return false;
            }
            if (e.getData(PlatformCoreDataKeys.MODULE) == null) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)e.getPlace(), (Object)"ProjectViewPopup")) {
                boolean bl2;
                block9: {
                    $this$any$iv = files2;
                    $i$f$any = false;
                    n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        p0 = element$iv = $this$any$iv[n];
                        boolean bl3 = false;
                        if (!JavaToKotlinAction.isEnabled$isWritablePackageDirectory(project3, p0)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return true;
                }
            }
            $this$any$iv = files2;
            $i$f$any = false;
            n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                p0 = element$iv = $this$any$iv[n];
                boolean bl4 = false;
                if (!JavaToKotlinAction.isEnabled$isWritableJavaFile(project3, p0)) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isEnabled$isWritableJavaFile(Project project2, VirtualFile file2) {
        PsiManager psiManager2 = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(...)");
        PsiManager psiManager3 = psiManager2;
        return Intrinsics.areEqual((Object)file2.getExtension(), (Object)"java") && psiManager3.findFile(file2) instanceof PsiJavaFile && file2.isWritable();
    }

    private static final boolean isEnabled$isWritablePackageDirectory(Project project2, VirtualFile file2) {
        PsiDirectory psiDirectory = PhysicalFileSystemUtilsKt.toPsiDirectory(file2, project2);
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory directory = psiDirectory;
        return PsiDirectoryFactory.getInstance((Project)project2).isPackage(directory) && file2.isWritable();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJH\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u0017JR\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002J\u001b\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler;", "", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "allJavaFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiJavaFile;", "filesOrDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "convertFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "module", "Lcom/intellij/openapi/module/Module;", "enableExternalCodeProcessing", "", "askExternalCodeProcessing", "forceUsingOldJ2k", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "saveResults", "javaFiles", "convertedTexts", "selectedJavaFiles", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "selectedJavaFiles$kotlin_idea", "uniqueKotlinFileName", "javaFile", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nJavaToKotlinAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,326:1\n766#2:327\n857#2,2:328\n1#3:330\n17#4,6:331\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler\n*L\n134#1:327\n134#1:328,2\n158#1:331,6\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final String title = KotlinBundle.message("action.j2k.name", new Object[0]);

        private Handler() {
        }

        private final String uniqueKotlinFileName(VirtualFile javaFile) {
            Path nioFile = javaFile.getFileSystem().getNioPath(javaFile);
            int i2 = 0;
            while (true) {
                block4: {
                    String fileName;
                    block3: {
                        Path path2;
                        fileName = javaFile.getNameWithoutExtension() + (i2 > 0 ? Integer.valueOf(i2) : "") + ".kt";
                        if (nioFile == null) break block3;
                        Intrinsics.checkNotNullExpressionValue((Object)nioFile.resolveSibling(fileName), (String)"resolveSibling(...)");
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block4;
                    }
                    return fileName;
                }
                ++i2;
            }
        }

        @NotNull
        public final String getTitle() {
            return title;
        }

        private final List<VirtualFile> saveResults(List<? extends PsiJavaFile> javaFiles2, List<String> convertedTexts) {
            ArrayList result2 = new ArrayList();
            for (Pair pair : CollectionsKt.zip((Iterable)javaFiles2, (Iterable)convertedTexts)) {
                PsiJavaFile psiFile2 = (PsiJavaFile)pair.component1();
                String text2 = (String)pair.component2();
                try {
                    String errorMessage;
                    Document document = PsiDocumentManager.getInstance((Project)psiFile2.getProject()).getDocument((PsiFile)psiFile2);
                    if (document == null) {
                        var10_11 = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile2.getName(), (String)"getName(...)");
                        v0 = KotlinBundle.message("action.j2k.error.cant.find.document", var10_11);
                    } else if (!document.isWritable()) {
                        var10_11 = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile2.getName(), (String)"getName(...)");
                        v0 = KotlinBundle.message("action.j2k.error.read.only", var10_11);
                    } else {
                        v0 = errorMessage = null;
                    }
                    if (errorMessage != null) {
                        Object[] objectArray = new Object[]{errorMessage};
                        String message2 = KotlinBundle.message("action.j2k.error.cant.save.result", objectArray);
                        MessagesEx.error((Project)psiFile2.getProject(), (String)message2).showLater();
                        continue;
                    }
                    Document document2 = document;
                    Intrinsics.checkNotNull((Object)document2);
                    document2.replaceString(0, document.getTextLength(), (CharSequence)text2);
                    FileDocumentManager.getInstance().saveDocument(document);
                    VirtualFile virtualFile2 = psiFile2.getVirtualFile();
                    if (ScratchRootType.getInstance().containsFile(virtualFile2)) {
                        PerFileMappings mapping2;
                        Intrinsics.checkNotNullExpressionValue((Object)ScratchFileService.getInstance().getScratchesMapping(), (String)"getScratchesMapping(...)");
                        mapping2.setMapping(virtualFile2, (Object)KotlinFileType.INSTANCE.getLanguage());
                    } else {
                        Intrinsics.checkNotNull((Object)virtualFile2);
                        String fileName = this.uniqueKotlinFileName(virtualFile2);
                        JavaToKotlinConversionUtils.setPathBeforeJavaToKotlinConversion(virtualFile2, virtualFile2.getPath());
                        virtualFile2.rename((Object)this, fileName);
                    }
                    ((Collection)result2).add(virtualFile2);
                }
                catch (IOException e) {
                    Project project2 = psiFile2.getProject();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    MessagesEx.error((Project)project2, (String)string).showLater();
                }
            }
            return result2;
        }

        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> files2, @NotNull Project project2, @NotNull Module module2, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k) {
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            return this.convertFiles(files2, project2, module2, enableExternalCodeProcessing, askExternalCodeProcessing, forceUsingOldJ2k, ConverterSettings.Companion.getDefaultSettings());
        }

        public static /* synthetic */ List convertFiles$default(Handler handler, List list2, Project project2, Module module2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            return handler.convertFiles(list2, project2, module2, bl, bl2, bl3);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> files2, @NotNull Project project2, @NotNull Module module2, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k, @NotNull ConverterSettings settings2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            Iterable $this$filter$iv = files2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                boolean bl = false;
                if (!it.getVirtualFile().isWritable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            if ($this$filter$iv.isEmpty()) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            List javaFiles2 = (List)$this$filter$iv;
            Ref.ObjectRef converterResult = new Ref.ObjectRef();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Handler.convertFiles$convertWithStatistics(javaFiles2, forceUsingOldJ2k, project2, settings2, module2, converterResult), title, true, project2)) {
                return CollectionsKt.emptyList();
            }
            Ref.ObjectRef externalCodeUpdate = new Ref.ObjectRef();
            FilesResult filesResult = (FilesResult)converterResult.element;
            if (filesResult == null) {
                return CollectionsKt.emptyList();
            }
            FilesResult result2 = filesResult;
            ExternalCodeProcessing externalCodeProcessing2 = result2.getExternalCodeProcessing();
            if (enableExternalCodeProcessing && externalCodeProcessing2 != null) {
                String question = KotlinBundle.message("action.j2k.correction.required", new Object[0]);
                if (!askExternalCodeProcessing || Messages.showYesNoDialog((Project)project2, (String)question, (String)title, (Icon)Messages.getQuestionIcon()) == 0) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Handler.convertFiles$lambda$3(externalCodeUpdate, externalCodeProcessing2), title, true, project2);
                }
            }
            return (List)ApplicationUtilsKt.executeWriteCommand(project2, KotlinBundle.message("action.j2k.task.name", new Object[0]), null, (Function0)new Function0<List<? extends KtFile>>(project2, (List<? extends PsiJavaFile>)javaFiles2, result2, (Ref.ObjectRef<Function1<List<? extends KtFile>, Unit>>)externalCodeUpdate){
                final /* synthetic */ Project $project;
                final /* synthetic */ List<PsiJavaFile> $javaFiles;
                final /* synthetic */ FilesResult $result;
                final /* synthetic */ Ref.ObjectRef<Function1<List<? extends KtFile>, Unit>> $externalCodeUpdate;
                {
                    this.$project = $project;
                    this.$javaFiles = $javaFiles;
                    this.$result = $result;
                    this.$externalCodeUpdate = $externalCodeUpdate;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<KtFile> invoke() {
                    List newFiles;
                    block3: {
                        Iterable iterable;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.$project);
                        Iterable iterable2 = Handler.access$saveResults(Handler.INSTANCE, this.$javaFiles, this.$result.getResults());
                        Project project2 = this.$project;
                        boolean $i$f$map = false;
                        void var5_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)it, project2);
                            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                            collection.add((KtFile)psiFile2);
                        }
                        Iterable $this$onEach$iv = (List)destination$iv$iv;
                        boolean $i$f$onEach = false;
                        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
                        boolean bl = false;
                        for (T element$iv : $this$onEach_u24lambda_u2416$iv) {
                            KtFile it = (KtFile)element$iv;
                            boolean bl2 = false;
                            DocumentUtilsKt.commitAndUnblockDocument((PsiFile)it);
                        }
                        newFiles = (List)iterable;
                        Function1 function1 = (Function1)this.$externalCodeUpdate.element;
                        if (function1 != null) {
                            function1.invoke((Object)newFiles);
                        }
                        PsiDocumentManager.getInstance((Project)this.$project).commitAllDocuments();
                        KtFile ktFile = (KtFile)CollectionsKt.singleOrNull((List)newFiles);
                        if (ktFile == null) break block3;
                        KtFile ktFile2 = ktFile;
                        iterable = this.$project;
                        KtFile it = ktFile2;
                        boolean bl3 = false;
                        FileEditorManager.getInstance((Project)iterable).openFile(it.getVirtualFile(), true);
                    }
                    return newFiles;
                }
            });
        }

        public static /* synthetic */ List convertFiles$default(Handler handler, List list2, Project project2, Module module2, boolean bl, boolean bl2, boolean bl3, ConverterSettings converterSettings, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            if ((n & 0x40) != 0) {
                converterSettings = ConverterSettings.Companion.getDefaultSettings();
            }
            return handler.convertFiles(list2, project2, module2, bl, bl2, bl3, converterSettings);
        }

        @NotNull
        public final Sequence<PsiJavaFile> selectedJavaFiles$kotlin_idea(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
            }
            VirtualFile[] virtualFiles = virtualFileArray;
            Project project2 = e.getProject();
            if (project2 == null) {
                return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
            }
            Project project3 = project2;
            return this.allJavaFiles(virtualFiles, project3);
        }

        private final Sequence<PsiJavaFile> allJavaFiles(VirtualFile[] filesOrDirs, Project project2) {
            PsiManager psiManager2 = PsiManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(...)");
            PsiManager manager = psiManager2;
            return SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)FileUtils.getAllFilesRecursively(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, PsiJavaFile>(manager){
                final /* synthetic */ PsiManager $manager;
                {
                    this.$manager = $manager;
                    super(1);
                }

                @Nullable
                public final PsiJavaFile invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    PsiFile psiFile2 = this.$manager.findFile(it);
                    return psiFile2 instanceof PsiJavaFile ? (PsiJavaFile)psiFile2 : null;
                }
            })), (Function1)allJavaFiles.2.INSTANCE);
        }

        private static final void convertFiles$convert(boolean $forceUsingOldJ2k, Project $project, ConverterSettings $settings, Module $module, Ref.ObjectRef<FilesResult> converterResult, List<? extends PsiJavaFile> javaFiles2) {
            JavaToKotlinConverter converter = $forceUsingOldJ2k ? (JavaToKotlinConverter)new OldJavaToKotlinConverter($project, $settings, IdeaJavaToKotlinServices.INSTANCE) : J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).createJavaToKotlinConverter($project, $module, $settings, IdeaJavaToKotlinServices.INSTANCE);
            PostProcessor postProcessor2 = $forceUsingOldJ2k ? (PostProcessor)new J2kPostProcessor(true) : J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).createPostProcessor(true);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator);
            converterResult.element = converter.filesToKotlin(javaFiles2, postProcessor2, progressIndicator);
        }

        private static final void convertFiles$convertWithStatistics(List<? extends PsiJavaFile> javaFiles2, boolean $forceUsingOldJ2k, Project $project, ConverterSettings $settings, Module $module, Ref.ObjectRef<FilesResult> converterResult) {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Handler.convertFiles$convert($forceUsingOldJ2k, $project, $settings, $module, converterResult, javaFiles2);
            long conversionTime = System.currentTimeMillis() - start$iv;
            int linesCount2 = ((Number)ActionsKt.runReadAction((Function0)((Function0)new Function0<Integer>(javaFiles2){
                final /* synthetic */ List<PsiJavaFile> $javaFiles;
                {
                    this.$javaFiles = $javaFiles;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Integer invoke() {
                    Iterable iterable = this.$javaFiles;
                    int n = 0;
                    for (T t : iterable) {
                        void it;
                        PsiJavaFile psiJavaFile = (PsiJavaFile)t;
                        int n2 = n;
                        boolean bl = false;
                        int n3 = StringUtil.getLineBreakCount((CharSequence)it.getText());
                        n = n2 + n3;
                    }
                    return n;
                }
            }))).intValue();
            J2KFusCollector.INSTANCE.log(ConversionType.FILES, ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled(), conversionTime, linesCount2, javaFiles2.size());
        }

        private static final void convertFiles$lambda$3(Ref.ObjectRef $externalCodeUpdate, ExternalCodeProcessing $externalCodeProcessing) {
            Intrinsics.checkNotNullParameter((Object)$externalCodeUpdate, (String)"$externalCodeUpdate");
            ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<Function1<List<? extends KtFile>, Unit>>)$externalCodeUpdate, $externalCodeProcessing){
                final /* synthetic */ Ref.ObjectRef<Function1<List<? extends KtFile>, Unit>> $externalCodeUpdate;
                final /* synthetic */ ExternalCodeProcessing $externalCodeProcessing;
                {
                    this.$externalCodeUpdate = $externalCodeUpdate;
                    this.$externalCodeProcessing = $externalCodeProcessing;
                    super(0);
                }

                public final void invoke() {
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkNotNull((Object)progressIndicator);
                    this.$externalCodeUpdate.element = this.$externalCodeProcessing.prepareWriteOperation(progressIndicator);
                }
            }));
        }

        public static final /* synthetic */ List access$saveResults(Handler $this, List javaFiles2, List convertedTexts) {
            return $this.saveResults(javaFiles2, convertedTexts);
        }
    }
}

