/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiProviders;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.providers.KotlinAnnotationsResolver;
import org.jetbrains.kotlin.idea.base.analysisApiProviders.IdeKotlinAnnotationsResolver;
import org.jetbrains.kotlin.idea.stubindex.KotlinAnnotationsIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\n*\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\r*\u00020\u001bH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\n0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/IdeKotlinAnnotationsResolver;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinAnnotationsResolver;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "annotationActuallyExists", "", "matchingImport", "Lorg/jetbrains/kotlin/name/FqName;", "annotationsOnDeclaration", "", "Lorg/jetbrains/kotlin/name/ClassId;", "declaration", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "declarationsByAnnotation", "queriedAnnotation", "getCandidatesFromImports", "Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/IdeKotlinAnnotationsResolver$ResolveByImportsCandidates;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetName", "Lorg/jetbrains/kotlin/name/Name;", "referencedFqName", "Lorg/jetbrains/kotlin/psi/KtUserType;", "resolveAnnotationFqName", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "resolveAnnotationId", "resolveToSingleName", "ResolveByImportsCandidates", "kotlin.base.analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nIdeKotlinAnnotationsResolverFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinAnnotationsResolverFactory.kt\norg/jetbrains/kotlin/idea/base/analysisApiProviders/IdeKotlinAnnotationsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1603#2,9:145\n1855#2:154\n1856#2:156\n1612#2:157\n1549#2:158\n1620#2,3:159\n661#2,11:163\n661#2,11:174\n1#3:155\n1#3:162\n*S KotlinDebug\n*F\n+ 1 IdeKotlinAnnotationsResolverFactory.kt\norg/jetbrains/kotlin/idea/base/analysisApiProviders/IdeKotlinAnnotationsResolver\n*L\n53#1:145,9\n53#1:154\n53#1:156\n53#1:157\n65#1:158\n65#1:159,3\n125#1:163,11\n129#1:174,11\n53#1:155\n*E\n"})
final class IdeKotlinAnnotationsResolver
implements KotlinAnnotationsResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;

    public IdeKotlinAnnotationsResolver(@NotNull Project project2, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        this.project = project2;
        this.searchScope = searchScope2;
    }

    @Override
    @NotNull
    public Set<KtAnnotated> declarationsByAnnotation(@NotNull ClassId queriedAnnotation) {
        Intrinsics.checkNotNullParameter((Object)queriedAnnotation, (String)"queriedAnnotation");
        if (!(!queriedAnnotation.isLocal() && !queriedAnnotation.isNestedClass())) {
            boolean bl = false;
            String string = "Queried annotation must be top-level, but was " + queriedAnnotation;
            throw new IllegalArgumentException(string.toString());
        }
        String string = queriedAnnotation.getShortClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        Collection annotationEntries = KotlinAnnotationsIndex.Helper.get(string, this.project, this.searchScope);
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)annotationEntries), (Function1)((Function1)new Function1<KtAnnotationEntry, Boolean>(this, queriedAnnotation){
            final /* synthetic */ IdeKotlinAnnotationsResolver this$0;
            final /* synthetic */ ClassId $queriedAnnotation;
            {
                this.this$0 = $receiver;
                this.$queriedAnnotation = $queriedAnnotation;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtAnnotationEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)IdeKotlinAnnotationsResolver.access$resolveAnnotationId(this.this$0, it), (Object)this.$queriedAnnotation);
            }
        })), (Function1)declarationsByAnnotation.3.INSTANCE), (Function1)declarationsByAnnotation.4.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<ClassId> annotationsOnDeclaration(@NotNull KtAnnotated declaration2) {
        void $this$mapNotNullTo$iv$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtAnnotated ktAnnotated = declaration2;
        if (ktAnnotated instanceof KtFile) {
            list2 = ((KtFile)declaration2).getAnnotationEntries();
        } else if (ktAnnotated instanceof KtDeclaration) {
            List list3 = ((KtDeclaration)declaration2).getAnnotationEntries();
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getAnnotationEntries(...)");
        } else {
            throw new IllegalStateException(("Unexpected element of class " + Reflection.getOrCreateKotlinClass(declaration2.getClass())).toString());
        }
        List annotationEntries = list2;
        Iterable $this$mapNotNull$iv = annotationEntries;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
            boolean bl2 = false;
            if (this.resolveAnnotationId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final FqName referencedFqName(KtUserType $this$referencedFqName) {
        void $this$mapTo$iv$iv;
        List allTypes2 = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)$this$referencedFqName, (Function1)referencedFqName.allTypes.1.INSTANCE)));
        Iterable $this$map$iv = allTypes2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtUserType ktUserType2 = (KtUserType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getReferencedName();
            if (string == null) {
                return null;
            }
            collection.add(string);
        }
        List allQualifiers = (List)destination$iv$iv;
        return FqName.fromSegments((List)allQualifiers);
    }

    private final ClassId resolveAnnotationId(KtAnnotationEntry $this$resolveAnnotationId) {
        ClassId classId;
        FqName fqName2 = this.resolveAnnotationFqName($this$resolveAnnotationId);
        if (fqName2 != null) {
            FqName it = fqName2;
            boolean bl = false;
            classId = ClassId.Companion.topLevel(it);
        } else {
            classId = null;
        }
        return classId;
    }

    private final FqName resolveAnnotationFqName(KtAnnotationEntry $this$resolveAnnotationFqName) {
        KtTypeReference ktTypeReference = $this$resolveAnnotationFqName.getTypeReference();
        Object object = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        KtUserType annotationTypeElement = object instanceof KtUserType ? (KtUserType)object : null;
        KtUserType ktUserType2 = annotationTypeElement;
        if (ktUserType2 == null || (ktUserType2 = this.referencedFqName(ktUserType2)) == null) {
            return null;
        }
        KtUserType referencedName = ktUserType2;
        if (referencedName.isRoot()) {
            return null;
        }
        if (!referencedName.parent().isRoot()) {
            KtUserType ktUserType3;
            KtUserType it = ktUserType3 = referencedName;
            boolean bl = false;
            return this.annotationActuallyExists((FqName)it) ? ktUserType3 : null;
        }
        KtFile ktFile = $this$resolveAnnotationFqName.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        Name name2 = referencedName.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
        ResolveByImportsCandidates candidates2 = this.getCandidatesFromImports(ktFile, name2);
        FqName fqName2 = this.resolveToSingleName(candidates2.getFromExplicitImports());
        if (fqName2 == null && (fqName2 = this.resolveToSingleName(candidates2.getFromSamePackage())) == null) {
            fqName2 = this.resolveToSingleName(candidates2.getFromStarImports());
        }
        return fqName2;
    }

    private final ResolveByImportsCandidates getCandidatesFromImports(KtFile file2, Name targetName) {
        Set starImports = new LinkedHashSet();
        Set explicitImports = new LinkedHashSet();
        for (KtImportDirective ktImportDirective : file2.getImportDirectives()) {
            FqName importedName;
            if (ktImportDirective.getImportedFqName() == null) continue;
            if (ktImportDirective.isAllUnder()) {
                ((Collection)starImports).add(importedName.child(targetName));
                continue;
            }
            if (!Intrinsics.areEqual((Object)importedName.shortName(), (Object)targetName)) continue;
            ((Collection)explicitImports).add(importedName);
        }
        FqName fqName2 = file2.getPackageFqName().child(targetName);
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        FqName packageImport = fqName2;
        return new ResolveByImportsCandidates(SetsKt.setOf((Object)packageImport), explicitImports, starImports);
    }

    private final FqName resolveToSingleName(Set<FqName> $this$resolveToSingleName) {
        Object v0;
        block2: {
            Iterable $this$singleOrNull$iv = $this$resolveToSingleName;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                FqName it = (FqName)element$iv;
                boolean bl = false;
                if (!this.annotationActuallyExists(it)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    private final boolean annotationActuallyExists(FqName matchingImport) {
        Object v1;
        block2: {
            String string = matchingImport.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            Collection foundClasses = KotlinFullClassNameIndex.Helper.get(string, this.project, this.searchScope);
            Iterable $this$singleOrNull$iv = foundClasses;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl = false;
                if (!(it.isAnnotation() && it.isTopLevel())) continue;
                if (found$iv) {
                    v1 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        return v1 != null;
    }

    public static final /* synthetic */ ClassId access$resolveAnnotationId(IdeKotlinAnnotationsResolver $this, KtAnnotationEntry $receiver) {
        return $this.resolveAnnotationId($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/IdeKotlinAnnotationsResolver$ResolveByImportsCandidates;", "", "fromSamePackage", "", "Lorg/jetbrains/kotlin/name/FqName;", "fromExplicitImports", "fromStarImports", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getFromExplicitImports", "()Ljava/util/Set;", "getFromSamePackage", "getFromStarImports", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.base.analysis-api-providers"})
    private static final class ResolveByImportsCandidates {
        @NotNull
        private final Set<FqName> fromSamePackage;
        @NotNull
        private final Set<FqName> fromExplicitImports;
        @NotNull
        private final Set<FqName> fromStarImports;

        public ResolveByImportsCandidates(@NotNull Set<FqName> fromSamePackage, @NotNull Set<FqName> fromExplicitImports, @NotNull Set<FqName> fromStarImports) {
            Intrinsics.checkNotNullParameter(fromSamePackage, (String)"fromSamePackage");
            Intrinsics.checkNotNullParameter(fromExplicitImports, (String)"fromExplicitImports");
            Intrinsics.checkNotNullParameter(fromStarImports, (String)"fromStarImports");
            this.fromSamePackage = fromSamePackage;
            this.fromExplicitImports = fromExplicitImports;
            this.fromStarImports = fromStarImports;
        }

        @NotNull
        public final Set<FqName> getFromSamePackage() {
            return this.fromSamePackage;
        }

        @NotNull
        public final Set<FqName> getFromExplicitImports() {
            return this.fromExplicitImports;
        }

        @NotNull
        public final Set<FqName> getFromStarImports() {
            return this.fromStarImports;
        }

        @NotNull
        public final Set<FqName> component1() {
            return this.fromSamePackage;
        }

        @NotNull
        public final Set<FqName> component2() {
            return this.fromExplicitImports;
        }

        @NotNull
        public final Set<FqName> component3() {
            return this.fromStarImports;
        }

        @NotNull
        public final ResolveByImportsCandidates copy(@NotNull Set<FqName> fromSamePackage, @NotNull Set<FqName> fromExplicitImports, @NotNull Set<FqName> fromStarImports) {
            Intrinsics.checkNotNullParameter(fromSamePackage, (String)"fromSamePackage");
            Intrinsics.checkNotNullParameter(fromExplicitImports, (String)"fromExplicitImports");
            Intrinsics.checkNotNullParameter(fromStarImports, (String)"fromStarImports");
            return new ResolveByImportsCandidates(fromSamePackage, fromExplicitImports, fromStarImports);
        }

        public static /* synthetic */ ResolveByImportsCandidates copy$default(ResolveByImportsCandidates resolveByImportsCandidates, Set set2, Set set3, Set set4, int n, Object object) {
            if ((n & 1) != 0) {
                set2 = resolveByImportsCandidates.fromSamePackage;
            }
            if ((n & 2) != 0) {
                set3 = resolveByImportsCandidates.fromExplicitImports;
            }
            if ((n & 4) != 0) {
                set4 = resolveByImportsCandidates.fromStarImports;
            }
            return resolveByImportsCandidates.copy(set2, set3, set4);
        }

        @NotNull
        public String toString() {
            return "ResolveByImportsCandidates(fromSamePackage=" + this.fromSamePackage + ", fromExplicitImports=" + this.fromExplicitImports + ", fromStarImports=" + this.fromStarImports + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.fromSamePackage).hashCode();
            result2 = result2 * 31 + ((Object)this.fromExplicitImports).hashCode();
            result2 = result2 * 31 + ((Object)this.fromStarImports).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof ResolveByImportsCandidates)) {
                return false;
            }
            ResolveByImportsCandidates resolveByImportsCandidates = (ResolveByImportsCandidates)other2;
            if (!Intrinsics.areEqual(this.fromSamePackage, resolveByImportsCandidates.fromSamePackage)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fromExplicitImports, resolveByImportsCandidates.fromExplicitImports)) {
                return false;
            }
            return Intrinsics.areEqual(this.fromStarImports, resolveByImportsCandidates.fromStarImports);
        }
    }
}

