/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight.compiler;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KtCompilationResult;
import org.jetbrains.kotlin.analysis.api.components.KtCompiledFile;
import org.jetbrains.kotlin.analysis.api.components.KtCompilerFacilityMixIn;
import org.jetbrains.kotlin.analysis.api.components.KtCompilerTarget;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a@\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u001a@\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0010"}, d2={"compileToDirectory", "Lorg/jetbrains/kotlin/analysis/api/components/KtCompilationResult;", "Lorg/jetbrains/kotlin/analysis/api/components/KtCompilerFacilityMixIn;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "target", "Lorg/jetbrains/kotlin/analysis/api/components/KtCompilerTarget;", "allowedErrorFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnostic;", "", "destination", "Ljava/io/File;", "compileToJar", "kotlin.base.code-insight"})
@JvmName(name="KtCompilerFacilityUtils")
public final class KtCompilerFacilityUtils {
    @ApiStatus.Internal
    @NotNull
    public static final KtCompilationResult compileToDirectory(@NotNull KtCompilerFacilityMixIn $this$compileToDirectory, @NotNull KtFile file2, @NotNull CompilerConfiguration configuration2, @NotNull KtCompilerTarget target2, @NotNull Function1<? super KtDiagnostic, Boolean> allowedErrorFilter2, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)$this$compileToDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(allowedErrorFilter2, (String)"allowedErrorFilter");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        KtCompilationResult result2 = $this$compileToDirectory.compile(file2, configuration2, target2, allowedErrorFilter2);
        if (result2 instanceof KtCompilationResult.Success) {
            for (KtCompiledFile outputFile : ((KtCompilationResult.Success)result2).getOutput()) {
                File target3 = new File(destination, outputFile.getPath());
                File file3 = target3.getParentFile();
                if (file3 == null) {
                    throw new IllegalStateException(("Can't find parent for file " + target3).toString());
                }
                file3.mkdirs();
                FilesKt.writeBytes((File)target3, (byte[])outputFile.getContent());
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final KtCompilationResult compileToJar(@NotNull KtCompilerFacilityMixIn $this$compileToJar, @NotNull KtFile file2, @NotNull CompilerConfiguration configuration2, @NotNull KtCompilerTarget target2, @NotNull Function1<? super KtDiagnostic, Boolean> allowedErrorFilter2, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)$this$compileToJar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(allowedErrorFilter2, (String)"allowedErrorFilter");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        KtCompilationResult result2 = $this$compileToJar.compile(file2, configuration2, target2, allowedErrorFilter2);
        if (result2 instanceof KtCompilationResult.Success) {
            Closeable closeable = new FileOutputStream(destination);
            int n = 8192;
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            Throwable throwable = null;
            try {
                BufferedOutputStream os = (BufferedOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new ZipOutputStream(os);
                Throwable throwable2 = null;
                try {
                    ZipOutputStream zos = (ZipOutputStream)closeable2;
                    boolean bl2 = false;
                    for (KtCompiledFile outputFile : ((KtCompilationResult.Success)result2).getOutput()) {
                        zos.putNextEntry(new ZipEntry(outputFile.getPath()));
                        zos.write(outputFile.getContent());
                        zos.closeEntry();
                    }
                    Unit unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit3 = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return result2;
    }
}

