/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.facet.platform;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.base.platforms.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.project.ModulePlatformCache;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0004\u00a8\u0006\u000e"}, d2={"explicitPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getExplicitPlatform", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/platform/TargetPlatform;", "platform", "Lcom/intellij/openapi/module/Module;", "getPlatform", "(Lcom/intellij/openapi/module/Module;)Lorg/jetbrains/kotlin/platform/TargetPlatform;", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/kotlin/platform/TargetPlatform;", "calculateTargetPlatform", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.base.facet"})
@JvmName(name="TargetPlatformDetectorUtils")
public final class TargetPlatformDetectorUtils {
    @Nullable
    public static final TargetPlatform getExplicitPlatform(@NotNull KtElement $this$explicitPlatform) {
        Intrinsics.checkNotNullParameter((Object)$this$explicitPlatform, (String)"<this>");
        KtFile ktFile = $this$explicitPlatform.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        return TargetPlatformDetectorUtils.calculateTargetPlatform(ktFile);
    }

    @NotNull
    public static final TargetPlatform getPlatform(@NotNull KtElement $this$platform) {
        Intrinsics.checkNotNullParameter((Object)$this$platform, (String)"<this>");
        TargetPlatform targetPlatform = TargetPlatformDetectorUtils.getExplicitPlatform($this$platform);
        if (targetPlatform == null) {
            targetPlatform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
        }
        return targetPlatform;
    }

    @Nullable
    public static final TargetPlatform getPlatform(@NotNull Project $this$platform) {
        Intrinsics.checkNotNullParameter((Object)$this$platform, (String)"<this>");
        String string = ((K2JVMCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance($this$platform).getSettings()).getJvmTarget();
        if (string == null) {
            return null;
        }
        String jvmTarget2 = string;
        JvmTarget jvmTarget3 = JvmTarget.Companion.fromString(jvmTarget2);
        if (jvmTarget3 == null) {
            return null;
        }
        JvmTarget version2 = jvmTarget3;
        return JvmPlatforms.INSTANCE.jvmPlatformByTargetVersion(version2);
    }

    @NotNull
    public static final TargetPlatform getPlatform(@NotNull Module $this$platform) {
        Intrinsics.checkNotNullParameter((Object)$this$platform, (String)"<this>");
        return (TargetPlatform)ActionsKt.runReadAction((Function0)((Function0)new Function0<TargetPlatform>($this$platform){
            final /* synthetic */ Module $this_platform;
            {
                this.$this_platform = $receiver;
                super(0);
            }

            @NotNull
            public final TargetPlatform invoke() {
                Project project2 = this.$this_platform.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                return (TargetPlatform)ModulePlatformCache.Companion.getInstance(project2).get(this.$this_platform);
            }
        }));
    }

    private static final TargetPlatform calculateTargetPlatform(KtFile file2) {
        Module moduleForFile;
        TargetPlatform forcedPlatform = KotlinPlatformUtils.getForcedTargetPlatform(file2);
        if (forcedPlatform != null) {
            return forcedPlatform;
        }
        PsiElement context2 = KtPsiFactoryKt.getAnalysisContext((KtFile)file2);
        if (context2 != null) {
            PsiFile contextFile = context2.getContainingFile();
            if (contextFile instanceof KtFile) {
                return TargetPlatformDetectorUtils.calculateTargetPlatform((KtFile)contextFile);
            }
            return JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
        }
        Object[] objectArray = file2.getProject().getExtensionArea().getExtensionPoint(TargetPlatformDetector.Companion.getEP_NAME()).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
        for (TargetPlatformDetector extension2 : (TargetPlatformDetector[])objectArray) {
            TargetPlatform platform2 = extension2.detectPlatform(file2);
            if (platform2 == null) continue;
            return platform2;
        }
        VirtualFile virtualFile2 = file2.getOriginalFile().getVirtualFile();
        if (virtualFile2 != null && (moduleForFile = ProjectFileIndex.getInstance((Project)file2.getProject()).getModuleForFile(virtualFile2)) != null) {
            return TargetPlatformDetectorUtils.getPlatform(moduleForFile);
        }
        return JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
    }
}

