/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.injection;

import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.injection.KotlinPatternBasesKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b'\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006J\u001f\u0010\t\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\"\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006J%\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\"\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0006H&\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/base/injection/KotlinFunctionPatternBase;", "Lcom/intellij/patterns/PsiElementPattern;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "()V", "definedInClass", "fqName", "", "definedInPackage", "packageFqName", "withParameters", "parameterTypes", "", "([Ljava/lang/String;)Lorg/jetbrains/kotlin/idea/base/injection/KotlinFunctionPatternBase;", "withReceiver", "receiverFqName", "matchParameters", "", "(Lorg/jetbrains/kotlin/psi/KtFunction;[Ljava/lang/String;)Z", "matchReceiver", "DefinedInClassCondition", "kotlin.base.injection"})
@ApiStatus.Internal
public abstract class KotlinFunctionPatternBase
extends PsiElementPattern<KtFunction, KotlinFunctionPatternBase> {
    public KotlinFunctionPatternBase() {
        super(KtFunction.class);
    }

    public abstract boolean matchParameters(@NotNull KtFunction var1, String ... var2);

    public abstract boolean matchReceiver(@NotNull KtFunction var1, @NotNull String var2);

    @NotNull
    public final KotlinFunctionPatternBase withParameters(String ... parameterTypes2) {
        Intrinsics.checkNotNullParameter((Object)parameterTypes2, (String)"parameterTypes");
        return (KotlinFunctionPatternBase)KotlinPatternBasesKt.access$withPatternCondition(this, "kotlinFunctionPattern-withParameters", (Function2)new Function2<KtFunction, ProcessingContext, Boolean>(parameterTypes2, this){
            final /* synthetic */ String[] $parameterTypes;
            final /* synthetic */ KotlinFunctionPatternBase this$0;
            {
                this.$parameterTypes = $parameterTypes;
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction function2, @Nullable ProcessingContext processingContext) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (function2.getValueParameters().size() != this.$parameterTypes.length) {
                    return false;
                }
                return this.this$0.matchParameters(function2, Arrays.copyOf(this.$parameterTypes, this.$parameterTypes.length));
            }
        });
    }

    @NotNull
    public final KotlinFunctionPatternBase withReceiver(@NotNull String receiverFqName) {
        Intrinsics.checkNotNullParameter((Object)receiverFqName, (String)"receiverFqName");
        return (KotlinFunctionPatternBase)KotlinPatternBasesKt.access$withPatternCondition(this, "kotlinFunctionPattern-withReceiver", (Function2)new Function2<KtFunction, ProcessingContext, Boolean>(receiverFqName, this){
            final /* synthetic */ String $receiverFqName;
            final /* synthetic */ KotlinFunctionPatternBase this$0;
            {
                this.$receiverFqName = $receiverFqName;
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction function2, @Nullable ProcessingContext processingContext) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (function2.getReceiverTypeReference() == null) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)this.$receiverFqName, (Object)"?")) {
                    return true;
                }
                return this.this$0.matchReceiver(function2, this.$receiverFqName);
            }
        });
    }

    @NotNull
    public final KotlinFunctionPatternBase definedInClass(@NotNull String fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        ObjectPattern objectPattern = this.with(new DefinedInClassCondition(fqName2));
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (KotlinFunctionPatternBase)objectPattern;
    }

    @NotNull
    public final KotlinFunctionPatternBase definedInPackage(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return (KotlinFunctionPatternBase)KotlinPatternBasesKt.access$withPatternCondition(this, "kotlinFunctionPattern-definedInPackage", (Function2)new Function2<KtFunction, ProcessingContext, Boolean>(packageFqName){
            final /* synthetic */ String $packageFqName;
            {
                this.$packageFqName = $packageFqName;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction function2, @Nullable ProcessingContext processingContext) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (!(function2.getParent() instanceof KtFile)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)function2.getContainingKtFile().getPackageFqName().asString(), (Object)this.$packageFqName);
            }
        });
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/base/injection/KotlinFunctionPatternBase$DefinedInClassCondition;", "Lcom/intellij/patterns/PatternCondition;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "fqName", "", "(Ljava/lang/String;)V", "getFqName", "()Ljava/lang/String;", "accepts", "", "element", "context", "Lcom/intellij/util/ProcessingContext;", "kotlin.base.injection"})
    public static final class DefinedInClassCondition
    extends PatternCondition<KtFunction> {
        @NotNull
        private final String fqName;

        public DefinedInClassCondition(@NotNull String fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            super("kotlinFunctionPattern-definedInClass");
            this.fqName = fqName2;
        }

        @NotNull
        public final String getFqName() {
            return this.fqName;
        }

        public boolean accepts(@NotNull KtFunction element3, @Nullable ProcessingContext context2) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (element3.getParent() instanceof KtFile) {
                return false;
            }
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element3));
            return Intrinsics.areEqual((Object)(ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null), (Object)this.fqName);
        }
    }
}

