/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.CheckResult;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/PackageNameInspectionLocal;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "parentInspection", "Lcom/intellij/codeInspection/InspectionProfileEntry;", "namingSettings", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;", "(Lcom/intellij/codeInspection/InspectionProfileEntry;Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;)V", "getNamingSettings", "()Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;", "getParentInspection", "()Lcom/intellij/codeInspection/InspectionProfileEntry;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDisplayName", "", "getShortName", "RenamePackageFix", "kotlin.code-insight.inspections-shared"})
final class PackageNameInspectionLocal
extends AbstractKotlinInspection {
    @NotNull
    private final InspectionProfileEntry parentInspection;
    @NotNull
    private final NamingConventionInspectionSettings namingSettings;

    public PackageNameInspectionLocal(@NotNull InspectionProfileEntry parentInspection, @NotNull NamingConventionInspectionSettings namingSettings2) {
        Intrinsics.checkNotNullParameter((Object)parentInspection, (String)"parentInspection");
        Intrinsics.checkNotNullParameter((Object)namingSettings2, (String)"namingSettings");
        this.parentInspection = parentInspection;
        this.namingSettings = namingSettings2;
    }

    @NotNull
    public final InspectionProfileEntry getParentInspection() {
        return this.parentInspection;
    }

    @NotNull
    public final NamingConventionInspectionSettings getNamingSettings() {
        return this.namingSettings;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.packageDirectiveVisitor((Function1)((Function1)new Function1<KtPackageDirective, Unit>(this, holder){
            final /* synthetic */ PackageNameInspectionLocal this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtPackageDirective directive) {
                Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                KtExpression ktExpression = directive.getPackageNameExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression packageNameExpression = ktExpression;
                CheckResult checkResult = NamingConventionInspectionsKt.access$checkPackageDirective(directive, this.this$0.getNamingSettings());
                if (checkResult == null) {
                    return;
                }
                CheckResult checkResult2 = checkResult;
                String descriptionTemplate = checkResult2.toProblemTemplateString();
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RenamePackageFix()};
                this.$holder.registerProblem((PsiElement)packageNameExpression, descriptionTemplate, localQuickFixArray);
            }
        }));
    }

    @NotNull
    public String getShortName() {
        String string = this.parentInspection.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.parentInspection.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/PackageNameInspectionLocal$RenamePackageFix;", "Lorg/jetbrains/kotlin/idea/quickfix/RenameIdentifierFix;", "()V", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "element", "kotlin.code-insight.inspections-shared"})
    private static final class RenamePackageFix
    extends RenameIdentifierFix {
        @Override
        @Nullable
        protected PsiElement getElementToRename(@NotNull PsiElement element3) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            KtPackageDirective ktPackageDirective = element3 instanceof KtPackageDirective ? (KtPackageDirective)element3 : null;
            if (ktPackageDirective == null) {
                return null;
            }
            KtPackageDirective packageDirective = ktPackageDirective;
            return (PsiElement)JavaPsiFacade.getInstance((Project)((KtPackageDirective)element3).getProject()).findPackage(packageDirective.getQualifiedName());
        }
    }
}

