/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\f\u0010\u0015\u001a\u00020\f*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveEmptyClassBodyInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "addSemicolonIfNeeded", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "applyTo", "project", "Lcom/intellij/openapi/project/Project;", "inspectionText", "isApplicable", "", "addSemicolon", "kotlin.code-insight.inspections-shared"})
@SourceDebugExtension(value={"SMAP\nRemoveEmptyClassBodyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveEmptyClassBodyInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveEmptyClassBodyInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,86:1\n2298#2,5:87\n179#3,2:92\n179#3,2:94\n142#4:96\n142#4:97\n*S KotlinDebug\n*F\n+ 1 RemoveEmptyClassBodyInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveEmptyClassBodyInspection\n*L\n49#1:87,5\n55#1:92,2\n56#1:94,2\n76#1:96\n80#1:97\n*E\n"})
public final class RemoveEmptyClassBodyInspection
extends AbstractApplicabilityBasedInspection<KtClassBody>
implements CleanupLocalInspectionTool {
    public RemoveEmptyClassBodyInspection() {
        super(KtClassBody.class);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtClassBody element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("redundant.empty.class.body", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("remove.redundant.empty.class.body", new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtClassBody element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiElement parent2 = element3.getParent();
        element3.delete();
        Intrinsics.checkNotNull((Object)parent2);
        this.addSemicolonIfNeeded(parent2, editor2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addSemicolonIfNeeded(PsiElement element3, Editor editor2) {
        block22: {
            PsiElement psiElement2 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)element3, (boolean)false, (int)1, null);
            if (psiElement2 == null) {
                return;
            }
            PsiElement next2 = psiElement2;
            if (Intrinsics.areEqual((Object)next2.getNode().getElementType(), (Object)KtTokens.SEMICOLON)) {
                return;
            }
            PsiElement psiElement3 = element3;
            if (psiElement3 instanceof KtObjectDeclaration) {
                if (!((KtObjectDeclaration)element3).isCompanion() || ((KtObjectDeclaration)element3).getNameIdentifier() != null) {
                    return;
                }
                PsiElement psiElement4 = next2.getFirstChild();
                Object object = psiElement4 != null ? psiElement4.getNode() : null;
                if (object == null) {
                    return;
                }
                ASTNode firstChildNode = object;
                if (KtTokens.KEYWORDS.contains(firstChildNode.getElementType())) {
                    return;
                }
            } else if (psiElement3 instanceof KtEnumEntry) {
                Object v4;
                PsiElement psiElement5;
                boolean isLastChild;
                block19: {
                    void $this$lastOrNull$iv;
                    Object[] objectArray = ((KtEnumEntry)element3).getParent().getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
                    Object[] children2 = objectArray;
                    isLastChild = Intrinsics.areEqual((Object)element3, (Object)ArraysKt.lastOrNull((Object[])children2));
                    Object[] objectArray2 = children2;
                    psiElement5 = element3;
                    boolean $i$f$lastOrNull = false;
                    int n = ((void)$this$lastOrNull$iv).length + -1;
                    if (0 <= n) {
                        do {
                            void element$iv;
                            int index$iv = n--;
                            void it = element$iv = $this$lastOrNull$iv[index$iv];
                            boolean bl = false;
                            if (!(it instanceof KtEnumEntry)) continue;
                            v4 = element$iv;
                            break block19;
                        } while (0 <= n);
                    }
                    v4 = null;
                }
                boolean isLastEnumEntry = Intrinsics.areEqual((Object)psiElement5, v4);
                if (isLastChild || !isLastEnumEntry) {
                    return;
                }
            } else if (psiElement3 instanceof KtClass) {
                Object v7;
                block21: {
                    Object v5;
                    PsiElement it;
                    boolean $i$f$firstOrNull;
                    Sequence $this$firstOrNull$iv;
                    block20: {
                        if (!((KtClass)element3).isLocal()) {
                            return;
                        }
                        $this$firstOrNull$iv = PsiTreeUtilKt.getNextLeafs((PsiElement)element3);
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (PsiElement)element$iv;
                            boolean bl = false;
                            if (!(!(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment))) continue;
                            v5 = element$iv;
                            break block20;
                        }
                        v5 = null;
                    }
                    PsiElement psiElement6 = v5;
                    if (!Intrinsics.areEqual((Object)(psiElement6 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement6) : null), (Object)KtTokens.LPAR)) {
                        return;
                    }
                    $this$firstOrNull$iv = PsiTreeUtilKt.getPrevLeafs((PsiElement)next2);
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(!(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment))) continue;
                        v7 = element$iv;
                        break block21;
                    }
                    v7 = null;
                }
                PsiElement psiElement7 = v7;
                if (Intrinsics.areEqual((Object)(psiElement7 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement7) : null), (Object)KtTokens.RPAR)) {
                    return;
                }
            } else {
                return;
            }
            PsiElement semicolon = this.addSemicolon(element3);
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block22;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)semicolon));
        }
    }

    private final PsiElement addSemicolon(PsiElement $this$addSemicolon) {
        PsiElement psiElement2;
        Project project2 = $this$addSemicolon.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        PsiElement semicolon = new KtPsiFactory(project2, false, 2, null).createSemicolon();
        if ($this$addSemicolon instanceof KtEnumEntry) {
            PsiElement psiElement3 = $this$addSemicolon.add(semicolon);
            Intrinsics.checkNotNull((Object)psiElement3);
            psiElement2 = psiElement3;
        } else {
            PsiElement psiElement4 = $this$addSemicolon.getParent().addAfter(semicolon, $this$addSemicolon);
            Intrinsics.checkNotNull((Object)psiElement4);
            psiElement2 = psiElement4;
        }
        return psiElement2;
    }

    @Override
    public boolean isApplicable(@NotNull KtClassBody element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getStrictParentOfType = false;
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtObjectDeclaration.class, (boolean)true);
        if (ktObjectDeclaration != null) {
            KtObjectDeclaration it = ktObjectDeclaration;
            boolean bl = false;
            if (it.isObjectLiteral()) {
                return false;
            }
        }
        $this$getStrictParentOfType$iv = (PsiElement)element3;
        $i$f$getStrictParentOfType = false;
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
        if (ktClass2 != null) {
            KtClass it = ktClass2;
            boolean bl = false;
            if (!it.isTopLevel() && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)it), (boolean)false, (int)1, null) instanceof KtSecondaryConstructor) {
                return false;
            }
        }
        String string = element3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"{", (String)"", (boolean)false, (int)4, null), (String)"}", (String)"", (boolean)false, (int)4, null));
    }
}

