/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.RemoveBracesIntention;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "skipProcessingFurtherElementsAfter", "Lcom/intellij/psi/PsiElement;", "findChildBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Holder", "kotlin.code-insight.intentions-shared"})
public final class RemoveBracesIntention
extends SelfTargetingIntention<KtElement> {
    public RemoveBracesIntention() {
        super(KtElement.class, KotlinBundle.lazyMessage("remove.braces", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element3);
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression block2 = ktBlockExpression;
        if (!Holder.INSTANCE.isApplicableTo(block2)) {
            return false;
        }
        PsiElement container2 = block2.getParent();
        if (container2 instanceof KtContainerNode) {
            String string = KotlinPsiUtilsKt.getControlFlowElementDescription((KtContainerNode)container2);
            if (string == null) {
                return false;
            }
            String description2 = string;
            Object[] objectArray = new Object[]{description2};
            this.setTextGetter(KotlinBundle.lazyMessage("remove.braces.from.0.statement", objectArray));
        } else if (container2 instanceof KtWhenEntry) {
            this.setTextGetter(KotlinBundle.lazyMessage("remove.braces.from.when.entry", new Object[0]));
        }
        return true;
    }

    @Override
    public void applyTo(@NotNull KtElement element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element3);
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression block2 = ktBlockExpression;
        Holder.INSTANCE.removeBraces(element3, block2, editor2);
    }

    @Override
    protected boolean skipProcessingFurtherElementsAfter(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtBlockExpression && !(((KtBlockExpression)element3).getParent() instanceof KtWhenEntry);
    }

    private final KtBlockExpression findChildBlock(KtElement $this$findChildBlock) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtElement ktElement = $this$findChildBlock;
        Object object = ktElement instanceof KtBlockExpression ? (KtBlockExpression)$this$findChildBlock : (ktElement instanceof KtLoopExpression ? ((ktExpression2 = ((KtLoopExpression)$this$findChildBlock).getBody()) instanceof KtBlockExpression ? (KtBlockExpression)ktExpression2 : null) : (ktElement instanceof KtWhenEntry ? ((ktExpression = ((KtWhenEntry)$this$findChildBlock).getExpression()) instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null) : null));
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001c\u0010\u0012\u001a\u00020\b*\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention$Holder;", "", "()V", "isApplicableTo", "", "block", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "removeBraces", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "comments", "", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "forward", "handleComments", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "hasLineBreak", "kotlin.code-insight.intentions-shared"})
    @SourceDebugExtension(value={"SMAP\nRemoveBracesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveBracesIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention$Holder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n731#2,9:130\n1747#2,3:139\n1747#2,3:142\n*S KotlinDebug\n*F\n+ 1 RemoveBracesIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention$Holder\n*L\n105#1:130,9\n122#1:139,3\n126#1:142,3\n*E\n"})
    public static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();

        private Holder() {
        }

        public final boolean isApplicableTo(@NotNull KtBlockExpression block2) {
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
            List list2 = block2.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
            if (ktExpression == null) {
                return false;
            }
            KtExpression singleStatement = ktExpression;
            if (singleStatement instanceof KtLambdaExpression && ((KtLambdaExpression)singleStatement).getFunctionLiteral().getArrow() == null) {
                return false;
            }
            PsiElement container2 = block2.getParent();
            if (container2 instanceof KtContainerNode) {
                if (singleStatement instanceof KtProperty || singleStatement instanceof KtClass) {
                    return false;
                }
                if (singleStatement instanceof KtIfExpression) {
                    KtExpression elseExpression;
                    PsiElement psiElement2 = ((KtContainerNode)container2).getParent();
                    KtIfExpression ktIfExpression = psiElement2 instanceof KtIfExpression ? (KtIfExpression)psiElement2 : null;
                    Object object = elseExpression = ktIfExpression != null ? ktIfExpression.getElse() : null;
                    if (elseExpression != null && !Intrinsics.areEqual((Object)elseExpression, (Object)block2)) {
                        return false;
                    }
                }
                return true;
            }
            if (container2 instanceof KtWhenEntry) {
                return !(singleStatement instanceof KtNamedDeclaration);
            }
            return false;
        }

        public final void removeBraces(@NotNull KtElement element3, @NotNull KtBlockExpression block2, @Nullable Editor editor2) {
            block11: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
                Project project2 = element3.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
                List list2 = block2.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                KtExpression statement2 = (KtExpression)CollectionsKt.single((List)list2);
                Editor editor3 = editor2;
                if (editor3 != null) {
                    int n = editor3.getCaretModel().getOffset();
                    Intrinsics.checkNotNull((Object)statement2);
                    bl = n >= PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)statement2));
                } else {
                    bl = false;
                }
                boolean caretOnAfterStatement = bl;
                PsiElement container2 = block2.getParent();
                PsiElement psiElement2 = container2.getParent();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                KtExpression construct = (KtExpression)psiElement2;
                Intrinsics.checkNotNull((Object)statement2);
                this.handleComments(statement2, block2, factory2);
                PsiElement newElement2 = block2.replace(statement2.copy());
                Editor editor4 = editor2;
                if (editor4 != null && (editor4 = editor4.getCaretModel()) != null) {
                    int n;
                    if (caretOnAfterStatement) {
                        Intrinsics.checkNotNull((Object)newElement2);
                        n = PsiUtilsKt.getEndOffset((PsiElement)newElement2);
                    } else {
                        Intrinsics.checkNotNull((Object)newElement2);
                        n = PsiUtilsKt.getStartOffset((PsiElement)newElement2);
                    }
                    editor4.moveToOffset(n);
                }
                if (construct instanceof KtDoWhileExpression) {
                    PsiElement psiElement3 = newElement2.getParent();
                    Intrinsics.checkNotNull((Object)psiElement3);
                    psiElement3.addAfter(factory2.createNewLine(), newElement2);
                } else if (editor2 != null) {
                    Document document = editor2.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                    Document document2 = document;
                    Intrinsics.checkNotNull((Object)newElement2);
                    int line = document2.getLineNumber(PsiUtilsKt.getStartOffset((PsiElement)newElement2));
                    int rightMargin = editor2.getSettings().getRightMargin(editor2.getProject());
                    if (document2.getLineEndOffset(line) - document2.getLineStartOffset(line) >= rightMargin) {
                        newElement2.getParent().addBefore(factory2.createNewLine(), newElement2);
                    }
                }
                if (!(construct instanceof KtIfExpression) || !Intrinsics.areEqual((Object)container2.getNode().getElementType(), (Object)KtNodeTypes.ELSE) || !(((KtIfExpression)construct).getParent() instanceof KtExpression) || ((KtIfExpression)construct).getParent() instanceof KtStatementExpression) break block11;
                Object[] objectArray = new Object[]{construct};
                PsiElement replaced2 = ((KtIfExpression)construct).replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"($0)", (Object[])objectArray, (boolean)false, (int)4, null));
                PsiElement psiElement4 = replaced2.getChildren()[0];
                KtIfExpression ktIfExpression = psiElement4 instanceof KtIfExpression ? (KtIfExpression)psiElement4 : null;
                if (ktIfExpression != null && (ktIfExpression = ktIfExpression.getElse()) != null) {
                    KtIfExpression it = ktIfExpression;
                    boolean bl2 = false;
                    Editor editor5 = editor2;
                    if (editor5 != null && (editor5 = editor5.getCaretModel()) != null) {
                        editor5.moveToOffset(caretOnAfterStatement ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)) : PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)));
                    }
                }
            }
        }

        public static /* synthetic */ void removeBraces$default(Holder holder, KtElement ktElement, KtBlockExpression ktBlockExpression, Editor editor2, int n, Object object) {
            if ((n & 4) != 0) {
                editor2 = null;
            }
            holder.removeBraces(ktElement, ktBlockExpression, editor2);
        }

        private final void handleComments(KtExpression $this$handleComments, KtBlockExpression block2, KtPsiFactory factory2) {
            Collection collection;
            List list2;
            List<PsiElement> $this$dropLastWhile$iv = this.comments($this$handleComments, true);
            boolean $i$f$dropLastWhile22 = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<PsiElement> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    PsiElement it = iterator$iv.previous();
                    boolean bl = false;
                    if (it instanceof PsiWhiteSpace) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List nextComments2 = list2;
            Collection $i$f$dropLastWhile22 = CollectionsKt.reversed((Iterable)this.comments($this$handleComments, false));
            if ($i$f$dropLastWhile22.isEmpty()) {
                boolean bl = false;
                collection = INSTANCE.hasLineBreak(nextComments2) ? CollectionsKt.listOf((Object)factory2.createNewLine()) : CollectionsKt.emptyList();
            } else {
                collection = $i$f$dropLastWhile22;
            }
            List prevComments2 = (List)collection;
            PsiElement blockParent = block2.getParent();
            if (!((Collection)prevComments2).isEmpty()) {
                blockParent.addRangeBefore((PsiElement)CollectionsKt.first((List)prevComments2), (PsiElement)CollectionsKt.last((List)prevComments2), (PsiElement)block2);
            }
            if (!((Collection)nextComments2).isEmpty()) {
                blockParent.addRangeAfter((PsiElement)CollectionsKt.first((List)nextComments2), (PsiElement)CollectionsKt.last((List)nextComments2), (PsiElement)block2);
            }
        }

        private final List<PsiElement> comments(KtExpression $this$comments, boolean forward) {
            boolean bl;
            List elements2;
            block3: {
                elements2 = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)$this$comments), (boolean)forward, (boolean)false), (Function1)comments.elements.1.INSTANCE));
                Iterable $this$any$iv = elements2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof PsiComment)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl ? elements2 : CollectionsKt.emptyList();
        }

        private final boolean hasLineBreak(List<? extends PsiElement> $this$hasLineBreak) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = $this$hasLineBreak;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

