/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinComponentUnwrapper;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinRemover;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTryExpression;

public class KotlinUnwrappers {
    private KotlinUnwrappers() {
    }

    public static class KotlinFinallyRemover
    extends KotlinRemover {
        public KotlinFinallyRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtFinallySection;
        }
    }

    public static class KotlinFinallyUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinFinallyUnwrapper(String key) {
            super(key);
        }

        @Override
        public boolean isApplicableTo(PsiElement e) {
            return super.isApplicableTo(e) && this.getEnclosingElement((KtElement)e).getParent() instanceof KtBlockExpression;
        }

        @Override
        @NotNull
        protected KtElement getEnclosingElement(@NotNull KtElement element3) {
            if (element3 == null) {
                KotlinFinallyUnwrapper.$$$reportNull$$$0(0);
            }
            KtElement ktElement = (KtElement)element3.getParent();
            if (ktElement == null) {
                KotlinFinallyUnwrapper.$$$reportNull$$$0(1);
            }
            return ktElement;
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            if (target2 == null) {
                KotlinFinallyUnwrapper.$$$reportNull$$$0(2);
            }
            return target2 instanceof KtFinallySection ? ((KtFinallySection)target2).getFinalExpression() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinFinallyUnwrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinFinallyUnwrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnclosingElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getEnclosingElement";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpressionToUnwrap";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class KotlinCatchRemover
    extends KotlinRemover {
        public KotlinCatchRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtCatchClause;
        }
    }

    public static class KotlinCatchUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinCatchUnwrapper(String key) {
            super(key);
        }

        @Override
        @NotNull
        protected KtElement getEnclosingElement(@NotNull KtElement element3) {
            if (element3 == null) {
                KotlinCatchUnwrapper.$$$reportNull$$$0(0);
            }
            KtElement ktElement = (KtElement)element3.getParent();
            if (ktElement == null) {
                KotlinCatchUnwrapper.$$$reportNull$$$0(1);
            }
            return ktElement;
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            if (target2 == null) {
                KotlinCatchUnwrapper.$$$reportNull$$$0(2);
            }
            return target2 instanceof KtCatchClause ? ((KtCatchClause)target2).getCatchBody() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinCatchUnwrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinCatchUnwrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnclosingElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getEnclosingElement";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpressionToUnwrap";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class KotlinTryUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinTryUnwrapper(String key) {
            super(key);
        }

        @Override
        @Nullable
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            if (target2 == null) {
                KotlinTryUnwrapper.$$$reportNull$$$0(0);
            }
            return target2 instanceof KtTryExpression ? ((KtTryExpression)target2).getTryBlock() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinTryUnwrapper", "getExpressionToUnwrap"));
        }
    }

    public static class KotlinLoopUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinLoopUnwrapper(String key) {
            super(key);
        }

        @Override
        @Nullable
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            if (target2 == null) {
                KotlinLoopUnwrapper.$$$reportNull$$$0(0);
            }
            return target2 instanceof KtLoopExpression ? ((KtLoopExpression)target2).getBody() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinLoopUnwrapper", "getExpressionToUnwrap"));
        }
    }

    public static class KotlinElseRemover
    extends KotlinUnwrapRemoveBase {
        public KotlinElseRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtIfExpression && ((KtIfExpression)e).getCondition() != null && ((KtIfExpression)e).getThen() != null && ((KtIfExpression)e).getElse() != null;
        }

        protected void doUnwrap(PsiElement element3, KotlinUnwrapRemoveBase.Context context2) throws IncorrectOperationException {
            KtIfExpression ifExpr = (KtIfExpression)element3;
            context2.replace((KtElement)ifExpr, (KtElement)new KtPsiFactory(ifExpr.getProject()).createIf(ifExpr.getCondition(), ifExpr.getThen(), null));
        }
    }

    public static class KotlinThenUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinThenUnwrapper(String key) {
            super(key);
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            if (target2 == null) {
                KotlinThenUnwrapper.$$$reportNull$$$0(0);
            }
            return target2 instanceof KtIfExpression ? ((KtIfExpression)target2).getThen() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinThenUnwrapper", "getExpressionToUnwrap"));
        }
    }

    public static class KotlinElseUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinElseUnwrapper(String key) {
            super(key);
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            if (target2 == null) {
                KotlinElseUnwrapper.$$$reportNull$$$0(0);
            }
            return target2 instanceof KtIfExpression ? ((KtIfExpression)target2).getElse() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinElseUnwrapper", "getExpressionToUnwrap"));
        }
    }

    public static class KotlinExpressionRemover
    extends KotlinRemover {
        public KotlinExpressionRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtExpression && e.getParent() instanceof KtBlockExpression;
        }
    }
}

