/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FsRoot;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00000\u0001:\u000234BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0000J\u0011\u0010-\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010.\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010/H\u0096\u0002J\b\u00100\u001a\u00020*H\u0016J\b\u00101\u001a\u00020\u0003H\u0016J\u0006\u00102\u001a\u00020\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0015\u0010\n\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "", "rawVersion", "", "kotlinVersion", "Lkotlin/KotlinVersion;", "kind", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "requireBuildNumberForArtifact", "", "buildNumber", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "(Ljava/lang/String;Lkotlin/KotlinVersion;Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;ZLjava/lang/String;Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;)V", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "artifactVersion", "getArtifactVersion", "()Ljava/lang/String;", "baseVersion", "getBaseVersion", "getBuildNumber", "isDev", "()Z", "isPreRelease", "isRelease", "isSnapshot", "isStandaloneCompilerVersion", "getKind", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "getKotlinVersion", "()Lkotlin/KotlinVersion;", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getRawVersion", "compare", "", "otherRawVersion", "other", "compareTo", "equals", "", "hashCode", "toString", "withoutBuildNumber", "Companion", "Kind", "kotlin.base.plugin"})
public final class IdeKotlinVersion
implements Comparable<IdeKotlinVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rawVersion;
    @NotNull
    private final KotlinVersion kotlinVersion;
    @NotNull
    private final Kind kind;
    private final boolean requireBuildNumberForArtifact;
    @Nullable
    private final String buildNumber;
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    @NotNull
    private static final Regex KOTLIN_COMPILER_VERSION_PATTERN = new Regex("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-([A-Za-z]\\w+(?:-release)?))?(?:-(\\d+)?)?$", RegexOption.IGNORE_CASE);

    private IdeKotlinVersion(String rawVersion, KotlinVersion kotlinVersion2, Kind kind2, boolean requireBuildNumberForArtifact, String buildNumber, LanguageVersion languageVersion, ApiVersion apiVersion2) {
        this.rawVersion = rawVersion;
        this.kotlinVersion = kotlinVersion2;
        this.kind = kind2;
        this.requireBuildNumberForArtifact = requireBuildNumberForArtifact;
        this.buildNumber = buildNumber;
        this.languageVersion = languageVersion;
        this.apiVersion = apiVersion2;
    }

    @NlsSafe
    @NotNull
    public final String getRawVersion() {
        return this.rawVersion;
    }

    @NotNull
    public final KotlinVersion getKotlinVersion() {
        return this.kotlinVersion;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NlsSafe
    @Nullable
    public final String getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public final LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public final boolean isStandaloneCompilerVersion() {
        KotlinPluginLayout.getInstance();
        return Intrinsics.areEqual((Object)this, (Object)KotlinPluginLayout.getStandaloneCompilerVersion());
    }

    @NotNull
    public final String getBaseVersion() {
        return this.kotlinVersion.toString();
    }

    @NotNull
    public final String getArtifactVersion() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_artifactVersion__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_artifactVersion__u24lambda_u240.append(this.getBaseVersion());
        if (this.kind.getArtifactSuffix() != null) {
            $this$_get_artifactVersion__u24lambda_u240.append('-').append(this.kind.getArtifactSuffix());
        }
        if (this.requireBuildNumberForArtifact && this.buildNumber != null) {
            $this$_get_artifactVersion__u24lambda_u240.append('-').append(this.buildNumber);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean isRelease() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Release.INSTANCE);
    }

    public final boolean isPreRelease() {
        return !this.isRelease();
    }

    public final boolean isDev() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Dev.INSTANCE);
    }

    public final boolean isSnapshot() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Snapshot.INSTANCE);
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return (LanguageVersionSettings)new LanguageVersionSettingsImpl(this.languageVersion, this.apiVersion, null, null, 12, null);
    }

    @NotNull
    public final IdeKotlinVersion withoutBuildNumber() {
        Object object;
        return this.buildNumber != null ? (IdeKotlinVersion)(Result.isFailure-impl((Object)(object = Companion.parse-IoAF18A(StringsKt.substringBeforeLast$default((String)this.rawVersion, (char)'-', null, (int)2, null)))) ? this : object) : this;
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        IdeKotlinVersion ideKotlinVersion = other2 instanceof IdeKotlinVersion ? (IdeKotlinVersion)other2 : null;
        if (ideKotlinVersion == null) {
            return false;
        }
        IdeKotlinVersion otherVersion = ideKotlinVersion;
        return Intrinsics.areEqual((Object)this.rawVersion, (Object)otherVersion.rawVersion);
    }

    public int hashCode() {
        return this.rawVersion.hashCode();
    }

    @NotNull
    public String toString() {
        return this.rawVersion;
    }

    @Override
    public int compareTo(@NotNull IdeKotlinVersion other2) {
        Intrinsics.checkNotNullParameter((Object)other2, (String)"other");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)other2.rawVersion);
    }

    public final int compare(@NotNull String otherRawVersion) {
        Intrinsics.checkNotNullParameter((Object)otherRawVersion, (String)"otherRawVersion");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)otherRawVersion);
    }

    public final int compare(@NotNull IdeKotlinVersion other2) {
        Intrinsics.checkNotNullParameter((Object)other2, (String)"other");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)other2.rawVersion);
    }

    @JvmStatic
    @NotNull
    public static final IdeKotlinVersion get(@NlsSafe @NotNull String rawVersion) {
        return Companion.get(rawVersion);
    }

    @JvmStatic
    @Nullable
    public static final IdeKotlinVersion opt(@NlsSafe @NotNull String rawVersion) {
        return Companion.opt(rawVersion);
    }

    @JvmStatic
    @NotNull
    public static final IdeKotlinVersion fromKotlinVersion(@NotNull KotlinVersion version2) {
        return Companion.fromKotlinVersion(version2);
    }

    @JvmStatic
    @NotNull
    public static final IdeKotlinVersion fromLanguageVersion(@NotNull LanguageVersion languageVersion) {
        return Companion.fromLanguageVersion(languageVersion);
    }

    @JvmStatic
    @Nullable
    public static final IdeKotlinVersion fromManifest(@NotNull VirtualFile jarFile) {
        return Companion.fromManifest(jarFile);
    }

    public /* synthetic */ IdeKotlinVersion(String rawVersion, KotlinVersion kotlinVersion2, Kind kind2, boolean requireBuildNumberForArtifact, String buildNumber, LanguageVersion languageVersion, ApiVersion apiVersion2, DefaultConstructorMarker $constructor_marker) {
        this(rawVersion, kotlinVersion2, kind2, requireBuildNumberForArtifact, buildNumber, languageVersion, apiVersion2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J.\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00180\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Companion;", "", "()V", "KOTLIN_COMPILER_VERSION_PATTERN", "Lkotlin/text/Regex;", "fromKotlinVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "version", "Lkotlin/KotlinVersion;", "fromLanguageVersion", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "fromManifest", "jarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "get", "rawVersion", "", "opt", "parse", "Lkotlin/Result;", "parse-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "parseKind", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "kindSuffix", "prefix", "factory", "Lkotlin/Function1;", "", "kotlin.base.plugin"})
    @SourceDebugExtension(value={"SMAP\nIdeKotlinVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinVersion.kt\norg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1109#2,2:217\n1282#2,2:220\n1#3:219\n*S KotlinDebug\n*F\n+ 1 IdeKotlinVersion.kt\norg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Companion\n*L\n50#1:217,2\n131#1:220,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IdeKotlinVersion get(@NlsSafe @NotNull String rawVersion) {
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            Object object = this.parse-IoAF18A(rawVersion);
            ResultKt.throwOnFailure((Object)object);
            return (IdeKotlinVersion)object;
        }

        @JvmStatic
        @Nullable
        public final IdeKotlinVersion opt(@NlsSafe @NotNull String rawVersion) {
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            Object object = this.parse-IoAF18A(rawVersion);
            return (IdeKotlinVersion)(Result.isFailure-impl((Object)object) ? null : object);
        }

        @JvmStatic
        @NotNull
        public final IdeKotlinVersion fromKotlinVersion(@NotNull KotlinVersion version2) {
            LanguageVersion element$iv;
            block2: {
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                LanguageVersion[] $this$first$iv = LanguageVersion.values();
                boolean $i$f$first = false;
                int n = $this$first$iv.length;
                for (int j = 0; j < n; ++j) {
                    LanguageVersion it = element$iv = $this$first$iv[j];
                    boolean bl = false;
                    if (!(it.getMajor() == version2.getMajor() && it.getMinor() == version2.getMinor())) {
                        continue;
                    }
                    break block2;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            LanguageVersion languageVersion = element$iv;
            return new IdeKotlinVersion(version2.toString(), version2, Kind.Release.INSTANCE, false, null, languageVersion, ApiVersion.Companion.createByLanguageVersion(languageVersion), null);
        }

        @JvmStatic
        @NotNull
        public final IdeKotlinVersion fromLanguageVersion(@NotNull LanguageVersion languageVersion) {
            Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
            return new IdeKotlinVersion(languageVersion.getMajor() + "." + languageVersion.getMinor() + ".0", new KotlinVersion(languageVersion.getMajor(), languageVersion.getMinor(), 0), Kind.Release.INSTANCE, false, null, languageVersion, ApiVersion.Companion.createByLanguageVersion(languageVersion), null);
        }

        @JvmStatic
        @Nullable
        public final IdeKotlinVersion fromManifest(@NotNull VirtualFile jarFile) {
            VirtualFile virtualFile2;
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            if (jarFile instanceof FsRoot) {
                virtualFile2 = jarFile;
            } else {
                virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
                if (virtualFile2 == null) {
                    return null;
                }
            }
            VirtualFile jarRoot = virtualFile2;
            String string = JarVersionDetectionUtil.getMainAttribute((VirtualFile)jarRoot, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
            if (string == null) {
                return null;
            }
            String unprocessedVersion = string;
            String rawVersion = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)unprocessedVersion, (char)'(', null, (int)2, null))).toString();
            return this.opt(rawVersion);
        }

        private final Kind parseKind(String kindSuffix, String prefix2, Function1<? super Integer, ? extends Kind> factory2) {
            if (!StringsKt.startsWith$default((String)kindSuffix, (String)prefix2, (boolean)false, (int)2, null)) {
                boolean $i$a$-check-IdeKotlinVersion$Companion$parseKind$22 = false;
                String $i$a$-check-IdeKotlinVersion$Companion$parseKind$22 = "Prefix \"" + prefix2 + "\" not found in kind suffix \"" + kindSuffix + "\"";
                throw new IllegalStateException($i$a$-check-IdeKotlinVersion$Companion$parseKind$22.toString());
            }
            String numberString = StringsKt.removeSuffix((String)StringsKt.drop((String)kindSuffix, (int)prefix2.length()), (CharSequence)"-release");
            if (((CharSequence)numberString).length() == 0) {
                return (Kind)factory2.invoke((Object)1);
            }
            Integer n = StringsKt.toIntOrNull((String)numberString);
            if (n == null) {
                return null;
            }
            int number = n;
            return (Kind)factory2.invoke((Object)number);
        }

        @NotNull
        public final Object parse-IoAF18A(@NotNull String rawVersion) {
            LanguageVersion languageVersion;
            LanguageVersion languageVersion2;
            boolean requireBuildNumberForArtifact;
            String buildNumber;
            Kind kind2;
            KotlinVersion kotlinVersion2;
            block7: {
                Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
                MatchResult matchResult2 = KOTLIN_COMPILER_VERSION_PATTERN.matchEntire((CharSequence)rawVersion);
                if (matchResult2 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Unsupported compiler version: " + rawVersion)));
                }
                MatchResult matchResult3 = matchResult2;
                Integer n = StringsKt.toIntOrNull((String)((String)matchResult3.getGroupValues().get(1)));
                if (n == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Invalid major version component: " + rawVersion)));
                }
                int majorValue = n;
                Integer n2 = StringsKt.toIntOrNull((String)((String)matchResult3.getGroupValues().get(2)));
                if (n2 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Invalid minor version component: " + rawVersion)));
                }
                int minorValue = n2;
                Integer n3 = StringsKt.toIntOrNull((String)((String)matchResult3.getGroupValues().get(3)));
                if (n3 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Invalid patch version component: " + rawVersion)));
                }
                int patchValue = n3;
                kotlinVersion2 = new KotlinVersion(majorValue, minorValue, patchValue);
                String kindSuffix = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)((String)matchResult3.getGroupValues().get(4)));
                Kind kind3 = Intrinsics.areEqual((Object)kindSuffix, (Object)"release") || Intrinsics.areEqual((Object)kindSuffix, (Object)"") ? (Kind)Kind.Release.INSTANCE : (Intrinsics.areEqual((Object)kindSuffix, (Object)"dev") ? (Kind)Kind.Dev.INSTANCE : (Intrinsics.areEqual((Object)kindSuffix, (Object)"snapshot") || Intrinsics.areEqual((Object)kindSuffix, (Object)"local") ? (Kind)Kind.Snapshot.INSTANCE : (StringsKt.startsWith$default((String)kindSuffix, (String)"rc", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "rc", (Function1<? super Integer, ? extends Kind>)((Function1)parse.kind.1.INSTANCE)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"beta", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "beta", (Function1<? super Integer, ? extends Kind>)((Function1)parse.kind.2.INSTANCE)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"m", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "m", (Function1<? super Integer, ? extends Kind>)((Function1)parse.kind.3.INSTANCE)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"eap", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "eap", (Function1<? super Integer, ? extends Kind>)((Function1)parse.kind.4.INSTANCE)) : null))))));
                if (kind3 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Unsupported version kind suffix: \"" + kindSuffix + "\" (" + rawVersion + ")")));
                }
                kind2 = kind3;
                Object e = matchResult3.getGroupValues().get(5);
                String it = (String)e;
                boolean bl = false;
                buildNumber = (String)(((CharSequence)it).length() > 0 ? e : null);
                requireBuildNumberForArtifact = !StringsKt.contains$default((CharSequence)kindSuffix, (CharSequence)"release", (boolean)false, (int)2, null) && buildNumber != null;
                LanguageVersion[] $this$firstOrNull$iv = LanguageVersion.values();
                boolean $i$f$firstOrNull = false;
                int n4 = $this$firstOrNull$iv.length;
                for (int j = 0; j < n4; ++j) {
                    LanguageVersion element$iv;
                    LanguageVersion it2 = element$iv = $this$firstOrNull$iv[j];
                    boolean bl2 = false;
                    if (!(it2.getMajor() == majorValue && it2.getMinor() == minorValue)) continue;
                    languageVersion2 = element$iv;
                    break block7;
                }
                languageVersion2 = languageVersion = null;
            }
            if (languageVersion2 == null) {
                languageVersion = LanguageVersion.FIRST_SUPPORTED;
            }
            LanguageVersion languageVersion3 = languageVersion;
            ApiVersion apiVersion2 = ApiVersion.Companion.createByLanguageVersion(languageVersion3);
            IdeKotlinVersion ideKotlinVersion = new IdeKotlinVersion(rawVersion, kotlinVersion2, kind2, requireBuildNumberForArtifact, buildNumber, languageVersion3, apiVersion2, null);
            return Result.constructor-impl((Object)ideKotlinVersion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\b\t\n\u000b\f\r\u000eB\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0007\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "", "artifactSuffix", "", "(Ljava/lang/String;)V", "getArtifactSuffix", "()Ljava/lang/String;", "toString", "Beta", "Dev", "Eap", "Milestone", "Release", "ReleaseCandidate", "Snapshot", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Beta;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Dev;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Eap;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Milestone;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Release;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ReleaseCandidate;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Snapshot;", "kotlin.base.plugin"})
    public static abstract class Kind {
        @Nullable
        private final String artifactSuffix;

        private Kind(String artifactSuffix) {
            this.artifactSuffix = artifactSuffix;
        }

        @Nullable
        public final String getArtifactSuffix() {
            return this.artifactSuffix;
        }

        @NotNull
        public String toString() {
            String string = this.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            return string;
        }

        public /* synthetic */ Kind(String artifactSuffix, DefaultConstructorMarker $constructor_marker) {
            this(artifactSuffix);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Beta;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "(I)V", "getNumber", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Beta
        extends Kind {
            private final int number;

            public Beta(int number) {
                super((String)(number == 1 ? "Beta" : "Beta" + number), null);
                this.number = number;
            }

            public final int getNumber() {
                return this.number;
            }

            public final int component1() {
                return this.number;
            }

            @NotNull
            public final Beta copy(int number) {
                return new Beta(number);
            }

            public static /* synthetic */ Beta copy$default(Beta beta, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = beta.number;
                }
                return beta.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Beta(number=" + this.number + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.number);
            }

            public boolean equals(@Nullable Object other2) {
                if (this == other2) {
                    return true;
                }
                if (!(other2 instanceof Beta)) {
                    return false;
                }
                Beta beta = (Beta)other2;
                return this.number == beta.number;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Dev;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "()V", "kotlin.base.plugin"})
        public static final class Dev
        extends Kind {
            @NotNull
            public static final Dev INSTANCE = new Dev();

            private Dev() {
                super("dev", null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Eap;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "(I)V", "getNumber", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Eap
        extends Kind {
            private final int number;

            public Eap(int number) {
                super((String)(number == 1 ? "eap" : "eap" + number), null);
                this.number = number;
            }

            public final int getNumber() {
                return this.number;
            }

            public final int component1() {
                return this.number;
            }

            @NotNull
            public final Eap copy(int number) {
                return new Eap(number);
            }

            public static /* synthetic */ Eap copy$default(Eap eap, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = eap.number;
                }
                return eap.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Eap(number=" + this.number + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.number);
            }

            public boolean equals(@Nullable Object other2) {
                if (this == other2) {
                    return true;
                }
                if (!(other2 instanceof Eap)) {
                    return false;
                }
                Eap eap = (Eap)other2;
                return this.number == eap.number;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Milestone;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "(I)V", "getNumber", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Milestone
        extends Kind {
            private final int number;

            public Milestone(int number) {
                super("M" + number, null);
                this.number = number;
            }

            public final int getNumber() {
                return this.number;
            }

            public final int component1() {
                return this.number;
            }

            @NotNull
            public final Milestone copy(int number) {
                return new Milestone(number);
            }

            public static /* synthetic */ Milestone copy$default(Milestone milestone, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = milestone.number;
                }
                return milestone.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Milestone(number=" + this.number + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.number);
            }

            public boolean equals(@Nullable Object other2) {
                if (this == other2) {
                    return true;
                }
                if (!(other2 instanceof Milestone)) {
                    return false;
                }
                Milestone milestone = (Milestone)other2;
                return this.number == milestone.number;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Release;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "()V", "kotlin.base.plugin"})
        public static final class Release
        extends Kind {
            @NotNull
            public static final Release INSTANCE = new Release();

            private Release() {
                super(null, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ReleaseCandidate;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "(I)V", "getNumber", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class ReleaseCandidate
        extends Kind {
            private final int number;

            public ReleaseCandidate(int number) {
                super((String)(number == 1 ? "RC" : "RC" + number), null);
                this.number = number;
            }

            public final int getNumber() {
                return this.number;
            }

            public final int component1() {
                return this.number;
            }

            @NotNull
            public final ReleaseCandidate copy(int number) {
                return new ReleaseCandidate(number);
            }

            public static /* synthetic */ ReleaseCandidate copy$default(ReleaseCandidate releaseCandidate, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = releaseCandidate.number;
                }
                return releaseCandidate.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "ReleaseCandidate(number=" + this.number + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.number);
            }

            public boolean equals(@Nullable Object other2) {
                if (this == other2) {
                    return true;
                }
                if (!(other2 instanceof ReleaseCandidate)) {
                    return false;
                }
                ReleaseCandidate releaseCandidate = (ReleaseCandidate)other2;
                return this.number == releaseCandidate.number;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Snapshot;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "()V", "kotlin.base.plugin"})
        public static final class Snapshot
        extends Kind {
            @NotNull
            public static final Snapshot INSTANCE = new Snapshot();

            private Snapshot() {
                super("SNAPSHOT", null);
            }
        }
    }
}

