/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/NameWithTypeCompletion;", "", "()V", "prefixEndsWithUppercaseLetterPattern", "Lcom/intellij/patterns/StringPattern;", "Lorg/jetbrains/annotations/NotNull;", "getPrefixEndsWithUppercaseLetterPattern", "()Lcom/intellij/patterns/StringPattern;", "shouldCompleteParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "kotlin.completion.impl-shared"})
public final class NameWithTypeCompletion {
    @NotNull
    public static final NameWithTypeCompletion INSTANCE = new NameWithTypeCompletion();
    @NotNull
    private static final StringPattern prefixEndsWithUppercaseLetterPattern;

    private NameWithTypeCompletion() {
    }

    public final boolean shouldCompleteParameter(@NotNull KtParameter parameter2) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        PsiElement psiElement2 = parameter2.getParent();
        KtParameterList ktParameterList = psiElement2 instanceof KtParameterList ? (KtParameterList)psiElement2 : null;
        if (ktParameterList == null) {
            return false;
        }
        KtParameterList list2 = ktParameterList;
        PsiElement owner = list2.getParent();
        return ((owner instanceof KtCatchClause ? true : owner instanceof KtPropertyAccessor) ? true : owner instanceof KtFunctionLiteral) ? false : (owner instanceof KtNamedFunction ? ((KtNamedFunction)owner).getNameIdentifier() != null : (owner instanceof KtPrimaryConstructor ? !((KtPrimaryConstructor)owner).getContainingClassOrObject().isAnnotation() : true));
    }

    @NotNull
    public final StringPattern getPrefixEndsWithUppercaseLetterPattern() {
        return prefixEndsWithUppercaseLetterPattern;
    }

    static {
        ObjectPattern objectPattern = StandardPatterns.string().with((PatternCondition)new PatternCondition<String>(){

            public boolean accepts(@NotNull String prefix2, @Nullable ProcessingContext context2) {
                Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
                return ((CharSequence)prefix2).length() > 0 && Character.isUpperCase(StringsKt.last((CharSequence)prefix2));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        prefixEndsWithUppercaseLetterPattern = (StringPattern)objectPattern;
    }
}

