/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups.factories;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategy;
import org.jetbrains.kotlin.idea.completion.lookups.QuotedNamesAwareInsertionHandler;
import org.jetbrains.kotlin.idea.completion.lookups.factories.ClassifierLookupObject;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\u0004*\u00020\fH\u0002J\f\u0010\r\u001a\u00020\u0004*\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/ClassifierInsertionHandler;", "Lorg/jetbrains/kotlin/idea/completion/lookups/QuotedNamesAwareInsertionHandler;", "()V", "caretInTheMiddleOfElement", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "handleInsert", "", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isCallableDeclarationIdentifier", "Lcom/intellij/psi/PsiElement;", "isContextReceiverWithoutOwnerDeclaration", "kotlin.completion.impl-k2"})
@SourceDebugExtension(value={"SMAP\nClassLookupElementFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLookupElementFactory.kt\norg/jetbrains/kotlin/idea/completion/lookups/factories/ClassifierInsertionHandler\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,125:1\n60#2,2:126\n*S KotlinDebug\n*F\n+ 1 ClassLookupElementFactory.kt\norg/jetbrains/kotlin/idea/completion/lookups/factories/ClassifierInsertionHandler\n*L\n119#1:126,2\n*E\n"})
final class ClassifierInsertionHandler
extends QuotedNamesAwareInsertionHandler {
    @NotNull
    public static final ClassifierInsertionHandler INSTANCE = new ClassifierInsertionHandler();

    private ClassifierInsertionHandler() {
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
        PsiFile psiFile2 = context2.getFile();
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return;
        }
        KtFile targetFile2 = ktFile;
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.lookups.factories.ClassifierLookupObject");
        ClassifierLookupObject lookupObject = (ClassifierLookupObject)object;
        super.handleInsert(context2, item);
        if (lookupObject.getImportingStrategy() instanceof ImportStrategy.InsertFqNameAndShorten) {
            Pair pair;
            String fqNameRendered = RenderingUtilsKt.render((FqName)((ImportStrategy.InsertFqNameAndShorten)lookupObject.getImportingStrategy()).getFqName());
            PsiElement token = context2.getFile().findElementAt(context2.getStartOffset());
            PsiElement psiElement2 = token;
            if ((psiElement2 != null ? psiElement2.getParent() : null) instanceof KDocName) {
                pair = TuplesKt.to((Object)"", (Object)"");
            } else {
                PsiElement psiElement3 = token;
                boolean bl = psiElement3 != null ? this.isCallableDeclarationIdentifier(psiElement3) : false;
                if (bl) {
                    pair = TuplesKt.to((Object)"", (Object)".f");
                } else {
                    PsiElement psiElement4 = token;
                    boolean bl2 = psiElement4 != null ? this.isContextReceiverWithoutOwnerDeclaration(psiElement4) : false;
                    if (bl2) {
                        pair = TuplesKt.to((Object)"", (Object)") fun");
                    } else {
                        PsiElement psiElement5 = token;
                        pair = !((psiElement5 != null ? psiElement5.getParent() : null) instanceof KtNameReferenceExpression) ? TuplesKt.to((Object)"$;val v:", (Object)"$") : (this.caretInTheMiddleOfElement(context2) ? TuplesKt.to((Object)"", (Object)".f") : TuplesKt.to((Object)"", (Object)""));
                    }
                }
            }
            Pair pair2 = pair;
            String temporaryPrefix = (String)pair2.component1();
            String temporarySuffix = (String)pair2.component2();
            context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)(temporaryPrefix + fqNameRendered + temporarySuffix));
            context2.commitDocument();
            int fqNameStartOffset = context2.getStartOffset() + temporaryPrefix.length();
            int fqNameEndOffset = fqNameStartOffset + fqNameRendered.length();
            RangeMarker rangeMarker2 = context2.getDocument().createRangeMarker(context2.getStartOffset(), fqNameEndOffset + temporarySuffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"createRangeMarker(...)");
            RangeMarker rangeMarker3 = rangeMarker2;
            RangeMarker rangeMarker4 = context2.getDocument().createRangeMarker(fqNameStartOffset, fqNameEndOffset);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker4, (String)"createRangeMarker(...)");
            RangeMarker fqNameRangeMarker = rangeMarker4;
            ShortenUtilsKt.shortenReferencesInRange$default(targetFile2, new TextRange(fqNameStartOffset, fqNameEndOffset), null, null, 12, null);
            context2.commitDocument();
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(context2.getDocument());
            if (rangeMarker3.isValid() && fqNameRangeMarker.isValid()) {
                context2.getDocument().deleteString(rangeMarker3.getStartOffset(), fqNameRangeMarker.getStartOffset());
                context2.getDocument().deleteString(fqNameRangeMarker.getEndOffset(), rangeMarker3.getEndOffset());
            }
        }
    }

    private final boolean caretInTheMiddleOfElement(InsertionContext context2) {
        int caretOffset = context2.getEditor().getCaretModel().getOffset();
        PsiElement psiElement2 = context2.getFile().findElementAt(caretOffset);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement element3 = psiElement2;
        return UtilsKt.getStartOffset((PsiElement)element3) < caretOffset && caretOffset < UtilsKt.getEndOffset((PsiElement)element3);
    }

    private final boolean isCallableDeclarationIdentifier(PsiElement $this$isCallableDeclarationIdentifier) {
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)$this$isCallableDeclarationIdentifier), (Object)KtTokens.IDENTIFIER) && $this$isCallableDeclarationIdentifier.getParent() instanceof KtCallableDeclaration;
    }

    private final boolean isContextReceiverWithoutOwnerDeclaration(PsiElement $this$isContextReceiverWithoutOwnerDeclaration) {
        KtContextReceiver contextReceiver2;
        PsiElement $this$parentOfType_u24default$iv = $this$isContextReceiverWithoutOwnerDeclaration;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtContextReceiver ktContextReceiver = contextReceiver2 = (KtContextReceiver)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtContextReceiver.class, (boolean)true);
        PsiElement psiElement2 = ktContextReceiver != null ? ktContextReceiver.getParent() : null;
        KtContextReceiverList ktContextReceiverList = psiElement2 instanceof KtContextReceiverList ? (KtContextReceiverList)psiElement2 : null;
        if (ktContextReceiverList == null) {
            return false;
        }
        KtContextReceiverList contextReceiverList = ktContextReceiverList;
        return !(contextReceiverList.getParent() instanceof KtDeclaration);
    }
}

