/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.IKotlinFacetSettings;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.AddRequiresDirectiveFacilityKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.projectConfiguration.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J.\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\u0014\u0010,\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0.\u0018\u00010-H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020'H\u0002J\u0010\u00101\u001a\u0002002\u0006\u0010)\u001a\u00020'H\u0016J\u0010\u00102\u001a\u0002002\u0006\u0010)\u001a\u00020'H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00058UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u0019\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "Lorg/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "getLibraryJarDescriptor", "()Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "libraryName", "getLibraryName", "libraryProperties", "getLibraryProperties", "()Lorg/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties;", "libraryType", "Lcom/intellij/jarRepository/RepositoryLibraryType;", "getLibraryType", "()Lcom/intellij/jarRepository/RepositoryLibraryType;", "messageForOverrideDialog", "getMessageForOverrideDialog", "name", "getName", "presentableText", "getPresentableText", "stdlibDetector", "Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "getStdlibDetector", "()Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "configureKotlinSettings", "", "modules", "", "Lcom/intellij/openapi/module/Module;", "configureModule", "module", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "writeActions", "", "Lkotlin/Function0;", "hasBrokenJsRuntime", "", "isApplicable", "isConfigured", "Companion", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nKotlinJavaModuleConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJavaModuleConfigurator.kt\norg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,130:1\n1224#2,2:131\n*S KotlinDebug\n*F\n+ 1 KotlinJavaModuleConfigurator.kt\norg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator\n*L\n74#1:131,2\n*E\n"})
public class KotlinJavaModuleConfigurator
extends KotlinWithLibraryConfigurator<RepositoryLibraryProperties> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "java";

    @Override
    public boolean isApplicable(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return super.isApplicable(module2) && !this.hasBrokenJsRuntime(module2);
    }

    @NotNull
    public RepositoryLibraryType getLibraryType() {
        RepositoryLibraryType repositoryLibraryType = RepositoryLibraryType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryLibraryType, (String)"getInstance(...)");
        return repositoryLibraryType;
    }

    @Override
    @NotNull
    public RepositoryLibraryProperties getLibraryProperties() {
        return this.getLibraryJarDescriptor().getRepositoryLibraryProperties();
    }

    @Override
    @NotNull
    public StdlibDetectorFacility getStdlibDetector() {
        return KotlinJvmStdlibDetectorFacility.INSTANCE;
    }

    @Override
    public boolean isConfigured(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJvmRuntimeInScope(module2);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        return "KotlinJavaRuntime";
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return JavaRuntimeLibraryDescription.Companion.getDIALOG_TITLE();
    }

    @Override
    @Nls
    @NotNull
    protected String getMessageForOverrideDialog() {
        return JavaRuntimeLibraryDescription.Companion.getJAVA_RUNTIME_LIBRARY_CREATION();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return KotlinProjectConfigurationBundle.message("language.name.java", new Object[0]);
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @Override
    @NotNull
    public LibraryJarDescriptor getLibraryJarDescriptor() {
        return LibraryJarDescriptor.RUNTIME_JDK8_JAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void configureKotlinSettings(@NotNull List<? extends Module> modules2) {
        boolean canChangeProjectSettings2;
        Module project2;
        block8: {
            boolean bl;
            void $this$all$iv;
            Intrinsics.checkNotNullParameter(modules2, (String)"modules");
            Module module2 = (Module)CollectionsKt.firstOrNull(modules2);
            if (module2 == null || (module2 = module2.getProject()) == null) {
                return;
            }
            project2 = module2;
            Sequence sequence2 = SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])ProjectUtil.getModules((Project)project2)), (Function1)configureKotlinSettings.canChangeProjectSettings.1.INSTANCE), (Function1)configureKotlinSettings.canChangeProjectSettings.2.INSTANCE);
            boolean bl2 = false;
            for (Object element$iv : $this$all$iv) {
                JavaSdkVersion it = (JavaSdkVersion)element$iv;
                boolean bl22 = false;
                if (it.isAtLeast(JavaSdkVersion.JDK_1_8)) continue;
                bl = false;
                break block8;
            }
            bl = canChangeProjectSettings2 = true;
        }
        if (canChangeProjectSettings2) {
            Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance((Project)project2).update(configureKotlinSettings.1.INSTANCE);
        } else {
            for (Module module3 : modules2) {
                IdeModifiableModelsProvider modelsProvider;
                JavaSdkVersion sdkVersion;
                Sdk sdk2;
                if (ProjectStructureUtils.getSdk(module3) == null || JavaSdk.getInstance().getVersion(sdk2) == null || !sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)ProjectDataManager.getInstance().createModifiableModelsProvider((Project)project2), (String)"createModifiableModelsProvider(...)");
                try {
                    KotlinFacet facet = FacetUtilsKt.getOrCreateFacet$default(module3, modelsProvider, false, null, true, 4, null);
                    IKotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                    KotlinFacetUtils.initializeIfNeeded$default(facetSettings, module3, null, JvmPlatforms.INSTANCE.getJvm8(), null, 8, null);
                    CommonCompilerArguments commonCompilerArguments = facetSettings.getCompilerArguments();
                    K2JVMCompilerArguments k2JVMCompilerArguments = commonCompilerArguments instanceof K2JVMCompilerArguments ? (K2JVMCompilerArguments)commonCompilerArguments : null;
                    if (k2JVMCompilerArguments == null) continue;
                    k2JVMCompilerArguments.setJvmTarget("1.8");
                }
                finally {
                    modelsProvider.dispose();
                }
            }
        }
    }

    @Override
    public void configureModule(@NotNull Module module2, @NotNull NotificationMessageCollector collector2, @Nullable List<Function0<Unit>> writeActions) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        super.configureModule(module2, collector2, writeActions);
        Function0<Unit> function0 = AddRequiresDirectiveFacilityKt.addStdlibToJavaModuleInfoLazy(module2, collector2);
        if (function0 == null) {
            return;
        }
        Function0<Unit> callable2 = function0;
        if (writeActions != null) {
            writeActions.add(callable2);
        } else {
            callable2.invoke();
        }
    }

    private final boolean hasBrokenJsRuntime(Module module2) {
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module2).getOrderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
        for (OrderEntry orderEntry : orderEntryArray) {
            LibraryEx library2;
            LibraryOrderEntry libraryOrderEntry = orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
            Object object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
            if ((object instanceof LibraryEx ? (LibraryEx)object : null) == null) continue;
            library2 = library2;
            Project project2 = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!KotlinJavaScriptStdlibDetectorFacility.INSTANCE.isStdlib(project2, (Library)library2, true)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator$Companion;", "", "()V", "NAME", "", "instance", "Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "getInstance", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "kotlin.project-configuration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinJavaModuleConfigurator getInstance() {
            Object object = Extensions.findExtension(KotlinProjectConfigurator.Companion.getEP_NAME(), KotlinJavaModuleConfigurator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"findExtension(...)");
            return (KotlinJavaModuleConfigurator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

