/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.AutoConfigurationSettings;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;
import org.jetbrains.kotlin.idea.util.FileUtils;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0011H\u0007J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "checkingAutoConfig", "", "gradleSyncInProgress", "gradleSyncQueued", "notificationCooldownEnd", "", "Ljava/lang/Long;", "isGradleSyncInProgress", "isGradleSyncPending", "onGradleSyncFinished", "", "onGradleSyncStarted", "queueGradleSync", "refreshEditorNotifications", "runAutoConfigurationIfPossible", "module", "Lcom/intellij/openapi/module/Module;", "shouldShowNotConfiguredDialog", "Companion", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectConfigurationService.kt\norg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n3792#2:142\n4307#2,2:143\n1855#3,2:145\n*S KotlinDebug\n*F\n+ 1 KotlinProjectConfigurationService.kt\norg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService\n*L\n54#1:142\n54#1:143,2\n58#1:145,2\n*E\n"})
public final class KotlinProjectConfigurationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private volatile boolean checkingAutoConfig;
    @Nullable
    private volatile Long notificationCooldownEnd;
    private volatile boolean gradleSyncInProgress;
    private volatile boolean gradleSyncQueued;

    public KotlinProjectConfigurationService(@NotNull Project project2, @NotNull CoroutineScope coroutineScope2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope2, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope2;
    }

    public final boolean shouldShowNotConfiguredDialog() {
        if (this.checkingAutoConfig) {
            return false;
        }
        Long l = this.notificationCooldownEnd;
        if (l == null) {
            return true;
        }
        long cooldownEnd = l;
        return System.currentTimeMillis() >= cooldownEnd;
    }

    public final boolean isGradleSyncPending() {
        ObservableProperty notificationVisibleProperty = ExternalSystemProjectNotificationAware.Companion.isNotificationVisibleProperty(this.project, new ProjectSystemId("GRADLE", "Gradle"));
        return (Boolean)notificationVisibleProperty.get();
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshEditorNotifications() {
        void $this$filterTo$iv$iv;
        VirtualFile[] openFiles;
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        VirtualFile[] $this$filter$iv = openFiles = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!FileUtils.isKotlinFileType((VirtualFile)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List openKotlinFiles = (List)destination$iv$iv;
        if (openKotlinFiles.isEmpty()) {
            return;
        }
        EditorNotifications editorNotifications = EditorNotifications.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)editorNotifications, (String)"getInstance(...)");
        EditorNotifications editorNotifications2 = editorNotifications;
        Iterable $this$forEach$iv = openKotlinFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            editorNotifications2.updateNotifications(it);
        }
    }

    public final boolean isGradleSyncInProgress() {
        return this.gradleSyncInProgress;
    }

    public final void queueGradleSync() {
        if (this.gradleSyncInProgress) {
            this.gradleSyncQueued = true;
        } else {
            ExternalSystemProjectTracker.Companion.getInstance(this.project).scheduleProjectRefresh();
        }
    }

    @ApiStatus.Internal
    public final void onGradleSyncStarted() {
        this.gradleSyncInProgress = true;
    }

    @ApiStatus.Internal
    public final void onGradleSyncFinished() {
        this.gradleSyncInProgress = false;
        if (this.gradleSyncQueued) {
            this.gradleSyncQueued = false;
            ExternalSystemProjectTracker.Companion.getInstance(this.project).scheduleProjectRefresh();
        }
    }

    public final void runAutoConfigurationIfPossible(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.checkingAutoConfig = true;
        this.refreshEditorNotifications();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(module2, this, null){
            int I$0;
            Object L$0;
            int label;
            final /* synthetic */ Module $module;
            final /* synthetic */ KotlinProjectConfigurationService this$0;
            {
                this.$module = $module;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        configured = 0;
                        this.I$0 = configured;
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)((Function0)new Function0<KotlinProjectConfigurator>(this.$module){
                            final /* synthetic */ Module $module;
                            {
                                this.$module = $module;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final KotlinProjectConfigurator invoke() {
                                Object v0;
                                block1: {
                                    void $this$firstOrNull$iv;
                                    Object[] objectArray = KotlinProjectConfigurator.Companion.getEP_NAME().getExtensions();
                                    Module module2 = this.$module;
                                    boolean $i$f$firstOrNull = false;
                                    for (void element$iv : $this$firstOrNull$iv) {
                                        KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                                        boolean bl = false;
                                        if (!(it.canRunAutoConfig() && it.isApplicable(module2))) continue;
                                        v0 = element$iv;
                                        break block1;
                                    }
                                    v0 = null;
                                }
                                return v0;
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var6_2) goto lbl13
lbl12:
                        // 1 sources

                        return var6_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        configured = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if ((KotlinProjectConfigurator)v0 != null) break;
                        var5_4 = Unit.INSTANCE;
                        KotlinProjectConfigurationService.access$setCheckingAutoConfig$p(this.this$0, false);
                        if (configured == 0) {
                            this.this$0.refreshEditorNotifications();
                            this.L$0 = var5_4;
                            this.label = 2;
                            v1 = CoroutinesKt.readAction((Function0)((Function0)new Function0<Unit>(this.$module){
                                final /* synthetic */ Module $module;
                                {
                                    this.$module = $module;
                                    super(0);
                                }

                                public final void invoke() {
                                    ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(this.$module);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                        }
                        ** GOTO lbl35
                    }
                    case 2: {
                        var5_4 = (Unit)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl35:
                        // 2 sources

                        return var5_4;
                    }
                }
                try {
                    autoConfigurator = v2;
                    v3 = this.$module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getProject(...)");
                    this.L$0 = autoConfigurator;
                    this.I$0 = configured;
                    this.label = 3;
                    v4 = TasksKt.withBackgroundProgress((Project)v3, (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.check", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AutoConfigurationSettings>, Object>(autoConfigurator, this.$module, null){
                        int label;
                        final /* synthetic */ KotlinProjectConfigurator $autoConfigurator;
                        final /* synthetic */ Module $module;
                        {
                            this.$autoConfigurator = $autoConfigurator;
                            this.$module = $module;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.label = 1;
                                    v0 = this.$autoConfigurator.calculateAutoConfigSettings(this.$module, (Continuation<? super AutoConfigurationSettings>)((Continuation)this));
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    settings = (AutoConfigurationSettings)v0;
                                    v1 = this.$module.getProject();
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                                    KotlinJ2KOnboardingFUSCollector.INSTANCE.logCheckAutoConfigStatus(v1, settings != null);
                                    return settings;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super AutoConfigurationSettings> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)((Continuation)this));
                    ** if (v4 != var6_2) goto lbl56
                }
                catch (Throwable var3_7) {
                    KotlinProjectConfigurationService.access$setCheckingAutoConfig$p(this.this$0, false);
                    if (configured == 0) {
                        this.this$0.refreshEditorNotifications();
                        this.L$0 = var3_7;
                        this.label = 7;
                        v5 = CoroutinesKt.readAction((Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                        if (v5 == var6_2) {
                            return var6_2;
                        }
                    }
                    ** GOTO lbl105
                }
lbl55:
                // 1 sources

                return var6_2;
lbl56:
                // 1 sources

                ** GOTO lbl64
                {
                    case 3: {
                        configured = this.I$0;
                        autoConfigurator = (KotlinProjectConfigurator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl64:
                        // 2 sources

                        if ((autoConfigSettings = (AutoConfigurationSettings)v4) != null) break;
                        var5_5 = Unit.INSTANCE;
                        KotlinProjectConfigurationService.access$setCheckingAutoConfig$p(this.this$0, false);
                        if (configured == 0) {
                            this.this$0.refreshEditorNotifications();
                            this.L$0 = var5_5;
                            this.label = 4;
                            v6 = CoroutinesKt.readAction((Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                            if (v6 == var6_2) {
                                return var6_2;
                            }
                        }
                        ** GOTO lbl79
                    }
                    case 4: {
                        var5_5 = (Unit)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl79:
                        // 2 sources

                        return var5_5;
                    }
                }
                this.L$0 = null;
                this.I$0 = configured;
                this.label = 5;
                v7 = autoConfigurator.runAutoConfig(autoConfigSettings, (Continuation<? super Unit>)((Continuation)this));
                ** if (v7 != var6_2) goto lbl87
lbl86:
                // 1 sources

                return var6_2;
lbl87:
                // 1 sources

                ** GOTO lbl94
                {
                    case 5: {
                        configured = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl94:
                        // 2 sources

                        configured = 1;
                        KotlinProjectConfigurationService.access$setNotificationCooldownEnd$p(this.this$0, Boxing.boxLong((long)(System.currentTimeMillis() + (long)2000)));
                        KotlinProjectConfigurationService.access$setCheckingAutoConfig$p(this.this$0, false);
                        break;
                    }
                    case 6: {
                        ResultKt.throwOnFailure((Object)$result);
                        break;
                    }
                    case 7: {
                        var3_8 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl105:
                        // 2 sources

                        throw var3_8;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static final /* synthetic */ void access$setNotificationCooldownEnd$p(KotlinProjectConfigurationService $this, Long l) {
        $this.notificationCooldownEnd = l;
    }

    public static final /* synthetic */ void access$setCheckingAutoConfig$p(KotlinProjectConfigurationService $this, boolean bl) {
        $this.checkingAutoConfig = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.project-configuration"})
    @SourceDebugExtension(value={"SMAP\nKotlinProjectConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectConfigurationService.kt\norg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,141:1\n30#2,3:142\n*S KotlinDebug\n*F\n+ 1 KotlinProjectConfigurationService.kt\norg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$Companion\n*L\n27#1:142,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinProjectConfigurationService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<KotlinProjectConfigurationService> serviceClass$iv = KotlinProjectConfigurationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (KotlinProjectConfigurationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

