/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.loader;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptOutsiderFileConfigurationLoader;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "loadDependencies", "", "isFirstLoad", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "context", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoadingContext;", "kotlin.base.scripting"})
public final class ScriptOutsiderFileConfigurationLoader
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    public ScriptOutsiderFileConfigurationLoader(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context2) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!isFirstLoad) {
            return false;
        }
        VirtualFile virtualFile2 = ktFile.getOriginalFile().getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile2);
        VirtualFile virtualFile3 = ProjectStructureUtils.getOutsiderFileOrigin(this.project, virtualFile2);
        if (virtualFile3 == null) {
            return false;
        }
        VirtualFile fileOrigin = virtualFile3;
        ScriptConfigurationSnapshot original = context2.getCachedConfiguration(fileOrigin);
        if (original != null) {
            context2.saveNewConfiguration(virtualFile2, new ScriptConfigurationSnapshot(original.getInputs(), CollectionsKt.emptyList(), original.getConfiguration()));
        }
        return true;
    }
}

