/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.PositionManagerWithMultipleStackFrames;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotatedKt;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationWithArgumentsInfo;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtFunctionalType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.InlineUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposableUtils;
import org.jetbrains.kotlin.idea.debugger.IrLambdaDescriptor;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager$getAppropriateLiteralForCrossinlineLambda$;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmDebuggerBasePsiUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinAllFilesScopeProvider;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextTuner;
import org.jetbrains.kotlin.idea.debugger.core.ComposeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.LineBreakpointExpressionVisitor;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.SourcePositionRefiner;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculator;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0017J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020!H\u0016J$\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0\u00072\u0006\u0010\u0013\u001a\u00020\u0010H\u0003J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020*0\u00072\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u001bH\u0002J\"\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u001bH\u0002J\"\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0018\u001a\u0002012\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001bH\u0002J\"\u0010<\u001a\u0004\u0018\u00010:2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u001bH\u0002J\u0012\u0010=\u001a\u0004\u0018\u0001012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020*0\u00072\u0006\u0010\u0013\u001a\u00020\u0010H\u0003J\u0014\u0010?\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020:2\u0006\u00104\u001a\u00020\u001bH\u0002J\u0010\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020!H\u0002J\u001e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010F\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020!0\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010H\u001a\u00020A*\u0002082\u0006\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020AH\u0002J0\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007*\u00020\u00172\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020!H\u0002J\u001c\u0010P\u001a\u0004\u0018\u00010:*\b\u0012\u0004\u0012\u00020:0\u00072\u0006\u0010I\u001a\u00020!H\u0002J$\u0010Q\u001a\u0004\u0018\u00010:*\b\u0012\u0004\u0012\u00020:0\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u001bH\u0002J%\u0010R\u001a\u0004\u0018\u00010:*\b\u0012\u0004\u0012\u00020:0\u00072\u0006\u0010I\u001a\u00020!H\u0002R\u00020S\u00a2\u0006\u0002\u0010TJ\u0017\u0010U\u001a\u0004\u0018\u00010!*\u00020VH\u0002R\u00020S\u00a2\u0006\u0002\u0010WJ \u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170Y0\u0007*\u00020N2\u0006\u0010O\u001a\u00020!H\u0002J\u000e\u0010Z\u001a\u0004\u0018\u00010V*\u00020:H\u0002J(\u0010[\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010Y*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170Y0\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\\\u001a\u0004\u0018\u00010:*\b\u0012\u0004\u0012\u00020:0\u00072\u0006\u0010]\u001a\u00020\u001bH\u0002J\u0014\u0010^\u001a\u00020A*\u00020:2\u0006\u00104\u001a\u00020\u001bH\u0002J\u0014\u0010_\u001a\u00020A*\u00020\u00172\u0006\u0010`\u001a\u000201H\u0002J\u000e\u0010a\u001a\u0004\u0018\u000106*\u00020:H\u0002J\u001c\u0010b\u001a\u00020A*\u00020\u00172\u0006\u0010`\u001a\u0002012\u0006\u0010O\u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerWithMultipleStackFrames;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "sourceSearchScopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "stackFrameInterceptor", "Lorg/jetbrains/kotlin/idea/debugger/core/StackFrameInterceptor;", "createKotlinClassPrepareRequests", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequest", "classPrepareRequestor", "sourcePosition", "createPrepareRequests", "createSourcePosition", "location", "Lcom/sun/jdi/Location;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "sourceLineNumber", "", "createStackFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl;", "defaultInternalName", "", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "expression", "findTargetClasses", "Lcom/sun/jdi/ReferenceType;", "candidates", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "getAlternativeSource", "Lcom/intellij/psi/PsiFile;", "getCallableReferenceIfInside", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "lineNumber", "getElementForDeclarationLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "getFirstElementInsideLambdaOnLine", "Lcom/intellij/psi/PsiElement;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "line", "getLambdaOrFunOnLineIfInside", "getPsiFileByLocation", "getReferenceTypesCandidates", "getSourcePosition", "hasImplicitReturnOnLine", "", "function", "isNestedClassName", "name", "locationsOfLine", "type", "originalClassNamesForPosition", "calculatedClassNameMatches", "currentLocationClassName", "isLambda", "findLocationsInSameInlinedFunction", "locations", "method", "Lcom/sun/jdi/Method;", "sourceFileName", "getAppropriateLiteralBasedOnDeclaringClassName", "getAppropriateLiteralBasedOnLambdaName", "getAppropriateLiteralForCrossinlineLambda", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/psi/KtFunction;", "getBytecodeMethodName", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "getInlineFunctionBorders", "Lkotlin/ranges/ClosedRange;", "getLambdaCallMethod", "getLeastEnclosingBorders", "getSamLambdaWithIndex", "index", "hasExecutableCodeInsideOnLine", "hasFinallyBlockInParent", "psiFile", "lastStatementSkippingComments", "shouldBeTreatedAsReentrantSourcePosition", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 JvmDebuggerBasePsiUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/JvmDebuggerBasePsiUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 7 breakpointTypeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointTypeUtilsKt\n+ 8 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 9 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 10 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 11 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 12 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,812:1\n41#2:813\n32#3:814\n288#4,2:815\n766#4:818\n857#4,2:819\n766#4:823\n857#4,2:824\n800#4,11:837\n288#4,2:848\n2624#4,3:850\n288#4,2:864\n766#4:866\n857#4,2:867\n766#4:875\n857#4,2:876\n661#4,11:878\n766#4:891\n857#4,2:892\n1747#4,3:894\n766#4:897\n857#4,2:898\n1045#4:900\n766#4:901\n857#4,2:902\n1360#4:917\n1446#4,5:918\n1360#4:923\n1446#4,5:924\n766#4:929\n857#4,2:930\n1360#4:934\n1446#4,5:935\n1#5:817\n60#6,2:821\n214#6,2:869\n60#6,2:872\n427#6:915\n129#7,11:826\n27#8,2:853\n27#8,2:904\n55#9:855\n69#9,8:856\n55#9:906\n69#9,8:907\n473#10:871\n14#11:874\n14#11:889\n14#11:890\n14#11:933\n188#12:916\n118#12:932\n*S KotlinDebug\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManager\n*L\n83#1:813\n217#1:814\n220#1:815,2\n229#1:818\n229#1:819,2\n254#1:823\n254#1:824,2\n303#1:837,11\n305#1:848,2\n320#1:850,3\n345#1:864,2\n359#1:866\n359#1:867,2\n396#1:875\n396#1:876,2\n398#1:878,11\n414#1:891\n414#1:892,2\n415#1:894,3\n427#1:897\n427#1:898,2\n433#1:900\n437#1:901\n437#1:902,2\n559#1:917\n559#1:918,5\n566#1:923\n566#1:924,5\n612#1:929\n612#1:930,2\n668#1:934\n668#1:935,5\n246#1:821,2\n373#1:869,2\n389#1:872,2\n482#1:915\n303#1:826,11\n323#1:853,2\n469#1:904,2\n323#1:855\n323#1:856,8\n469#1:906\n469#1:907,8\n373#1:871\n394#1:874\n399#1:889\n400#1:890\n648#1:933\n535#1:916\n647#1:932\n*E\n"})
public final class KotlinPositionManager
implements MultiRequestPositionManager,
PositionManagerWithMultipleStackFrames {
    @NotNull
    private final DebugProcess debugProcess;
    @Nullable
    private final StackFrameInterceptor stackFrameInterceptor;
    @NotNull
    private final List<GlobalSearchScope> sourceSearchScopes;

    public KotlinPositionManager(@NotNull DebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$serviceOrNull$iv = (ComponentManager)project2;
        boolean $i$f$serviceOrNull = false;
        this.stackFrameInterceptor = (StackFrameInterceptor)$this$serviceOrNull$iv.getService(StackFrameInterceptor.class);
        Object[] objectArray = new GlobalSearchScope[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.debugProcess.getSearchScope(), (String)"getSearchScope(...)");
        Project project3 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        objectArray[1] = KotlinAllFilesScopeProvider.Companion.getInstance(project3).getAllKotlinFilesScope();
        this.sourceSearchScopes = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        return ProjectStructureUtils.getKOTLIN_FILE_TYPES();
    }

    @NotNull
    public ThreeState evaluateCondition(@NotNull EvaluationContext context2, @NotNull StackFrameProxyImpl frame, @NotNull Location location2, @NotNull String expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return ThreeState.UNSURE;
    }

    @NotNull
    public List<XStackFrame> createStackFrames(@NotNull StackFrameDescriptorImpl descriptor2) {
        List<XStackFrame> inlineStackTrace;
        XStackFrame coroutineFrame;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Location location2 = descriptor2.getLocation();
        if (location2 == null || !DebuggerUtil.isInKotlinSources(location2)) {
            return CollectionsKt.emptyList();
        }
        StackFrameProxyImpl stackFrameProxyImpl = descriptor2.getFrameProxy();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"getFrameProxy(...)");
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        StackFrameInterceptor stackFrameInterceptor = this.stackFrameInterceptor;
        if (stackFrameInterceptor != null) {
            DebugProcess debugProcess = descriptor2.getDebugProcess();
            Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
            v3 = stackFrameInterceptor.createStackFrame(frameProxy, (DebugProcessImpl)debugProcess, location2);
        } else {
            v3 = coroutineFrame = null;
        }
        if (coroutineFrame != null) {
            return CollectionsKt.listOf(coroutineFrame);
        }
        if (Registry.get((String)"debugger.kotlin.inline.stack.trace.enabled").asBoolean() && !((Collection)(inlineStackTrace = InlineStackTraceCalculator.INSTANCE.calculateInlineStackTrace(descriptor2))).isEmpty()) {
            return inlineStackTrace;
        }
        List<LocalVariableProxyImpl> visibleVariables = InlineStackTraceCalculator.INSTANCE.calculateVisibleVariables(frameProxy);
        return CollectionsKt.listOf((Object)((Object)new KotlinStackFrame(descriptor2, visibleVariables)));
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) {
        SourcePosition sourcePosition2;
        PsiFile psiFile2;
        if (location2 == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        String string = SafeUtilKt.safeSourceName(location2);
        if (string == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        String fileName = string;
        int lineNumber = SafeUtilKt.safeLineNumber(location2);
        if (lineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        PsiFile psiFile3 = this.getAlternativeSource(location2);
        if (psiFile3 == null) {
            psiFile3 = this.getPsiFileByLocation(location2);
        }
        if ((psiFile2 = psiFile3) == null) {
            ReferenceType referenceType = location2.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
            boolean isKotlinStrataAvailable = DebuggerUtil.containsKotlinStrata(referenceType);
            if (isKotlinStrataAvailable) {
                try {
                    String javaSourceFileName = location2.sourceName("Java");
                    JvmClassName jvmClassName = JvmClassName.byInternalName((String)this.defaultInternalName(location2));
                    Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
                    JvmClassName javaClassName = jvmClassName;
                    Project project2 = this.debugProcess.getProject();
                    Intrinsics.checkNotNull((Object)project2);
                    Intrinsics.checkNotNull((Object)javaSourceFileName);
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.sourceSearchScopes, javaClassName, javaSourceFileName, location2);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException javaSourceFileName) {
                    // empty catch block
                }
            }
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!(psiFile2 instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        int sourceLineNumber = SafeUtilKt.safeLineNumber(location2) - 1;
        if (sourceLineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        Method method = SafeUtilKt.safeMethod(location2);
        boolean bl = method != null ? KotlinPositionManagerKt.isGeneratedErasedLambdaMethod(method) : false;
        if (bl) {
            return null;
        }
        SourcePosition javaSourceFileName = PositionManagerImpl.adjustPositionForConditionalReturn((DebugProcess)this.debugProcess, (Location)location2, (PsiFile)psiFile2, (int)sourceLineNumber);
        if (javaSourceFileName != null) {
            SourcePosition it = javaSourceFileName;
            boolean bl2 = false;
            return it;
        }
        SourcePosition sourcePosition3 = this.createSourcePosition(location2, (KtFile)psiFile2, sourceLineNumber);
        if (sourcePosition3 == null) {
            sourcePosition3 = SourcePosition.createFromLine((PsiFile)psiFile2, (int)sourceLineNumber);
        }
        if (!((sourcePosition2 = sourcePosition3) instanceof KotlinReentrantSourcePosition) && this.shouldBeTreatedAsReentrantSourcePosition(location2, psiFile2, fileName)) {
            Intrinsics.checkNotNull((Object)sourcePosition2);
            return new KotlinReentrantSourcePosition(sourcePosition2);
        }
        return sourcePosition2;
    }

    private final SourcePosition createSourcePosition(Location location2, KtFile file2, int sourceLineNumber) {
        SourcePosition sourcePosition2;
        KtFunction lambdaOrFunIfInside = this.getLambdaOrFunOnLineIfInside(location2, file2, sourceLineNumber);
        if (lambdaOrFunIfInside != null) {
            PsiElement elementAt = this.getFirstElementInsideLambdaOnLine((PsiFile)file2, lambdaOrFunIfInside, sourceLineNumber);
            if (elementAt != null) {
                return SourcePosition.createFromElement((PsiElement)elementAt);
            }
            return SourcePosition.createFromLine((PsiFile)((PsiFile)file2), (int)sourceLineNumber);
        }
        KtCallableReferenceExpression callableReferenceIfInside = this.getCallableReferenceIfInside(location2, file2, sourceLineNumber);
        if (callableReferenceIfInside != null && (sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)callableReferenceIfInside))) != null) {
            return new KotlinReentrantSourcePosition(sourcePosition2);
        }
        KtElement elementInDeclaration = this.getElementForDeclarationLine(location2, file2, sourceLineNumber);
        if (elementInDeclaration != null) {
            return SourcePosition.createFromElement((PsiElement)((PsiElement)elementInDeclaration));
        }
        return null;
    }

    private final PsiElement getFirstElementInsideLambdaOnLine(PsiFile file2, KtFunction lambda2, int line) {
        Object v3;
        List elementsAtLine;
        block3: {
            KtExpression ktExpression = lambda2.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            TextRange bodyRange = ktExpression.getTextRange();
            TextRange textRange = JvmDebuggerBasePsiUtils.getRangeOfLine$default(file2, line, false, 2, null);
            Object object = textRange != null ? textRange.intersection(bodyRange) : null;
            if (object == null) {
                return null;
            }
            TextRange searchRange = object;
            PsiFile $this$findElementsOfTypeInRange$iv = file2;
            boolean $i$f$findElementsOfTypeInRange = false;
            Class[] classArray = new Class[]{PsiElement.class};
            elementsAtLine = JvmDebuggerBasePsiUtils.findElementsOfTypeInRange($this$findElementsOfTypeInRange$iv, searchRange, classArray);
            Iterable $this$firstOrNull$iv = elementsAtLine;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!searchRange.contains(it.getTextRange().getStartOffset())) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        PsiElement psiElement2 = v3;
        if (psiElement2 != null) {
            PsiElement it = psiElement2;
            boolean bl = false;
            return it;
        }
        return (PsiElement)CollectionsKt.firstOrNull(elementsAtLine);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldBeTreatedAsReentrantSourcePosition(Location $this$shouldBeTreatedAsReentrantSourcePosition, PsiFile psiFile2, String sourceFileName) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Method method = SafeUtilKt.safeMethod($this$shouldBeTreatedAsReentrantSourcePosition);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        Iterable iterable = SafeUtilKt.safeAllLineLocations(method2);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(it), (Object)sourceFileName) && it.lineNumber() == $this$shouldBeTreatedAsReentrantSourcePosition.lineNumber();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sameLineLocations = (List)destination$iv$iv;
        if (sameLineLocations.size() < 2 || this.hasFinallyBlockInParent($this$shouldBeTreatedAsReentrantSourcePosition, psiFile2)) {
            return false;
        }
        List<Location> locationsInSameInlinedFunction = this.findLocationsInSameInlinedFunction($this$shouldBeTreatedAsReentrantSourcePosition, sameLineLocations, method2, sourceFileName);
        Collection collection2 = locationsInSameInlinedFunction;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = sameLineLocations;
        } else {
            collection = collection2;
        }
        return ((List)collection).indexOf($this$shouldBeTreatedAsReentrantSourcePosition) > 0;
    }

    private final boolean hasFinallyBlockInParent(Location $this$hasFinallyBlockInParent, PsiFile psiFile2) {
        KtFinallySection ktFinallySection;
        PsiElement elementAt;
        PsiElement psiElement2;
        Integer n = PsiLinesUtilsKt.getLineStartOffset(psiFile2, $this$hasFinallyBlockInParent.lineNumber());
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            psiElement2 = psiFile2.findElementAt(it);
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        if (psiElement3 != null) {
            PsiElement $this$parentOfType_u24default$iv = psiElement3;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            ktFinallySection = (KtFinallySection)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFinallySection.class, (boolean)true);
        } else {
            ktFinallySection = null;
        }
        return ktFinallySection != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Location> findLocationsInSameInlinedFunction(Location $this$findLocationsInSameInlinedFunction, List<? extends Location> locations, Method method, String sourceFileName) {
        void $this$filterTo$iv$iv;
        ClosedRange<Location> closedRange = this.getLeastEnclosingBorders(this.getInlineFunctionBorders(method, sourceFileName), $this$findLocationsInSameInlinedFunction);
        if (closedRange == null) {
            return CollectionsKt.emptyList();
        }
        ClosedRange<Location> leastEnclosingBorders = closedRange;
        Iterable $this$filter$iv = locations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            if (!leastEnclosingBorders.contains((Comparable)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ClosedRange<Location> getLeastEnclosingBorders(List<? extends ClosedRange<Location>> $this$getLeastEnclosingBorders, Location location2) {
        ClosedRange<Location> result2 = null;
        for (ClosedRange<Location> closedRange : $this$getLeastEnclosingBorders) {
            if (!closedRange.contains((Comparable)location2) || result2 != null && ((Location)closedRange.getStart()).compareTo(result2.getStart()) <= 0) continue;
            result2 = closedRange;
        }
        return result2;
    }

    private final List<ClosedRange<Location>> getInlineFunctionBorders(Method $this$getInlineFunctionBorders, String sourceFileName) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull(DebuggerUtil.getInlineFunctionOrArgumentVariables($this$getInlineFunctionBorders), (Function1)getInlineFunctionBorders.1.INSTANCE), (Function1)((Function1)new Function1<ClosedRange<Location>, Boolean>(sourceFileName){
            final /* synthetic */ String $sourceFileName;
            {
                this.$sourceFileName = $sourceFileName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ClosedRange<Location> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName((Location)it.getStart()), (Object)this.$sourceFileName);
            }
        })));
    }

    private final PsiFile getAlternativeSource(Location location2) {
        PsiManager psiManager2 = PsiManager.getInstance((Project)this.debugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(...)");
        PsiManager manager = psiManager2;
        String qName = location2.declaringType().name();
        String string = DebuggerUtilsEx.getAlternativeSourceUrl((String)qName, (Project)this.debugProcess.getProject());
        if (string == null) {
            return null;
        }
        String alternativeFileUrl = string;
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(alternativeFileUrl);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile alternativePsiFile = virtualFile2;
        return manager.findFile(alternativePsiFile);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtElement getElementForDeclarationLine(Location location, KtFile file, int lineNumber) {
        block8: {
            block7: {
                block6: {
                    v0 = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, lineNumber);
                    if (v0 == null) {
                        return null;
                    }
                    lineStartOffset = v0;
                    elementAt = file.findElementAt(lineStartOffset);
                    contextElement = CodeFragmentContextTuner.Companion.getInstance().tuneContextElement(elementAt);
                    if (!(contextElement instanceof KtClass)) {
                        return null;
                    }
                    methodName = location.method().name();
                    Intrinsics.checkNotNull((Object)methodName);
                    if (!JvmAbi.isGetterName((String)methodName)) break block7;
                    v1 /* !! */  = ((KtClass)contextElement).getPrimaryConstructor();
                    if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getValueParameters()) == null) {
                        v1 /* !! */  = CollectionsKt.emptyList();
                    }
                    valueParameters /* !! */  = v1 /* !! */ ;
                    var9_9 = (Iterable)valueParameters /* !! */ ;
                    for (T var11_11 : var9_9) {
                        it = (KtParameter)var11_11;
                        $i$a$-find-KotlinPositionManager$getElementForDeclarationLine$1 = false;
                        if (!it.hasValOrVar() || it.getName() == null) ** GOTO lbl-1000
                        v2 = it.getName();
                        Intrinsics.checkNotNull((Object)v2);
                        if (Intrinsics.areEqual((Object)JvmAbi.getterName((String)v2), (Object)methodName)) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v4 = var11_11;
                        break block6;
                    }
                    v4 = null;
                }
                v5 = v4;
                break block8;
            }
            v5 = Intrinsics.areEqual((Object)methodName, (Object)"<init>") != false ? (KtElement)((KtClass)contextElement).getPrimaryConstructor() : null;
        }
        return v5;
    }

    /*
     * WARNING - void declaration
     */
    private final KtCallableReferenceExpression getCallableReferenceIfInside(Location location2, KtFile file2, int lineNumber) {
        Object v3;
        block6: {
            List list2;
            String string = KotlinPositionManagerKt.getClassName(location2);
            if (string == null) {
                return null;
            }
            String currentLocationClassName = string;
            boolean $i$f$getElementsAtLineIfAny = false;
            PsiElement psiElement2 = DebuggerUtil.findElementAtLine(file2, lineNumber);
            KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
            if (ktElement == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$filterIsInstanceTo$iv$iv$iv;
                KtElement lineElement$iv = ktElement;
                int start$iv = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement$iv));
                int end$iv = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement$iv));
                for (PsiElement nextSibling$iv = lineElement$iv.getNextSibling(); nextSibling$iv != null && lineNumber == PsiLinesUtilsKt.getLineNumber$default(nextSibling$iv, false, 1, null); nextSibling$iv = nextSibling$iv.getNextSibling()) {
                    end$iv = PsiUtilsKt.getEndOffset((PsiElement)nextSibling$iv);
                }
                Class[] classArray = new Class[]{KtCallableReferenceExpression.class};
                Iterable $this$filterIsInstance$iv$iv = FindElementUtils.findElementsOfClassInRange((PsiFile)file2, start$iv, end$iv, classArray);
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof KtCallableReferenceExpression)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                list2 = (List)destination$iv$iv$iv;
            }
            List allReferenceExpressions = list2;
            Iterable $this$firstOrNull$iv = allReferenceExpressions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtCallableReferenceExpression it = (KtCallableReferenceExpression)element$iv;
                boolean bl = false;
                if (!this.calculatedClassNameMatches((PsiElement)it, currentLocationClassName, false)) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final KtFunction getLambdaOrFunOnLineIfInside(Location location2, KtFile file2, int lineNumber) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        KtFunction it;
        boolean bl;
        List<KtFunction> literalsOrFunctions;
        String currentLocationClassName;
        block14: {
            String string = KotlinPositionManagerKt.getClassName(location2);
            if (string == null) {
                return null;
            }
            currentLocationClassName = string;
            Integer start2 = KotlinPsiUtils.getStartLineOffset((PsiFile)file2, lineNumber);
            Integer end = KotlinPsiUtils.getEndLineOffset((PsiFile)file2, lineNumber);
            if (start2 == null || end == null) {
                return null;
            }
            literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLine(file2, lineNumber);
            Iterable $this$none$iv = literalsOrFunctions;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (KtFunction)element$iv;
                    boolean bl2 = false;
                    if (!BreakpointTypeUtilsKt.isStartingOrEndingOnLine(it, lineNumber)) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        KtElement useSiteKtElement$iv = (KtElement)CollectionsKt.first(literalsOrFunctions);
        boolean $i$f$analyze = false;
        Project project2 = useSiteKtElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        it = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(useSiteKtElement$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$getLambdaOrFunOnLineIfInside_u24lambda_u2410 = analysisSession$iv$iv$iv;
            boolean bl3 = false;
            List notInlinedLambdas = new ArrayList();
            KtFunction innermostContainingLiteral = null;
            for (KtFunction literal : literalsOrFunctions) {
                KtValueParameterSymbol inlineArgument = InlineUtilsKt.getInlineArgumentSymbol($this$getLambdaOrFunOnLineIfInside_u24lambda_u2410, literal);
                if (inlineArgument != null && (!inlineArgument.isCrossinline() || DebuggerUtil.isInlinedArgument(literal, location2))) {
                    DebugProcess debugProcess = this.debugProcess;
                    Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                    if (!DebuggerUtil.isInsideInlineArgument(literal, location2, (DebugProcessImpl)debugProcess)) continue;
                    innermostContainingLiteral = literal;
                    continue;
                }
                notInlinedLambdas.add(literal);
            }
            KtFunction ktFunction = innermostContainingLiteral;
            if (ktFunction != null) {
                KtFunction ktFunction2 = ktFunction;
                return ktFunction2;
            }
            KtFunction ktFunction3 = this.getAppropriateLiteralBasedOnDeclaringClassName(notInlinedLambdas, currentLocationClassName);
            if (ktFunction3 == null && (ktFunction3 = this.getAppropriateLiteralForCrossinlineLambda($this$getLambdaOrFunOnLineIfInside_u24lambda_u2410, notInlinedLambdas, currentLocationClassName)) == null) {
                ktFunction3 = this.getAppropriateLiteralBasedOnLambdaName(notInlinedLambdas, location2, lineNumber);
            }
            KtFunction ktFunction4 = ktFunction3;
            return ktFunction4;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private final KtFunction getAppropriateLiteralBasedOnDeclaringClassName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnDeclaringClassName, String currentLocationClassName) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getAppropriateLiteralBasedOnDeclaringClassName;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtFunction it = (KtFunction)element$iv;
                boolean bl = false;
                PsiElement psiElement2 = it.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFirstChild(...)");
                if (!this.calculatedClassNameMatches(psiElement2, currentLocationClassName, true)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunction getAppropriateLiteralForCrossinlineLambda(KtAnalysisSession $context_receiver_0, List<? extends KtFunction> $this$getAppropriateLiteralForCrossinlineLambda, String currentLocationClassName) {
        void $this$descendantsOfType_u24default$iv;
        String $this$filterTo$iv$iv;
        if ($this$getAppropriateLiteralForCrossinlineLambda.isEmpty()) {
            return null;
        }
        String crossinlineLambdaPrefix = "$$inlined$";
        if (!StringsKt.contains$default((CharSequence)currentLocationClassName, (CharSequence)crossinlineLambdaPrefix, (boolean)false, (int)2, null)) {
            return null;
        }
        if ($this$getAppropriateLiteralForCrossinlineLambda.size() == 1) {
            return (KtFunction)CollectionsKt.first($this$getAppropriateLiteralForCrossinlineLambda);
        }
        Iterable $this$filter$iv = $this$getAppropriateLiteralForCrossinlineLambda;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            String string;
            Object element$iv$iv = iterator2.next();
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl2 = false;
            KtCallExpression ktCallExpression = this.getLambdaCallMethod(it);
            if (ktCallExpression == null || (string = this.getBytecodeMethodName($context_receiver_0, ktCallExpression)) == null) {
                bl = false;
            } else {
                String name2 = string;
                bl = StringsKt.contains$default((CharSequence)currentLocationClassName, (CharSequence)(crossinlineLambdaPrefix + name2 + "$"), (boolean)false, (int)2, null);
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fittingCallMethodName = (List)destination$iv$iv;
        if (fittingCallMethodName.isEmpty()) {
            return null;
        }
        if (fittingCallMethodName.size() == 1) {
            return (KtFunction)CollectionsKt.first((List)fittingCallMethodName);
        }
        KtCallExpression $i$f$filter22 = this.getLambdaCallMethod((KtFunction)CollectionsKt.first((List)fittingCallMethodName));
        if ($i$f$filter22 == null || ($this$filterTo$iv$iv = this.getBytecodeMethodName($context_receiver_0, $i$f$filter22)) == null) {
            return null;
        }
        String callMethodName = $this$filterTo$iv$iv;
        PsiElement psiElement2 = KotlinPositionManagerKt.getContainingMethod$default((PsiElement)CollectionsKt.first((List)fittingCallMethodName), false, 1, null);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement containingMethod = psiElement2;
        destination$iv$iv = containingMethod;
        boolean childrenFirst$iv = false;
        boolean $i$f$descendantsOfType = false;
        Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)getAppropriateLiteralForCrossinlineLambda$$inlined$descendantsOfType$default$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List allLambdasInMethod2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)getAppropriateLiteralForCrossinlineLambda.allLambdasInMethod.1.INSTANCE), (Function1)((Function1)new Function1<KtFunction, Boolean>(this, $context_receiver_0, callMethodName){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ KtAnalysisSession $$context_receiver_0;
            final /* synthetic */ String $callMethodName;
            {
                this.this$0 = $receiver;
                this.$$context_receiver_0 = $$context_receiver_0;
                this.$callMethodName = $callMethodName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KtCallExpression ktCallExpression = KotlinPositionManager.access$getLambdaCallMethod(this.this$0, it);
                return Intrinsics.areEqual(ktCallExpression != null ? KotlinPositionManager.access$getBytecodeMethodName(this.this$0, ktCallExpression, this.$$context_receiver_0) : null, (Object)this.$callMethodName);
            }
        })));
        List candidatesBySequenceNumber = new ArrayList();
        for (KtFunction call : fittingCallMethodName) {
            int indexInOuterMethod = allLambdasInMethod2.indexOf(call);
            String candidateName = crossinlineLambdaPrefix + callMethodName + "$" + (indexInOuterMethod + 1);
            if (!StringsKt.contains$default((CharSequence)currentLocationClassName, (CharSequence)candidateName, (boolean)false, (int)2, null)) continue;
            candidatesBySequenceNumber.add(call);
        }
        return (KtFunction)CollectionsKt.singleOrNull((List)candidatesBySequenceNumber);
    }

    private final KtCallExpression getLambdaCallMethod(KtFunction $this$getLambdaCallMethod) {
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)$this$getLambdaCallMethod;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtCallExpression.class, (boolean)true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final String getBytecodeMethodName(KtAnalysisSession $context_receiver_0, KtCallExpression $this$getBytecodeMethodName) {
        Iterable jvmName;
        Iterable iterable;
        KtFunctionSymbol symbol2;
        block14: {
            String string;
            void $this$filterTo$iv$iv;
            KtLifetimeOwner ktLifetimeOwner = $context_receiver_0.resolveCall((KtElement)$this$getBytecodeMethodName);
            if (ktLifetimeOwner == null || (ktLifetimeOwner = KtCallKt.successfulFunctionCallOrNull((KtCallInfo)ktLifetimeOwner)) == null) {
                return null;
            }
            KtLifetimeOwner resolvedCall2 = ktLifetimeOwner;
            Object s = KtCallKt.getSymbol(((KtCallableMemberCall)resolvedCall2).getPartiallyAppliedSymbol());
            boolean $i$f$asSafely = false;
            Object s2 = s;
            if (!(s2 instanceof KtFunctionSymbol)) {
                s2 = null;
            }
            KtFunctionSymbol ktFunctionSymbol = (KtFunctionSymbol)s2;
            if (ktFunctionSymbol == null) {
                return null;
            }
            symbol2 = ktFunctionSymbol;
            Iterable iterable2 = KtAnnotatedKt.getAnnotations(symbol2);
            boolean $i$f$filter = false;
            Iterable iterable3 = iterable2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtAnnotationApplicationWithArgumentsInfo it = (KtAnnotationApplicationWithArgumentsInfo)element$iv$iv;
                boolean bl = false;
                ClassId classId = it.getClassId();
                if (!Intrinsics.areEqual((Object)(classId != null ? classId.asFqNameString() : null), (Object)"kotlin.jvm.JvmName")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator iterator2 = ((Iterable)((List)destination$iv$iv)).iterator();
            do {
                KtAnnotationValue ktAnnotationValue;
                Object v5;
                block15: {
                    if (!iterator2.hasNext()) {
                        iterable = null;
                        break block14;
                    }
                    KtAnnotationApplicationWithArgumentsInfo it = (KtAnnotationApplicationWithArgumentsInfo)iterator2.next();
                    boolean bl = false;
                    Iterable $this$singleOrNull$iv = it.getArguments();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        KtNamedAnnotationValue a = (KtNamedAnnotationValue)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)a.getName().asString(), (Object)"name")) continue;
                        if (found$iv) {
                            v5 = null;
                            break block15;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v5 = !found$iv ? null : single$iv;
                }
                KtNamedAnnotationValue ktNamedAnnotationValue = v5;
                if (ktNamedAnnotationValue != null && (ktAnnotationValue = ktNamedAnnotationValue.getExpression()) != null) {
                    KtConstantValue ktConstantValue;
                    KtConstantAnnotationValue ktConstantAnnotationValue;
                    KtAnnotationValue $this$asSafely$iv = ktAnnotationValue;
                    boolean $i$f$asSafely2 = false;
                    KtAnnotationValue ktAnnotationValue2 = $this$asSafely$iv;
                    if (!(ktAnnotationValue2 instanceof KtConstantAnnotationValue)) {
                        ktAnnotationValue2 = null;
                    }
                    if ((ktConstantAnnotationValue = (KtConstantAnnotationValue)ktAnnotationValue2) != null && (ktConstantValue = ktConstantAnnotationValue.getConstantValue()) != null) {
                        KtConstantValue.KtStringConstantValue ktStringConstantValue;
                        KtConstantValue $this$asSafely$iv2 = ktConstantValue;
                        boolean $i$f$asSafely3 = false;
                        KtConstantValue ktConstantValue2 = $this$asSafely$iv2;
                        if (!(ktConstantValue2 instanceof KtConstantValue.KtStringConstantValue)) {
                            ktConstantValue2 = null;
                        }
                        if ((ktStringConstantValue = (KtConstantValue.KtStringConstantValue)ktConstantValue2) != null) {
                            string = ktStringConstantValue.getValue();
                            continue;
                        }
                    }
                }
                string = null;
            } while ((iterable3 = string) == null);
            iterable = iterable3;
        }
        Iterable iterable4 = jvmName = iterable;
        if (iterable4 != null) {
            return iterable4;
        }
        return symbol2.getName().getIdentifier();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean calculatedClassNameMatches(PsiElement $this$calculatedClassNameMatches, String currentLocationClassName, boolean isLambda) {
        boolean bl;
        block6: {
            void $this$any$iv;
            List list2;
            Project project2 = this.debugProcess.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
            ClassNameProvider classNameProvider = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.copy$default(ClassNameProvider.Configuration.Companion.getDEFAULT(), false, false, 1, null));
            List $this$calculatedClassNameMatches_u24lambda_u2416 = classNameProvider.getCandidatesForElement($this$calculatedClassNameMatches);
            boolean bl2 = false;
            if (isLambda) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = $this$calculatedClassNameMatches_u24lambda_u2416;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String p0 = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (!this.isNestedClassName(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = $this$calculatedClassNameMatches_u24lambda_u2416;
            }
            Iterable iterable = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isNestedClassName(String name2) {
        return StringsKt.contains$default((CharSequence)name2, (CharSequence)"$", (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtFunction getAppropriateLiteralBasedOnLambdaName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnLambdaName, Location location, int lineNumber) {
        v0 = SafeUtilKt.safeMethod(location);
        if (v0 == null) {
            return null;
        }
        method = v0;
        v1 = method.name();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"name(...)");
        if (!DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(v1)) {
            return null;
        }
        v2 = location.declaringType().methods();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"methods(...)");
        var6_5 = v2;
        $i$f$filter = false;
        var8_8 = $this$filter$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Method)element$iv$iv;
            $i$a$-filter-KotlinPositionManager$getAppropriateLiteralBasedOnLambdaName$lambdas$1 = false;
            v3 = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"name(...)");
            if (!DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(v3)) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)it);
            if (KotlinPositionManagerKt.isGeneratedErasedLambdaMethod(it)) ** GOTO lbl-1000
            v4 = DebuggerUtilsEx.locationsOfLine((Method)it, (int)(lineNumber + 1));
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"locationsOfLine(...)");
            if (((Collection)v4).isEmpty() == false) {
                v5 = true;
            } else lbl-1000:
            // 3 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv /* !! */ .add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv /* !! */ ;
        $i$f$sortedBy = false;
        lambdas = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b2) {
                Method it = (Method)a;
                boolean bl = false;
                String string = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                it = (Method)b2;
                Comparable comparable = new IrLambdaDescriptor(string);
                bl = false;
                String string2 = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)new IrLambdaDescriptor(string2));
            }
        });
        $this$filter$iv = $this$getAppropriateLiteralBasedOnLambdaName;
        $i$f$filter = false;
        destination$iv$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtFunction)element$iv$iv;
            $i$a$-filter-KotlinPositionManager$getAppropriateLiteralBasedOnLambdaName$suitableFunLiterals$1 = false;
            if (!this.hasExecutableCodeInsideOnLine(it, lineNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        suitableFunLiterals = (List)destination$iv$iv;
        if (lambdas.size() == suitableFunLiterals.size()) {
            return (KtFunction)suitableFunLiterals.get(lambdas.indexOf(method));
        }
        return this.getSamLambdaWithIndex(suitableFunLiterals, lambdas.indexOf(method));
    }

    private final boolean hasExecutableCodeInsideOnLine(KtFunction $this$hasExecutableCodeInsideOnLine, int lineNumber) {
        VirtualFile file2 = $this$hasExecutableCodeInsideOnLine.getContainingFile().getVirtualFile();
        KtElement ktElement = (KtElement)$this$hasExecutableCodeInsideOnLine;
        Intrinsics.checkNotNull((Object)file2);
        Project project2 = $this$hasExecutableCodeInsideOnLine.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return BreakpointTypeUtilsKt.hasExecutableCodeInsideOnLine(ktElement, file2, lineNumber, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)new Function1<PsiElement, ApplicabilityResult>(file2, lineNumber){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ int $lineNumber;
            {
                this.$file = $file;
                this.$lineNumber = $lineNumber;
                super(1);
            }

            @NotNull
            public final ApplicabilityResult invoke(@NotNull PsiElement element3) {
                ApplicabilityResult applicabilityResult;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement psiElement2 = element3;
                if (psiElement2 instanceof KtNamedFunction) {
                    applicabilityResult = ApplicabilityResult.UNKNOWN;
                } else if (psiElement2 instanceof KtElement) {
                    VirtualFile virtualFile2 = this.$file;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"$file");
                    LineBreakpointExpressionVisitor visitor2 = LineBreakpointExpressionVisitor.Companion.of(virtualFile2, this.$lineNumber);
                    applicabilityResult = visitor2 != null ? (ApplicabilityResult)((KtElement)element3).accept((KtVisitor)visitor2, null) : ApplicabilityResult.UNKNOWN;
                } else {
                    applicabilityResult = ApplicabilityResult.UNKNOWN;
                }
                return applicabilityResult;
            }
        })) || this.hasImplicitReturnOnLine($this$hasExecutableCodeInsideOnLine, lineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean hasImplicitReturnOnLine(KtFunction function2, int lineNumber) {
        boolean bl;
        void this_$iv$iv$iv;
        void this_$iv$iv;
        if (!(function2 instanceof KtFunctionLiteral) || PsiLinesUtilsKt.getLineNumber((PsiElement)function2, false) != lineNumber) {
            return false;
        }
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)function2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        void var7_6 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)function2);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$hasImplicitReturnOnLine_u24lambda_u2421 = analysisSession$iv$iv$iv;
            boolean bl2 = false;
            KtType functionalType = $this$hasImplicitReturnOnLine_u24lambda_u2421.getFunctionalType(function2);
            KtType ktType = functionalType instanceof KtFunctionalType ? (KtFunctionalType)functionalType : null;
            bl = ktType != null && (ktType = ktType.getReturnType()) != null ? $this$hasImplicitReturnOnLine_u24lambda_u2421.isUnit(ktType) : false;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
        boolean isUnitReturnType = bl;
        if (!isUnitReturnType) {
            return false;
        }
        return !(this.lastStatementSkippingComments(function2) instanceof KtReturnExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KtElement lastStatementSkippingComments(KtFunction $this$lastStatementSkippingComments) {
        KtBlockExpression ktBlockExpression = $this$lastStatementSkippingComments.getBodyBlockExpression();
        Object object = ktBlockExpression;
        if (ktBlockExpression == null) return null;
        PsiElement $this$childrenOfType$iv = (PsiElement)object;
        boolean $i$f$childrenOfType = false;
        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, KtElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
        object = list2;
        if (list2 == null) return null;
        KtElement ktElement = (KtElement)CollectionsKt.lastOrNull((List)object);
        return ktElement;
    }

    private final KtFunction getSamLambdaWithIndex(List<? extends KtFunction> $this$getSamLambdaWithIndex, int index) {
        int samLambdaCounter = 0;
        for (KtFunction ktFunction : $this$getSamLambdaWithIndex) {
            if (!KotlinPositionManagerKt.access$isSamLambda(ktFunction)) continue;
            if (samLambdaCounter == index) {
                return ktFunction;
            }
            ++samLambdaCounter;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location2) {
        String string;
        String string2 = SafeUtilKt.safeSourceName(location2);
        if (string2 == null) {
            return null;
        }
        String sourceName2 = string2;
        try {
            String string3;
            ReferenceType referenceType = location2.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
            if (DebuggerUtil.containsKotlinStrata(referenceType)) {
                String string4 = location2.sourcePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sourcePath(...)");
                string3 = StringsKt.replace$default((String)string4, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            } else {
                string3 = this.defaultInternalName(location2);
            }
            string = string3;
        }
        catch (AbsentInformationException e) {
            string = this.defaultInternalName(location2);
        }
        String referenceInternalName = string;
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)referenceInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        JvmClassName className = jvmClassName;
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNull((Object)project2);
        return (PsiFile)DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.sourceSearchScopes, className, sourceName2, location2);
    }

    private final String defaultInternalName(Location location2) {
        String referenceFqName = location2.declaringType().name();
        Intrinsics.checkNotNull((Object)referenceFqName);
        return StringsKt.replace$default((String)referenceFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile2 = sourcePosition2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        PsiFile psiFile3 = psiFile2;
        if (psiFile3 instanceof KtFile) {
            List<ReferenceType> referenceTypesInKtFile;
            List<ReferenceType> list2;
            List<ReferenceType> list3;
            Project project2 = ((KtFile)psiFile3).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            List list4 = (List)KotlinPluginDisposableUtils.syncNonBlockingReadAction(project2, (Function0)new Function0<List<? extends ReferenceType>>(psiFile3, this, sourcePosition2){
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ KotlinPositionManager this$0;
                final /* synthetic */ SourcePosition $sourcePosition;
                {
                    this.$psiFile = $psiFile;
                    this.this$0 = $receiver;
                    this.$sourcePosition = $sourcePosition;
                    super(0);
                }

                @Nullable
                public final List<ReferenceType> invoke() {
                    if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)this.$psiFile)) {
                        return null;
                    }
                    return KotlinPositionManager.access$getReferenceTypesCandidates(this.this$0, this.$sourcePosition);
                }
            });
            if (list4 == null) {
                return CollectionsKt.emptyList();
            }
            List candidates2 = list4;
            Collection $this$ifNotEmpty$iv = candidates2;
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                List $this$getAllClasses_u24lambda_u2422 = (List)$this$ifNotEmpty$iv;
                boolean bl = false;
                list3 = this.findTargetClasses($this$getAllClasses_u24lambda_u2422, sourcePosition2);
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = referenceTypesInKtFile = CollectionsKt.emptyList();
            }
            if (ComposeUtilsKt.isInsideProjectWithCompose(sourcePosition2)) {
                return CollectionsKt.plus((Collection)referenceTypesInKtFile, (Iterable)ComposeUtilsKt.getComposableSingletonsClasses(this.debugProcess, (KtFile)psiFile3));
            }
            return referenceTypesInKtFile;
        }
        if (psiFile3 instanceof ClsFileImpl) {
            Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(psiFile3){
                final /* synthetic */ PsiFile $psiFile;
                {
                    this.$psiFile = $psiFile;
                    super(0);
                }

                @NotNull
                public final PsiFile invoke() {
                    return ((ClsFileImpl)this.$psiFile).getDecompiledPsiFile();
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            PsiFile decompiledPsiFile2 = (PsiFile)object;
            if (decompiledPsiFile2 instanceof KtClsFile && ((Number)ActionsKt.runReadAction((Function0)((Function0)new Function0<Integer>(sourcePosition2){
                final /* synthetic */ SourcePosition $sourcePosition;
                {
                    this.$sourcePosition = $sourcePosition;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    return this.$sourcePosition.getLine();
                }
            }))).intValue() == -1) {
                String className = JvmFileClassUtil.getFileClassInternalName((KtFile)((KtFile)decompiledPsiFile2));
                List list5 = this.debugProcess.getVirtualMachineProxy().classesByName(className);
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"classesByName(...)");
                return list5;
            }
        }
        NoDataException noDataException = NoDataException.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
        throw (Throwable)noDataException;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final List<ReferenceType> getReferenceTypesCandidates(SourcePosition sourcePosition2) {
        void $this$flatMapTo$iv$iv;
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
        ClassNameProvider classNameProvider = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.Companion.getDEFAULT());
        Iterable $this$flatMap$iv = classNameProvider.getCandidates(sourcePosition2);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String className = (String)element$iv$iv;
            boolean bl = false;
            List list2 = this.debugProcess.getVirtualMachineProxy().classesByName(className);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classesByName(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLockAbsence
    private final List<ReferenceType> findTargetClasses(List<? extends ReferenceType> candidates2, SourcePosition sourcePosition2) {
        try {
            List<? extends ReferenceType> list2;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Collection<ReferenceType> collection = candidates2;
            boolean $i$f$flatMap = false;
            void var6_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ReferenceType referenceType = (ReferenceType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = KotlinPositionManagerKt.access$findTargetClasses(this.debugProcess, referenceType, sourcePosition2.getLine());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List matchingCandidates = (List)destination$iv$iv;
            collection = matchingCandidates;
            if (collection.isEmpty()) {
                boolean bl = false;
                list2 = candidates2;
            } else {
                list2 = collection;
            }
            return list2;
        }
        catch (IncompatibleThreadStateException e) {
            return CollectionsKt.emptyList();
        }
        catch (VMDisconnectedException e) {
            return CollectionsKt.emptyList();
        }
    }

    @Deprecated(message="Use 'ClassNameProvider' directly")
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final List<String> originalClassNamesForPosition(@NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends String>>(this, position){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ SourcePosition $position;
            {
                this.this$0 = $receiver;
                this.$position = $position;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                Project project2 = KotlinPositionManager.access$getDebugProcess$p(this.this$0).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getDebugProcess$p(this.this$0).getSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
                ClassNameProvider classNameProvider = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.copy$default(ClassNameProvider.Configuration.Companion.getDEFAULT(), false, false, 2, null));
                return classNameProvider.getCandidates(this.$position);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        try {
            void $this$filterTo$iv$iv;
            int line;
            List locations;
            Collection collection;
            if (DexDebugFacility.INSTANCE.isDex(this.debugProcess)) {
                List inlineLocations2;
                VirtualMachineProxy virtualMachineProxy = this.debugProcess.getVirtualMachineProxy();
                VirtualMachineProxyImpl virtualMachineProxyImpl = virtualMachineProxy instanceof VirtualMachineProxyImpl ? (VirtualMachineProxyImpl)virtualMachineProxy : null;
                if (!(virtualMachineProxyImpl != null ? virtualMachineProxyImpl.canGetSourceDebugExtension() : false) && !((Collection)(inlineLocations2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends Location>>(type2, position, this){
                    final /* synthetic */ ReferenceType $type;
                    final /* synthetic */ SourcePosition $position;
                    final /* synthetic */ KotlinPositionManager this$0;
                    {
                        this.$type = $type;
                        this.$position = $position;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final List<Location> invoke() {
                        GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getDebugProcess$p(this.this$0).getSearchScope();
                        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
                        return DebuggerUtils.INSTANCE.getLocationsOfInlinedLine(this.$type, this.$position, globalSearchScope);
                    }
                })))).isEmpty()) {
                    return inlineLocations2;
                }
            }
            if ((collection = (Collection)(locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (String)"Kotlin", null, (int)(line = position.getLine() + 1)))) == null || collection.isEmpty()) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
                throw (Throwable)noDataException;
            }
            Intrinsics.checkNotNull((Object)locations);
            Iterable $this$filter$iv = locations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Location it = (Location)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.sourceName("Kotlin"), (Object)position.getFile().getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun", replaceWith=@ReplaceWith(expression="createPrepareRequests(classPrepareRequestor, sourcePosition).firstOrNull()", imports={}))
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition2));
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        DebugProcessImpl debugProcessImpl;
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        PsiFile psiFile2 = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        PsiFile file2 = psiFile2;
        if (!(file2 instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        boolean isInsideProjectWithCompose = ComposeUtilsKt.isInsideProjectWithCompose(position);
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> KotlinPositionManager.createPrepareRequests$lambda$27(this, requestor, position, isInsideProjectWithCompose, file2)).inSmartMode(this.debugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"inSmartMode(...)");
        NonBlockingReadAction nonBlocking2 = nonBlockingReadAction;
        ClassPrepareRequestor $this$safeAs$iv = requestor;
        boolean $i$f$safeAs = false;
        ClassPrepareRequestor classPrepareRequestor = $this$safeAs$iv;
        if (!(classPrepareRequestor instanceof Breakpoint)) {
            classPrepareRequestor = null;
        }
        Breakpoint breakpoint2 = (Breakpoint)classPrepareRequestor;
        XBreakpoint xBreakpoint = breakpoint2 != null ? breakpoint2.getXBreakpoint() : null;
        DebugProcess $this$asSafely$iv = this.debugProcess;
        boolean $i$f$asSafely = false;
        DebugProcess debugProcess = $this$asSafely$iv;
        if (!(debugProcess instanceof DebugProcessImpl)) {
            debugProcess = null;
        }
        XDebugSession $this$asSafely$iv2 = (debugProcessImpl = (DebugProcessImpl)debugProcess) != null && (debugProcessImpl = debugProcessImpl.getXdebugProcess()) != null ? debugProcessImpl.getSession() : null;
        boolean $i$f$asSafely2 = false;
        XDebugSession xDebugSession = $this$asSafely$iv2;
        if (!(xDebugSession instanceof XDebugSessionImpl)) {
            xDebugSession = null;
        }
        XDebugSessionImpl xSession = (XDebugSessionImpl)xDebugSession;
        if (xBreakpoint != null && xSession != null) {
            NonBlockingReadAction nonBlockingReadAction2 = nonBlocking2.expireWhen(() -> KotlinPositionManager.createPrepareRequests$lambda$28(xSession, xBreakpoint));
            Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction2, (String)"expireWhen(...)");
            nonBlocking2 = nonBlockingReadAction2;
        }
        try {
            Object object = nonBlocking2.executeSynchronously();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
            return (List)object;
        }
        catch (ProcessCanceledException processCanceledException) {
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final List<ClassPrepareRequest> createKotlinClassPrepareRequests(ClassPrepareRequestor requestor, SourcePosition position) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        SourcePosition refinedPosition = requestor instanceof SourcePositionRefiner ? ((SourcePositionRefiner)requestor).refineSourcePosition(position) : position;
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
        Iterable iterable = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.Companion.getDEFAULT()).getCandidates(refinedPosition);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String name2 = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new ClassPrepareRequest[]{this.debugProcess.getRequestsManager().createClassPrepareRequest(requestor, name2), this.debugProcess.getRequestsManager().createClassPrepareRequest(requestor, name2 + "$*")};
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List createPrepareRequests$lambda$27(KotlinPositionManager this$0, ClassPrepareRequestor $requestor, SourcePosition $position, boolean $isInsideProjectWithCompose, PsiFile $file) {
        ClassPrepareRequest singletonRequest;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$requestor, (String)"$requestor");
        Intrinsics.checkNotNullParameter((Object)$position, (String)"$position");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        List kotlinRequests = this$0.createKotlinClassPrepareRequests($requestor, $position);
        return $isInsideProjectWithCompose ? ((singletonRequest = ComposeUtilsKt.getClassPrepareRequestForComposableSingletons(this$0.debugProcess, $requestor, (KtFile)$file)) == null ? kotlinRequests : CollectionsKt.plus((Collection)kotlinRequests, (Object)singletonRequest)) : kotlinRequests;
    }

    private static final boolean createPrepareRequests$lambda$28(XDebugSessionImpl $xSession, XBreakpoint $xBreakpoint) {
        return !$xSession.isBreakpointActive($xBreakpoint);
    }

    public static final /* synthetic */ KtCallExpression access$getLambdaCallMethod(KotlinPositionManager $this, KtFunction $receiver) {
        return $this.getLambdaCallMethod($receiver);
    }

    public static final /* synthetic */ String access$getBytecodeMethodName(KotlinPositionManager $this, KtCallExpression $receiver, KtAnalysisSession $context_receiver_0) {
        return $this.getBytecodeMethodName($context_receiver_0, $receiver);
    }

    public static final /* synthetic */ List access$getReferenceTypesCandidates(KotlinPositionManager $this, SourcePosition sourcePosition2) {
        return $this.getReferenceTypesCandidates(sourcePosition2);
    }

    public static final /* synthetic */ DebugProcess access$getDebugProcess$p(KotlinPositionManager $this) {
        return $this.debugProcess;
    }
}

