/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.KotlinAlternativeSourceNotificationProvider;
import org.jetbrains.kotlin.idea.debugger.core.KotlinAlternativeSourceNotificationProviderKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0005\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "AlternativeSourceNotificationPanel", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinAlternativeSourceNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAlternativeSourceNotificationProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n766#2:173\n857#2,2:174\n*S KotlinDebug\n*F\n+ 1 KotlinAlternativeSourceNotificationProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider\n*L\n67#1:173\n67#1:174,2\n*E\n"})
public final class KotlinAlternativeSourceNotificationProvider
implements EditorNotificationProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
        Location location2;
        Comparable<Location> comparable;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        XSourcePosition position;
        XDebugSession session2;
        DebuggerSession javaSession;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        DebuggerSession debuggerSession = javaSession = DebuggerManagerEx.getInstanceEx((Project)project2).getContext().getDebuggerSession();
        Object object = session2 = debuggerSession != null ? debuggerSession.getXDebugSession() : null;
        if (session2 == null) {
            AlternativeSourceNotificationProvider.setFileProcessed((VirtualFile)file2, (boolean)false);
            return null;
        }
        XSourcePosition xSourcePosition = position = session2.getCurrentPosition();
        if (!Intrinsics.areEqual((Object)file2, (Object)(xSourcePosition != null ? xSourcePosition.getFile() : null))) {
            AlternativeSourceNotificationProvider.setFileProcessed((VirtualFile)file2, (boolean)false);
            return null;
        }
        if (DumbService.Companion.getInstance(project2).isDumb()) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        Set alternativeKtFiles = KotlinAlternativeSourceNotificationProviderKt.access$findAlternativeKtFiles(ktFile2, project2, javaSession);
        AlternativeSourceNotificationProvider.setFileProcessed((VirtualFile)file2, (boolean)true);
        if (alternativeKtFiles.size() <= 1) {
            return null;
        }
        Iterable iterable = alternativeKtFiles;
        Collection collection = CollectionsKt.listOf((Object)ktFile2);
        boolean $i$f$filter = false;
        void var11_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)ktFile2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection currentFirstAlternatives = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        XStackFrame frame = session2.getCurrentStackFrame();
        String locationDeclName = frame instanceof JavaStackFrame ? ((comparable = (location2 = ((JavaStackFrame)frame).getDescriptor().getLocation())) != null && (comparable = comparable.declaringType()) != null ? comparable.name() : null) : null;
        return arg_0 -> KotlinAlternativeSourceNotificationProvider.collectNotificationData$lambda$1(project2, currentFirstAlternatives, file2, locationDeclName, arg_0);
    }

    private static final AlternativeSourceNotificationPanel collectNotificationData$lambda$1(Project $project, Collection $currentFirstAlternatives, VirtualFile $file, String $locationDeclName, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$currentFirstAlternatives, (String)"$currentFirstAlternatives");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new AlternativeSourceNotificationPanel(it, $project, $currentFirstAlternatives, $file, $locationDeclName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel;", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "alternatives", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "locationDeclName", "", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "ComboBoxFileElement", "kotlin.jvm-debugger.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinAlternativeSourceNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAlternativeSourceNotificationProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,172:1\n1549#2:173\n1620#2,3:174\n37#3,2:177\n*S KotlinDebug\n*F\n+ 1 KotlinAlternativeSourceNotificationProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel\n*L\n101#1:173\n101#1:174,3\n103#1:177,2\n*E\n"})
    private static final class AlternativeSourceNotificationPanel
    extends EditorNotificationPanel {
        /*
         * WARNING - void declaration
         */
        public AlternativeSourceNotificationPanel(@NotNull FileEditor fileEditor, @NotNull Project project2, @NotNull Collection<? extends KtFile> alternatives, @NotNull VirtualFile file2, @Nullable String locationDeclName) {
            void $this$_init__u24lambda_u242;
            ComboBox comboBox2;
            Object object;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(alternatives, (String)"alternatives");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super(fileEditor, EditorNotificationPanel.Status.Info);
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)file2.getName(), (String)"getName(...)");
            this.setText(KotlinDebuggerCoreBundle.message("alternative.sources.notification.title", objectArray));
            Iterable $this$map$iv = alternatives;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(new ComboBoxFileElement((KtFile)it));
            }
            List items = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = items;
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ComboBox $i$f$toTypedArray22 = comboBox2 = new ComboBox((Object[])thisCollection$iv.toArray(new ComboBoxFileElement[0]));
            object = this.myLinksPanel;
            boolean bl = false;
            $this$_init__u24lambda_u242.addActionListener(arg_0 -> AlternativeSourceNotificationPanel.lambda$2$lambda$1(project2, (ComboBox)$this$_init__u24lambda_u242, file2, locationDeclName, arg_0));
            ((Container)object).add((Component)comboBox2);
            this.createActionLabel(KotlinDebuggerCoreBundle.message("alternative.sources.notification.hide", new Object[0]), () -> AlternativeSourceNotificationPanel._init_$lambda$3(file2, project2, this));
        }

        private static final void lambda$2$lambda$1(Project $project, ComboBox $this_apply, VirtualFile $file, String $locationDeclName, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx((Project)$project).getContext();
            Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getContext(...)");
            DebuggerContextImpl context2 = debuggerContextImpl;
            DebuggerSession session2 = context2.getDebuggerSession();
            Object object = $this_apply.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.debugger.core.KotlinAlternativeSourceNotificationProvider.AlternativeSourceNotificationPanel.ComboBoxFileElement");
            KtFile ktFile = ((ComboBoxFileElement)object).getKtFile();
            VirtualFile vFile = ktFile.getContainingFile().getVirtualFile();
            if (session2 != null && vFile != null) {
                session2.getProcess().getManagerThread().schedule(new DebuggerCommandImpl($locationDeclName, vFile, $project, $file, session2){
                    final /* synthetic */ String $locationDeclName;
                    final /* synthetic */ VirtualFile $vFile;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ DebuggerSession $session;
                    {
                        this.$locationDeclName = $locationDeclName;
                        this.$vFile = $vFile;
                        this.$project = $project;
                        this.$file = $file;
                        this.$session = $session;
                    }

                    protected void action() {
                        if (!StringUtil.isEmpty((String)this.$locationDeclName)) {
                            DebuggerUtilsEx.setAlternativeSourceUrl((String)this.$locationDeclName, (String)this.$vFile.getUrl(), (Project)this.$project);
                        }
                        DebuggerUIUtil.invokeLater(() -> 1.1.1.action$lambda$0(this.$project, this.$file, this.$session));
                    }

                    private static final void action$lambda$0(Project $project, VirtualFile $file, DebuggerSession $session) {
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                        FileEditorManager.getInstance((Project)$project).closeFile($file);
                        $session.refresh(true);
                    }
                });
            } else {
                FileEditorManager.getInstance((Project)$project).closeFile($file);
                ktFile.navigate(true);
            }
        }

        private static final void _init_$lambda$3(VirtualFile $file, Project $project, AlternativeSourceNotificationPanel this$0) {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE = false;
            AlternativeSourceNotificationProvider.setFileProcessed((VirtualFile)$file, (boolean)false);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
            FileEditor editor2 = fileEditorManager.getSelectedEditor($file);
            if (editor2 != null) {
                fileEditorManager.removeTopComponent(editor2, (JComponent)((Object)this$0));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel$ComboBoxFileElement;", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "label", "", "getLabel", "()Ljava/lang/String;", "label$delegate", "Lkotlin/Lazy;", "toString", "kotlin.jvm-debugger.core"})
        private static final class ComboBoxFileElement {
            @NotNull
            private final KtFile ktFile;
            @NotNull
            private final Lazy label$delegate;

            public ComboBoxFileElement(@NotNull KtFile ktFile) {
                Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
                this.ktFile = ktFile;
                this.label$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ComboBoxFileElement this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        ModuleRendererFactory moduleRendererFactory = ModuleRendererFactory.findInstance((Object)this.this$0.getKtFile());
                        Intrinsics.checkNotNullExpressionValue((Object)moduleRendererFactory, (String)"findInstance(...)");
                        ModuleRendererFactory factory2 = moduleRendererFactory;
                        Object object = factory2.getModuleTextWithIcon((Object)this.this$0.getKtFile());
                        if (object == null || (object = object.getText()) == null) {
                            object = "";
                        }
                        return object;
                    }
                }));
            }

            @NotNull
            public final KtFile getKtFile() {
                return this.ktFile;
            }

            private final String getLabel() {
                Lazy lazy = this.label$delegate;
                return (String)lazy.getValue();
            }

            @NotNull
            public String toString() {
                return this.getLabel();
            }
        }
    }
}

