/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.VariableWithLocation;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006*\u00020\u000b\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0007H\u0002\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "filterRepeatedVariables", "", "Lcom/sun/jdi/LocalVariable;", "sortedVariables", "sortedVariablesWithLocation", "Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "Lcom/sun/jdi/Method;", "toDebugString", "", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nstackFrameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stackFrameUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/StackFrameUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,140:1\n1603#2,9:141\n1855#2:150\n1856#2:153\n1612#2:154\n1603#2,9:162\n1855#2:171\n1856#2:175\n1612#2:176\n1194#2,2:177\n1222#2,4:179\n1#3:151\n1#3:152\n1#3:174\n372#4,7:155\n215#5,2:172\n*S KotlinDebug\n*F\n+ 1 stackFrameUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/StackFrameUtilsKt\n*L\n59#1:141,9\n59#1:150\n59#1:153\n59#1:154\n98#1:162,9\n98#1:171\n98#1:175\n98#1:176\n132#1:177,2\n132#1:179,4\n59#1:152\n98#1:174\n80#1:155,7\n108#1:172,2\n*E\n"})
public final class StackFrameUtilsKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VariableWithLocation> sortedVariablesWithLocation(@NotNull Method $this$sortedVariablesWithLocation) {
        void $this$mapNotNullTo$iv$iv;
        Object endOffset2;
        Intrinsics.checkNotNullParameter((Object)$this$sortedVariablesWithLocation, (String)"<this>");
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$sortedVariablesWithLocation);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<LocalVariable> allVariables = list2;
        VirtualMachine virtualMachine = $this$sortedVariablesWithLocation.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (!DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv = allVariables;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VariableWithLocation variableWithLocation;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                LocalVariable local = (LocalVariable)element$iv$iv;
                boolean bl2 = false;
                if (DebuggerUtils.INSTANCE.getBorders(local) != null) {
                    ClosedRange<Location> it;
                    boolean bl3 = false;
                    variableWithLocation = new VariableWithLocation(local, (Location)it.getStart());
                } else {
                    variableWithLocation = null;
                }
                if (variableWithLocation == null) continue;
                VariableWithLocation it$iv$iv = variableWithLocation;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }
        Map startOffsets = new LinkedHashMap();
        Map replacements = new LinkedHashMap();
        for (LocalVariable variable2 : allVariables) {
            Object object;
            Iterator $this$getOrPut$iv;
            ClosedRange<Location> borders;
            if (DebuggerUtils.INSTANCE.getBorders(variable2) == null) continue;
            Location startOffset = (Location)borders.getStart();
            String string = variable2.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            if (((CharSequence)string).length() == 0 && startOffset.codeIndex() == 0L && ((Location)borders.getEndInclusive()).codeIndex() == -1L) continue;
            Map $i$f$forEach = startOffsets;
            Long key$iv = startOffset.codeIndex();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(variable2);
        }
        block2: for (LocalVariable variable2 : allVariables) {
            List otherVariables;
            Object object = DebuggerUtils.INSTANCE.getBorders(variable2);
            if (object == null) continue;
            if ((object = (Location)object.getEndInclusive()) == null || (List)startOffsets.get((endOffset2 = object).codeIndex() + 1L) == null) continue;
            for (LocalVariable other2 : otherVariables) {
                if (!Intrinsics.areEqual((Object)variable2.name(), (Object)other2.name()) || !Intrinsics.areEqual((Object)variable2.signature(), (Object)other2.signature()) || Intrinsics.areEqual((Object)variable2, (Object)other2)) continue;
                replacements.put(other2, variable2);
                continue block2;
            }
        }
        Object $this$mapNotNull$iv = allVariables;
        boolean $i$f$mapNotNull = false;
        endOffset2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            VariableWithLocation variableWithLocation;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            LocalVariable variable3 = (LocalVariable)element$iv$iv;
            boolean bl5 = false;
            LocalVariable alias = variable3;
            int i2 = 0;
            while ((LocalVariable)replacements.get(alias) != null) {
                void $this$sortedVariablesWithLocation_u24lambda_u246_u24lambda_u244;
                StringBuilder stringBuilder;
                if (++i2 <= replacements.size()) continue;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                Logger logger = LOG;
                boolean bl6 = false;
                StringBuilder stringBuilder3 = $this$sortedVariablesWithLocation_u24lambda_u246_u24lambda_u244.append("Circular reference detected in " + $this$sortedVariablesWithLocation);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                Map $this$forEach$iv = replacements;
                boolean $i$f$forEach2 = false;
                Iterator iterator4 = $this$forEach$iv.entrySet().iterator();
                while (iterator4.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator4.next();
                    boolean bl7 = false;
                    LocalVariable key = (LocalVariable)entry.getKey();
                    LocalVariable value2 = (LocalVariable)entry.getValue();
                    StringBuilder stringBuilder4 = $this$sortedVariablesWithLocation_u24lambda_u246_u24lambda_u244.append("  (" + StackFrameUtilsKt.toDebugString(key) + ") -> (" + StackFrameUtilsKt.toDebugString(value2) + ")");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                logger.warn(string);
                break;
            }
            if (!Intrinsics.areEqual((Object)variable3, (Object)alias)) {
                replacements.put(variable3, alias);
            }
            if (DebuggerUtils.INSTANCE.getBorders(alias) != null) {
                ClosedRange<Location> it;
                boolean bl8 = false;
                variableWithLocation = new VariableWithLocation(variable3, (Location)it.getStart());
            } else {
                variableWithLocation = null;
            }
            if (variableWithLocation == null) continue;
            VariableWithLocation it$iv$iv = variableWithLocation;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LocalVariable> filterRepeatedVariables(@NotNull List<? extends LocalVariable> sortedVariables) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(sortedVariables, (String)"sortedVariables");
        Iterable $this$associateBy$iv = sortedVariables;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LocalVariable localVariable = (LocalVariable)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.name(), element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }

    private static final String toDebugString(LocalVariable $this$toDebugString) {
        LongRange longRange;
        ClosedRange<Location> closedRange = DebuggerUtils.INSTANCE.getBorders($this$toDebugString);
        if (closedRange != null) {
            ClosedRange<Location> it = closedRange;
            boolean bl = false;
            longRange = new LongRange(((Location)it.getStart()).codeIndex(), ((Location)it.getEndInclusive()).codeIndex());
        } else {
            longRange = null;
        }
        LongRange scope2 = longRange;
        return "name='" + $this$toDebugString.name() + "' type=" + $this$toDebugString.typeName() + " scope=" + scope2;
    }

    static {
        Logger logger = Logger.getInstance((String)"org.jetbrains.kotlin.idea.debugger.core.stackFrameUtils.kt");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

