/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/LocationCache;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "createLocation", "Lcom/sun/jdi/Location;", "type", "Lcom/sun/jdi/ReferenceType;", "methodName", "", "line", "", "stackTraceElement", "Ljava/lang/StackTraceElement;", "kotlin.jvm-debugger.coroutines"})
public final class LocationCache {
    @NotNull
    private final DefaultExecutionContext context;

    public LocationCache(@NotNull DefaultExecutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final DefaultExecutionContext getContext() {
        return this.context;
    }

    @NotNull
    public final Location createLocation(@NotNull StackTraceElement stackTraceElement) {
        Intrinsics.checkNotNullParameter((Object)stackTraceElement, (String)"stackTraceElement");
        String className = stackTraceElement.getClassName();
        List list2 = this.context.getClassesCache().get(className);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"get(...)");
        ReferenceType referenceType = (ReferenceType)CollectionsKt.firstOrNull((List)list2);
        if (referenceType == null) {
            throw new IllegalStateException(("Unable to find loaded class " + className).toString());
        }
        ReferenceType type2 = referenceType;
        String string = stackTraceElement.getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodName(...)");
        return this.createLocation(type2, string, stackTraceElement.getLineNumber());
    }

    @NotNull
    public final Location createLocation(@NotNull ReferenceType type2, @NotNull String methodName, int line) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        if (line >= 0) {
            try {
                Location location2 = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, null, null, (int)line).stream().filter(arg_0 -> LocationCache.createLocation$lambda$0((Function1)new Function1<Location, Boolean>(methodName){
                    final /* synthetic */ String $methodName;
                    {
                        this.$methodName = $methodName;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Location l) {
                        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                        return Intrinsics.areEqual((Object)l.method().name(), (Object)this.$methodName);
                    }
                }, arg_0)).findFirst().orElse(null);
                if (location2 != null) {
                    return location2;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return (Location)new GeneratedLocation(type2, methodName, line);
    }

    private static final boolean createLocation$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

