/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.util;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.XSourcePosition;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.JdiTypeUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0007\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u000b\u001a\u0012\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0006*\u00020\u0010\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0010\u001a\u0012\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0006*\u00020\u0010\u001a\u0019\u0010\u0016\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0019\u001a\n\u0010\u001e\u001a\u00020\t*\u00020\u001f\u001a+\u0010 \u001a\u0004\u0018\u0001H!\"\b\b\u0000\u0010!*\u00020\"*\u00020\u000b2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H!0$\u00a2\u0006\u0002\u0010%\u001a\n\u0010&\u001a\u00020\t*\u00020'\u001a\n\u0010(\u001a\u00020\t*\u00020'\u001a\n\u0010)\u001a\u00020\t*\u00020\u0012\u001a\n\u0010*\u001a\u00020\t*\u00020'\u001a\n\u0010+\u001a\u00020\t*\u00020,\u001a\u0014\u0010-\u001a\u00020\t*\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010\u0019\u001a\u0014\u0010/\u001a\u00020\t*\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010\u0019\u001a\n\u00100\u001a\u00020\t*\u00020\u0019\u001a\f\u00101\u001a\u00020\t*\u00020\u001fH\u0002\u001a\n\u00102\u001a\u00020\t*\u00020\u001f\u001a\n\u00103\u001a\u00020\t*\u00020\u0019\u001a\n\u00103\u001a\u00020\t*\u00020\u001f\u001a\n\u00104\u001a\u00020\t*\u00020\u0019\u001a\u0012\u00105\u001a\u00020\t*\u00020'2\u0006\u00106\u001a\u00020\u0001\u001a\n\u00107\u001a\u00020\t*\u00020\u001f\u001a\n\u00107\u001a\u00020\t*\u00020\u0012\u001a\n\u00108\u001a\u00020\t*\u00020\u0019\u001a\u0014\u00109\u001a\u00020\t*\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010\u0019\u001a\n\u0010:\u001a\u00020\t*\u00020\u000b\u001a\n\u0010:\u001a\u00020\t*\u00020;\u001a\f\u0010<\u001a\u0004\u0018\u00010\u000e*\u00020\u0007\u001a\u0014\u0010=\u001a\u0004\u0018\u00010\u000e*\u00020\u00072\u0006\u0010>\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"CREATION_CLASS_NAME", "", "CREATION_STACK_TRACE_SEPARATOR", "hasGetCoroutineSuspended", "", "frames", "", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "threadAndContextSupportsEvaluation", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "frameProxy", "continuationVariableValue", "Lcom/sun/jdi/ObjectReference;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "findCancellableContinuationImplReferenceType", "Lcom/sun/jdi/ReferenceType;", "findCoroutineMetadataType", "Lcom/sun/jdi/ClassType;", "findDispatchedContinuationReferenceType", "findPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/sun/jdi/Location;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getSuspendExitMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendExitMode;", "hasContinuationParameter", "Lcom/sun/jdi/Method;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function0;", "(Lcom/intellij/debugger/engine/SuspendContextImpl;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isAbstractCoroutine", "Lcom/sun/jdi/Type;", "isBaseContinuationImpl", "isContinuation", "isCoroutineScope", "isCreationSeparatorFrame", "Ljava/lang/StackTraceElement;", "isFilterFromBottom", "location", "isFilterFromTop", "isFilteredInvokeSuspend", "isGetCoroutineSuspended", "isInvoke", "isInvokeSuspend", "isInvokeSuspendWithNegativeLineNumber", "isSubTypeOrSame", "className", "isSuspendLambda", "safeCoroutineExitPointLineNumber", "sameLineAndMethod", "supportsEvaluation", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "thisVariableValue", "variableValue", "variableName", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineUtils.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineUtilsKt\n+ 2 safeUtil.kt\norg/jetbrains/kotlin/idea/debugger/base/util/SafeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,135:1\n159#2,4:136\n1747#3,3:140\n350#3,7:143\n77#4:150\n*S KotlinDebug\n*F\n+ 1 CoroutineUtils.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineUtilsKt\n*L\n47#1:136,4\n65#1:140,3\n100#1:143,7\n120#1:150\n*E\n"})
public final class CoroutineUtilsKt {
    @NotNull
    public static final String CREATION_STACK_TRACE_SEPARATOR = "\b\b\b";
    @NotNull
    public static final String CREATION_CLASS_NAME = "_COROUTINE._CREATION";

    public static final boolean isInvokeSuspend(@NotNull Method $this$isInvokeSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspend, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isInvokeSuspend.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)$this$isInvokeSuspend.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInvoke(@NotNull Method $this$isInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvoke, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isInvoke.name(), (Object)"invoke")) return false;
        String string = $this$isInvoke.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Ljava/lang/Object;)Ljava/lang/Object;", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuspendLambda(@NotNull Method $this$isSuspendLambda) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendLambda, (String)"<this>");
        if (!CoroutineUtilsKt.isInvokeSuspend($this$isSuspendLambda)) return false;
        ReferenceType referenceType = $this$isSuspendLambda.declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
        if (!CoroutineUtilsKt.isSuspendLambda(referenceType)) return false;
        return true;
    }

    public static final boolean hasContinuationParameter(@NotNull Method $this$hasContinuationParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$hasContinuationParameter, (String)"<this>");
        String string = $this$hasContinuationParameter.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Lkotlin/coroutines/Continuation;)", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final SuspendExitMode getSuspendExitMode(@NotNull Location $this$getSuspendExitMode) {
        Intrinsics.checkNotNullParameter((Object)$this$getSuspendExitMode, (String)"<this>");
        Method method = SafeUtilKt.safeMethod($this$getSuspendExitMode);
        if (method == null) {
            return SuspendExitMode.NONE;
        }
        Method method2 = method;
        if (CoroutineUtilsKt.isSuspendLambda(method2)) {
            return SuspendExitMode.SUSPEND_LAMBDA;
        }
        if (CoroutineUtilsKt.hasContinuationParameter(method2)) {
            return SuspendExitMode.SUSPEND_METHOD_PARAMETER;
        }
        if ((CoroutineUtilsKt.isInvokeSuspend(method2) || CoroutineUtilsKt.isInvoke(method2)) && CoroutineUtilsKt.safeCoroutineExitPointLineNumber($this$getSuspendExitMode)) {
            return SuspendExitMode.SUSPEND_METHOD;
        }
        return SuspendExitMode.NONE;
    }

    public static final boolean safeCoroutineExitPointLineNumber(@NotNull Location $this$safeCoroutineExitPointLineNumber) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$safeCoroutineExitPointLineNumber, (String)"<this>");
        boolean $i$f$wrapIllegalArgumentException = false;
        try {
            boolean bl = false;
            n = DebuggerUtilsEx.getLineNumber((Location)$this$safeCoroutineExitPointLineNumber, (boolean)false);
        }
        catch (IllegalArgumentException e$iv) {
            n = null;
        }
        Integer n2 = n;
        return (n2 != null ? n2 : -2) == -1;
    }

    public static final boolean isContinuation(@NotNull ReferenceType $this$isContinuation) {
        Intrinsics.checkNotNullParameter((Object)$this$isContinuation, (String)"<this>");
        return CoroutineUtilsKt.isBaseContinuationImpl($this$isContinuation) || JdiTypeUtils.isSubtype((Type)$this$isContinuation, "kotlin.coroutines.Continuation");
    }

    public static final boolean isBaseContinuationImpl(@NotNull Type $this$isBaseContinuationImpl) {
        Intrinsics.checkNotNullParameter((Object)$this$isBaseContinuationImpl, (String)"<this>");
        return JdiTypeUtils.isSubtype($this$isBaseContinuationImpl, "kotlin.coroutines.jvm.internal.BaseContinuationImpl");
    }

    public static final boolean isAbstractCoroutine(@NotNull Type $this$isAbstractCoroutine) {
        Intrinsics.checkNotNullParameter((Object)$this$isAbstractCoroutine, (String)"<this>");
        return JdiTypeUtils.isSubtype($this$isAbstractCoroutine, "kotlinx.coroutines.AbstractCoroutine");
    }

    public static final boolean isCoroutineScope(@NotNull Type $this$isCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)$this$isCoroutineScope, (String)"<this>");
        return JdiTypeUtils.isSubtype($this$isCoroutineScope, "kotlinx.coroutines.CoroutineScope");
    }

    public static final boolean isSubTypeOrSame(@NotNull Type $this$isSubTypeOrSame, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubTypeOrSame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return Intrinsics.areEqual((Object)$this$isSubTypeOrSame.name(), (Object)className) || JdiTypeUtils.isSubtype($this$isSubTypeOrSame, className);
    }

    public static final boolean isSuspendLambda(@NotNull ReferenceType $this$isSuspendLambda) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isSuspendLambda, (String)"<this>");
            Iterable $this$any$iv = org.jetbrains.kotlin.idea.debugger.base.util.CoroutineUtilsKt.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!JdiTypeUtils.isSubtype((Type)$this$isSuspendLambda, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isInvokeSuspend(@NotNull Location $this$isInvokeSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspend, (String)"<this>");
        Method method = SafeUtilKt.safeMethod($this$isInvokeSuspend);
        return method != null ? CoroutineUtilsKt.isInvokeSuspend(method) : false;
    }

    public static final boolean isInvokeSuspendWithNegativeLineNumber(@NotNull Location $this$isInvokeSuspendWithNegativeLineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspendWithNegativeLineNumber, (String)"<this>");
        return CoroutineUtilsKt.isInvokeSuspend($this$isInvokeSuspendWithNegativeLineNumber) && SafeUtilKt.safeLineNumber($this$isInvokeSuspendWithNegativeLineNumber) < 0;
    }

    public static final boolean isFilteredInvokeSuspend(@NotNull Location $this$isFilteredInvokeSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilteredInvokeSuspend, (String)"<this>");
        return CoroutineUtilsKt.isInvokeSuspend($this$isFilteredInvokeSuspend) || CoroutineUtilsKt.isInvokeSuspendWithNegativeLineNumber($this$isFilteredInvokeSuspend);
    }

    @Nullable
    public static final ObjectReference variableValue(@NotNull StackFrameProxyImpl $this$variableValue, @NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)$this$variableValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName($this$variableValue, variableName);
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value2 = $this$variableValue.getValue(continuationVariable);
        ObjectReference objectReference = value2 instanceof ObjectReference ? (ObjectReference)value2 : null;
        if (objectReference == null) {
            return null;
        }
        return objectReference;
    }

    @Nullable
    public static final ObjectReference continuationVariableValue(@NotNull StackFrameProxyImpl $this$continuationVariableValue) {
        Intrinsics.checkNotNullParameter((Object)$this$continuationVariableValue, (String)"<this>");
        return CoroutineUtilsKt.variableValue($this$continuationVariableValue, "$continuation");
    }

    @Nullable
    public static final ObjectReference thisVariableValue(@NotNull StackFrameProxyImpl $this$thisVariableValue) {
        Intrinsics.checkNotNullParameter((Object)$this$thisVariableValue, (String)"<this>");
        return $this$thisVariableValue.thisObject();
    }

    private static final boolean isGetCoroutineSuspended(Method $this$isGetCoroutineSuspended) {
        return Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.signature(), (Object)"()Ljava/lang/Object;") && Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.name(), (Object)"getCOROUTINE_SUSPENDED") && Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.declaringType().name(), (Object)"kotlin.coroutines.intrinsics.IntrinsicsKt__IntrinsicsKt");
    }

    @Nullable
    public static final ClassType findCoroutineMetadataType(@NotNull DefaultExecutionContext $this$findCoroutineMetadataType) {
        Intrinsics.checkNotNullParameter((Object)$this$findCoroutineMetadataType, (String)"<this>");
        return (ClassType)DebuggerUtil.invokeInManagerThread($this$findCoroutineMetadataType.getDebugProcess(), (Function1)new Function1<DebuggerContextImpl, ClassType>($this$findCoroutineMetadataType){
            final /* synthetic */ DefaultExecutionContext $this_findCoroutineMetadataType;
            {
                this.$this_findCoroutineMetadataType = $receiver;
                super(1);
            }

            @Nullable
            public final ClassType invoke(@NotNull DebuggerContextImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$this_findCoroutineMetadataType.findClassSafe("kotlin.coroutines.jvm.internal.DebugMetadataKt");
            }
        });
    }

    @Nullable
    public static final List<ReferenceType> findDispatchedContinuationReferenceType(@NotNull DefaultExecutionContext $this$findDispatchedContinuationReferenceType) {
        Intrinsics.checkNotNullParameter((Object)$this$findDispatchedContinuationReferenceType, (String)"<this>");
        return $this$findDispatchedContinuationReferenceType.getVm().classesByName("kotlinx.coroutines.DispatchedContinuation");
    }

    @Nullable
    public static final List<ReferenceType> findCancellableContinuationImplReferenceType(@NotNull DefaultExecutionContext $this$findCancellableContinuationImplReferenceType) {
        Intrinsics.checkNotNullParameter((Object)$this$findCancellableContinuationImplReferenceType, (String)"<this>");
        return $this$findCancellableContinuationImplReferenceType.getVm().classesByName("kotlinx.coroutines.CancellableContinuationImpl");
    }

    public static final int hasGetCoroutineSuspended(@NotNull List<? extends StackFrameProxyImpl> frames) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter(frames, (String)"frames");
            List<? extends StackFrameProxyImpl> $this$indexOfFirst$iv = frames;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<? extends StackFrameProxyImpl> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                StackFrameProxyImpl item$iv;
                StackFrameProxyImpl it = item$iv = iterator2.next();
                boolean bl = false;
                Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)it);
                boolean bl2 = comparable != null && (comparable = SafeUtilKt.safeMethod(comparable)) != null ? CoroutineUtilsKt.isGetCoroutineSuspended((Method)comparable) : false;
                if (bl2) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public static final boolean isCreationSeparatorFrame(@NotNull StackTraceElement $this$isCreationSeparatorFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$isCreationSeparatorFrame, (String)"<this>");
        String string = $this$isCreationSeparatorFrame.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        return StringsKt.startsWith$default((String)string, (String)CREATION_STACK_TRACE_SEPARATOR, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)$this$isCreationSeparatorFrame.getClassName(), (Object)CREATION_CLASS_NAME);
    }

    @Nullable
    public static final XSourcePosition findPosition(@NotNull Location $this$findPosition, @NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)$this$findPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        return (XSourcePosition)ActionsKt.runReadAction((Function0)((Function0)new Function0<XSourcePosition>(debugProcess, $this$findPosition){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ Location $this_findPosition;
            {
                this.$debugProcess = $debugProcess;
                this.$this_findPosition = $receiver;
                super(0);
            }

            @Nullable
            public final XSourcePosition invoke() {
                return DebuggerUtilsEx.toXSourcePosition((SourcePosition)this.$debugProcess.getPositionManager().getSourcePosition(this.$this_findPosition));
            }
        }));
    }

    @Nullable
    public static final DefaultExecutionContext executionContext(@NotNull SuspendContextImpl $this$executionContext) {
        Intrinsics.checkNotNullParameter((Object)$this$executionContext, (String)"<this>");
        return (DefaultExecutionContext)CoroutineUtilsKt.invokeInManagerThread($this$executionContext, (Function0)new Function0<DefaultExecutionContext>($this$executionContext){
            final /* synthetic */ SuspendContextImpl $this_executionContext;
            {
                this.$this_executionContext = $receiver;
                super(0);
            }

            @Nullable
            public final DefaultExecutionContext invoke() {
                return new DefaultExecutionContext(new EvaluationContextImpl(this.$this_executionContext, this.$this_executionContext.getFrameProxy()));
            }
        });
    }

    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull SuspendContextImpl $this$invokeInManagerThread, @NotNull Function0<? extends T> f2) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeInManagerThread, (String)"<this>");
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        DebugProcessImpl debugProcessImpl = $this$invokeInManagerThread.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        return DebuggerUtil.invokeInManagerThread(debugProcessImpl, (Function1)new Function1<DebuggerContextImpl, T>(f2){
            final /* synthetic */ Function0<T> $f;
            {
                this.$f = $f;
                super(1);
            }

            @Nullable
            public final T invoke(@NotNull DebuggerContextImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (T)this.$f.invoke();
            }
        });
    }

    public static final boolean supportsEvaluation(@NotNull ThreadReferenceProxyImpl $this$supportsEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsEvaluation, (String)"<this>");
        ThreadReference threadReference = $this$supportsEvaluation.getThreadReference();
        return threadReference != null ? threadReference.isSuspended() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean supportsEvaluation(@NotNull SuspendContextImpl $this$supportsEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsEvaluation, (String)"<this>");
        DebugProcessImpl debugProcessImpl = $this$supportsEvaluation.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        if (DebuggerUtil.getCanRunEvaluation(debugProcessImpl)) return true;
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) return false;
        return true;
    }

    public static final boolean threadAndContextSupportsEvaluation(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Boolean bl = (Boolean)CoroutineUtilsKt.invokeInManagerThread(suspendContext, (Function0)new Function0<Boolean>(suspendContext, frameProxy){
            final /* synthetic */ SuspendContextImpl $suspendContext;
            final /* synthetic */ StackFrameProxyImpl $frameProxy;
            {
                this.$suspendContext = $suspendContext;
                this.$frameProxy = $frameProxy;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                StackFrameProxyImpl stackFrameProxyImpl;
                return CoroutineUtilsKt.supportsEvaluation(this.$suspendContext) && ((stackFrameProxyImpl = this.$frameProxy) != null && (stackFrameProxyImpl = stackFrameProxyImpl.threadProxy()) != null ? CoroutineUtilsKt.supportsEvaluation((ThreadReferenceProxyImpl)stackFrameProxyImpl) : false);
            }
        });
        return bl != null ? bl : false;
    }

    public static final boolean sameLineAndMethod(@NotNull Location $this$sameLineAndMethod, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)$this$sameLineAndMethod, (String)"<this>");
        return location2 != null && Intrinsics.areEqual((Object)SafeUtilKt.safeMethod(location2), (Object)SafeUtilKt.safeMethod($this$sameLineAndMethod)) && SafeUtilKt.safeLineNumber(location2) == SafeUtilKt.safeLineNumber($this$sameLineAndMethod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFilterFromTop(@NotNull Location $this$isFilterFromTop, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilterFromTop, (String)"<this>");
        if (CoroutineUtilsKt.isFilteredInvokeSuspend($this$isFilterFromTop)) return true;
        if (CoroutineUtilsKt.sameLineAndMethod($this$isFilterFromTop, location2)) return true;
        Location location3 = location2;
        if (!Intrinsics.areEqual((Object)(location3 != null ? SafeUtilKt.safeMethod(location3) : null), (Object)SafeUtilKt.safeMethod($this$isFilterFromTop))) return false;
        return true;
    }

    public static final boolean isFilterFromBottom(@NotNull Location $this$isFilterFromBottom, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilterFromBottom, (String)"<this>");
        return CoroutineUtilsKt.sameLineAndMethod($this$isFilterFromBottom, location2);
    }
}

