/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.jdi.StackFrameProxyImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentPatcher;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinSuspendFunctionWrapper;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinToStringWrapper;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilationStats;
import org.jetbrains.kotlin.psi.KtCodeFragment;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"patchCodeFragment", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "stats", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilationStats;", "kotlin.jvm-debugger.evaluation"})
public final class KotlinCodeFragmentPatcherKt {
    public static final void patchCodeFragment(@NotNull ExecutionContext context2, @NotNull KtCodeFragment codeFragment, @NotNull CodeFragmentCompilationStats stats) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
        CoroutineStackFrameProxyImpl coroutineStackFrameProxyImpl = stackFrameProxyImpl instanceof CoroutineStackFrameProxyImpl ? (CoroutineStackFrameProxyImpl)stackFrameProxyImpl : null;
        new KotlinCodeFragmentPatcher(codeFragment).addWrapper(new KotlinToStringWrapper()).addWrapper(new KotlinSuspendFunctionWrapper(context2, codeFragment.getContext(), coroutineStackFrameProxyImpl != null ? coroutineStackFrameProxyImpl.isCoroutineScopeAvailable() : false)).wrapFragmentExpressionIfNeeded(stats);
    }
}

