/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaAsyncMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTargetKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaSmartStepTarget;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTarget;", "highlightElement", "Lorg/jetbrains/kotlin/psi/KtFunction;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "lines", "Lcom/intellij/util/Range;", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;)V", "declarationPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "createMethodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "getIcon", "Ljavax/swing/Icon;", "kotlin.jvm-debugger.core-fe10"})
public final class KotlinLambdaSmartStepTarget
extends KotlinSmartStepTarget {
    @NotNull
    private final KotlinLambdaInfo lambdaInfo;
    @NotNull
    private final SmartPsiElementPointer<KtDeclaration> declarationPtr;

    public KotlinLambdaSmartStepTarget(@NotNull KtFunction highlightElement, @NotNull KtDeclaration declaration2, @NotNull Range<Integer> lines, @NotNull KotlinLambdaInfo lambdaInfo) {
        Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)lambdaInfo, (String)"lambdaInfo");
        super(lambdaInfo.getLabel(), (PsiElement)highlightElement, true, lines);
        this.lambdaInfo = lambdaInfo;
        this.declarationPtr = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)declaration2));
    }

    @Override
    @NotNull
    public MethodFilter createMethodFilter() {
        PsiElement psiElement2 = this.getHighlightElement();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        KotlinLambdaMethodFilter lambdaMethodFilter = new KotlinLambdaMethodFilter((KtFunction)psiElement2, (Range<Integer>)this.getCallingExpressionLines(), this.lambdaInfo);
        if (!this.lambdaInfo.isSuspend() && !this.lambdaInfo.getCallerMethodInfo().isInline() && !this.lambdaInfo.isSamSuspendMethod() && Registry.get((String)"debugger.async.smart.step.into").asBoolean()) {
            KtDeclaration declaration2 = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.declarationPtr);
            return (MethodFilter)new KotlinLambdaAsyncMethodFilter(declaration2, (Range<Integer>)this.getCallingExpressionLines(), this.lambdaInfo, lambdaMethodFilter);
        }
        return (MethodFilter)lambdaMethodFilter;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = KotlinIcons.LAMBDA;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LAMBDA");
        return icon;
    }
}

