/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandlerKt;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinCatchBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinCatchParameterFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinClassBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinClassInitializerFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinDoWhileFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFinallyBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinForConditionFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFunctionDeclarationBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFunctionParametersFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinIfConditionFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinLastLambdaParameterFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingForOrWhileBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingIfBranchFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingWhenBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingWhenEntryBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinPropertyAccessorBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinPropertySetterParametersFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinTryBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinValueArgumentListFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinWhenSubjectCaretFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinWhileConditionFixer;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0014J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0014J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0004H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers;", "()V", "getStatementAtCaret", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "moveCaretInsideBracesIfAny", "", "file", "processDefaultEnter", "project", "Lcom/intellij/openapi/project/Project;", "isKotlinStatement", "", "KotlinPlainEnterProcessor", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinSmartEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSmartEnterHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n142#2:163\n1#3:164\n*S KotlinDebug\n*F\n+ 1 KotlinSmartEnterHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler\n*L\n107#1:163\n*E\n"})
public final class KotlinSmartEnterHandler
extends SmartEnterProcessorWithFixers {
    public KotlinSmartEnterHandler() {
        SmartEnterProcessorWithFixers.Fixer[] fixerArray = new SmartEnterProcessorWithFixers.Fixer[]{new KotlinIfConditionFixer(), new KotlinMissingIfBranchFixer(), new KotlinWhileConditionFixer(), new KotlinForConditionFixer(), new KotlinMissingForOrWhileBodyFixer(), new KotlinWhenSubjectCaretFixer(), new KotlinMissingWhenBodyFixer(), new KotlinMissingWhenEntryBodyFixer(), new KotlinDoWhileFixer(), new KotlinFunctionParametersFixer(), new KotlinFunctionDeclarationBodyFixer(), new KotlinPropertySetterParametersFixer(), new KotlinPropertyAccessorBodyFixer(), new KotlinTryBodyFixer(), new KotlinCatchParameterFixer(), new KotlinCatchBodyFixer(), new KotlinFinallyBodyFixer(), new KotlinLastLambdaParameterFixer(), new KotlinClassInitializerFixer(), new KotlinClassBodyFixer(), new KotlinValueArgumentListFixer()};
        this.addFixers(fixerArray);
        fixerArray = new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new KotlinPlainEnterProcessor()};
        this.addEnterProcessors((SmartEnterProcessorWithFixers.FixEnterProcessor[])fixerArray);
    }

    @Nullable
    protected PsiElement getStatementAtCaret(@Nullable Editor editor2, @Nullable PsiFile psiFile2) {
        PsiElement atCaret = super.getStatementAtCaret(editor2, psiFile2);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        while (atCaret != null) {
            if (this.isKotlinStatement(atCaret)) {
                return atCaret;
            }
            if (atCaret.getParent() instanceof KtFunctionLiteral) {
                return atCaret;
            }
            if (atCaret instanceof KtDeclaration) {
                PsiElement declaration2 = atCaret;
                if (!(declaration2 instanceof KtParameter && !((KtParameter)declaration2).isLambdaParameter() || ((KtDeclaration)declaration2).getParent() instanceof KtForExpression)) {
                    return atCaret;
                }
            }
            atCaret = atCaret.getParent();
        }
        return null;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        int caretOffset = editor2.getCaretModel().getOffset();
        CharSequence charSequence = editor2.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - 2), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - 3), (CharSequence)"{\n}")) {
            this.commit(editor2);
            KotlinCommonCodeStyleSettings settings2 = CodeStyleUtilsKt.getKotlinCommonSettings(file2);
            boolean old = settings2.KEEP_LINE_BREAKS;
            settings2.KEEP_LINE_BREAKS = true;
            PsiElement psiElement2 = file2.findElementAt(caretOffset - 1);
            if (psiElement2 != null) {
                PsiElement $this$getStrictParentOfType$iv = psiElement2;
                boolean $i$f$getStrictParentOfType = false;
                psiElement2 = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBlockExpression.class, (boolean)true);
                if (psiElement2 != null) {
                    PsiElement p0 = psiElement2;
                    boolean bl = false;
                    this.reformat(p0);
                }
            }
            settings2.KEEP_LINE_BREAKS = old;
            editor2.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKotlinStatement(PsiElement $this$isKotlinStatement) {
        PsiElement psiElement2;
        if ($this$isKotlinStatement.getParent() instanceof KtBlockExpression) {
            ASTNode aSTNode = $this$isKotlinStatement.getNode();
            if (!KotlinSmartEnterHandlerKt.access$getBRACES$p().contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
                return true;
            }
        }
        if (!KotlinSmartEnterHandlerKt.access$getBRANCH_CONTAINERS$p().contains((psiElement2 = $this$isKotlinStatement.getParent()) != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null)) return false;
        if ($this$isKotlinStatement instanceof KtBlockExpression) return false;
        return true;
    }

    protected void processDefaultEnter(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        SmartEnterProcessorWithFixers.plainEnter((Editor)editor2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler$KotlinPlainEnterProcessor;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$FixEnterProcessor;", "()V", "doEnter", "", "atCaret", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "modified", "getControlStatementBlock", "Lorg/jetbrains/kotlin/psi/KtExpression;", "caret", "", "element", "kotlin.idea"})
    public static final class KotlinPlainEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        private final KtExpression getControlStatementBlock(int caret, PsiElement element3) {
            PsiElement psiElement2 = element3;
            if (psiElement2 instanceof KtDeclarationWithBody) {
                return ((KtDeclarationWithBody)element3).getBodyExpression();
            }
            if (psiElement2 instanceof KtIfExpression) {
                if (FixersUtilKt.isWithCaret((PsiElement)((KtIfExpression)element3).getThen(), caret)) {
                    return ((KtIfExpression)element3).getThen();
                }
                if (FixersUtilKt.isWithCaret((PsiElement)((KtIfExpression)element3).getElse(), caret)) {
                    return ((KtIfExpression)element3).getElse();
                }
            } else if (psiElement2 instanceof KtLoopExpression) {
                return ((KtLoopExpression)element3).getBody();
            }
            return null;
        }

        public boolean doEnter(@NotNull PsiElement atCaret, @Nullable PsiFile file2, @NotNull Editor editor2, boolean modified) {
            KtBlockExpression block2;
            Intrinsics.checkNotNullParameter((Object)atCaret, (String)"atCaret");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (modified && atCaret instanceof KtCallExpression) {
                return true;
            }
            KtExpression ktExpression = this.getControlStatementBlock(editor2.getCaretModel().getOffset(), atCaret);
            KtBlockExpression ktBlockExpression = block2 = ktExpression instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null;
            if (block2 != null) {
                int n;
                PsiElement firstElement;
                PsiElement psiElement2 = block2.getFirstChild();
                Object object = firstElement = psiElement2 != null ? psiElement2.getNextSibling() : null;
                if (firstElement != null) {
                    TextRange textRange = firstElement.getTextRange();
                    Intrinsics.checkNotNull((Object)textRange);
                    n = textRange.getStartOffset() - 1;
                } else {
                    TextRange textRange = block2.getTextRange();
                    Intrinsics.checkNotNull((Object)textRange);
                    n = textRange.getEndOffset();
                }
                int offset2 = n;
                editor2.getCaretModel().moveToOffset(offset2);
            }
            this.plainEnter(editor2);
            return true;
        }
    }
}

