/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.editor.KotlinTypedHandlerHelper;
import org.jetbrains.kotlin.idea.editor.LtGtTypingUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "isGlobalPreviousDollarInString", "", "kotlinLTTyped", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "charTyped", "KotlinTypedHandlerTokenSets", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinTypedHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTypedHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinTypedHandler\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n118#2:335\n1#3:336\n*S KotlinDebug\n*F\n+ 1 KotlinTypedHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinTypedHandler\n*L\n260#1:335\n*E\n"})
public final class KotlinTypedHandler
extends TypedHandlerDelegate {
    private boolean kotlinLTTyped;
    private boolean isGlobalPreviousDollarInString;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        if (!(file2 instanceof KtFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        char c2 = c;
        if (c2 == ')') {
            KotlinTypedHandlerHelper.INSTANCE.dataClassValParameterInsert$kotlin_idea(project2, editor2, file2, true);
        } else if (c2 == '<') {
            this.kotlinLTTyped = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.shouldAutoCloseAngleBracket(editor2.getCaretModel().getOffset(), editor2);
            KotlinTypedHandlerHelper.INSTANCE.autoPopupParameterInfo$kotlin_idea(project2, editor2);
        } else if (c2 == '>') {
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.handleKotlinGTInsert(editor2)) {
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (c2 == '{') {
            int offset2 = editor2.getCaretModel().getOffset();
            if (offset2 == 0) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            HighlighterIterator highlighterIterator = editor2.getHighlighter().createIterator(offset2 - 1);
            Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
            HighlighterIterator iterator2 = highlighterIterator;
            while (!iterator2.atEnd() && iterator2.getTokenType() == TokenType.WHITE_SPACE) {
                iterator2.retreat();
            }
            if (iterator2.atEnd() || !KotlinTypedHandlerTokenSets.INSTANCE.getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER().contains(iterator2.getTokenType())) {
                AutoPopupController.getInstance((Project)project2).autoPopupParameterInfo(editor2, null);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            int tokenBeforeBraceOffset = iterator2.getStart();
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
            PsiElement leaf = file2.findElementAt(offset2);
            if (leaf != null) {
                ASTNode nonWhitespaceSibling;
                PsiElement parent2 = leaf.getParent();
                if (parent2 != null && KotlinTypedHandlerTokenSets.INSTANCE.getCONTROL_FLOW_EXPRESSIONS().contains(parent2.getNode().getElementType()) && (nonWhitespaceSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)leaf.getNode())) != null && nonWhitespaceSibling.getStartOffset() == tokenBeforeBraceOffset) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)"{", (boolean)false, (boolean)true);
                    TypedHandler.indentBrace((Project)project2, (Editor)editor2, (char)'{');
                    return TypedHandlerDelegate.Result.STOP;
                }
                if (Intrinsics.areEqual((Object)leaf.getText(), (Object)"}") && parent2 instanceof KtFunctionLiteral && document2.getLineNumber(offset2) == document2.getLineNumber(parent2.getTextRange().getStartOffset())) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)"{} ", (boolean)false, (boolean)false);
                    editor2.getCaretModel().moveToOffset(offset2 + 1);
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        } else if (c2 == '.') {
            KotlinTypedHandlerHelper.INSTANCE.autoPopupMemberLookup$kotlin_idea(project2, editor2);
        } else if (c2 == ':') {
            KotlinTypedHandlerHelper.INSTANCE.autoPopupCallableReferenceLookup$kotlin_idea(project2, editor2);
        } else if (c2 == '[') {
            KotlinTypedHandlerHelper.INSTANCE.autoPopupParameterInfo$kotlin_idea(project2, editor2);
        } else if (c2 == '@') {
            KotlinTypedHandlerHelper.INSTANCE.autoPopupAt$kotlin_idea(project2, editor2);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        block29: {
            block30: {
                boolean isSimpleLongTemplateEntry;
                LeafPsiElement $this$safeAs$iv;
                PsiElement previousElement;
                int offset2;
                Integer previousDollarInStringOffset;
                block32: {
                    block31: {
                        LeafPsiElement leafPsiElement;
                        block28: {
                            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                            if (!(file2 instanceof KtFile)) {
                                return TypedHandlerDelegate.Result.CONTINUE;
                            }
                            previousDollarInStringOffset = null;
                            if (this.isGlobalPreviousDollarInString) {
                                this.isGlobalPreviousDollarInString = false;
                                previousDollarInStringOffset = (Integer)editor2.getUserData(KotlinTypedHandlerHelper.INSTANCE.getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_idea());
                            }
                            editor2.putUserData(KotlinTypedHandlerHelper.INSTANCE.getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_idea(), null);
                            if (this.kotlinLTTyped) {
                                this.kotlinLTTyped = false;
                                LtGtTypingUtils.handleKotlinAutoCloseLT(editor2);
                                return TypedHandlerDelegate.Result.STOP;
                            }
                            if (c != ',' && c != ')') break block28;
                            KotlinTypedHandlerHelper.INSTANCE.dataClassValParameterInsert$kotlin_idea(project2, editor2, file2, false);
                            break block29;
                        }
                        if (c != '{' || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) break block30;
                        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
                        offset2 = editor2.getCaretModel().getOffset();
                        previousElement = file2.findElementAt(offset2 - 1);
                        if (!(previousElement instanceof LeafPsiElement) || ((LeafPsiElement)previousElement).getElementType() != KtTokens.LONG_TEMPLATE_ENTRY_START) break block29;
                        PsiElement psiElement2 = file2.findElementAt(offset2);
                        if (psiElement2 == null) break block31;
                        PsiElement psiElement3 = psiElement2;
                        boolean $i$f$safeAs = false;
                        LeafPsiElement leafPsiElement2 = $this$safeAs$iv;
                        if (!(leafPsiElement2 instanceof LeafPsiElement)) {
                            leafPsiElement2 = null;
                        }
                        if ((leafPsiElement = (LeafPsiElement)leafPsiElement2) == null) break block31;
                        LeafPsiElement it = $i$f$safeAs = leafPsiElement;
                        boolean bl = false;
                        Object object = $this$safeAs$iv = Intrinsics.areEqual((Object)it.getElementType(), (Object)KtTokens.IDENTIFIER) ? $i$f$safeAs : null;
                        if ($this$safeAs$iv != null) break block32;
                    }
                    boolean bl = false;
                    editor2.getDocument().insertString(offset2, (CharSequence)"}");
                    return TypedHandlerDelegate.Result.STOP;
                }
                LeafPsiElement identifier2 = $this$safeAs$iv;
                PsiElement lastInLongTemplateEntry = ((LeafPsiElement)previousElement).getParent().getLastChild();
                boolean bl = isSimpleLongTemplateEntry = lastInLongTemplateEntry instanceof LeafPsiElement && ((LeafPsiElement)lastInLongTemplateEntry).getElementType() == KtTokens.LONG_TEMPLATE_ENTRY_END && lastInLongTemplateEntry.getParent().getTextLength() == identifier2.getTextLength() + 3;
                if (!isSimpleLongTemplateEntry) {
                    boolean isAfterTypedDollar;
                    boolean bl2 = isAfterTypedDollar = previousDollarInStringOffset != null && previousDollarInStringOffset == offset2 - 1;
                    if (isAfterTypedDollar) {
                        editor2.getDocument().insertString(offset2, (CharSequence)"}");
                        return TypedHandlerDelegate.Result.STOP;
                    }
                }
                break block29;
            }
            if (c == ':') {
                if (KotlinTypedHandlerHelper.autoIndentCase$kotlin_idea$default(KotlinTypedHandlerHelper.INSTANCE, editor2, project2, file2, KtClassOrObject.class, false, 16, null) || KotlinTypedHandlerHelper.autoIndentCase$kotlin_idea$default(KotlinTypedHandlerHelper.INSTANCE, editor2, project2, file2, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '.') {
                if (KotlinTypedHandlerHelper.autoIndentCase$kotlin_idea$default(KotlinTypedHandlerHelper.INSTANCE, editor2, project2, file2, KtQualifiedExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '|') {
                if (KotlinTypedHandlerHelper.autoIndentCase$kotlin_idea$default(KotlinTypedHandlerHelper.INSTANCE, editor2, project2, file2, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '&') {
                if (KotlinTypedHandlerHelper.autoIndentCase$kotlin_idea$default(KotlinTypedHandlerHelper.INSTANCE, editor2, project2, file2, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '$') {
                int offset3 = editor2.getCaretModel().getOffset();
                PsiElement element3 = file2.findElementAt(offset3);
                if (element3 instanceof LeafPsiElement && ((LeafPsiElement)element3).getElementType() == KtTokens.REGULAR_STRING_PART) {
                    editor2.putUserData(KotlinTypedHandlerHelper.INSTANCE.getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_idea(), (Object)offset3);
                    this.isGlobalPreviousDollarInString = true;
                }
            } else if (c == '(' && KotlinTypedHandlerHelper.INSTANCE.autoIndentCase$kotlin_idea(editor2, project2, file2, KtPropertyAccessor.class, false)) {
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandler$KotlinTypedHandlerTokenSets;", "", "()V", "CONTROL_FLOW_EXPRESSIONS", "Lcom/intellij/psi/tree/TokenSet;", "getCONTROL_FLOW_EXPRESSIONS", "()Lcom/intellij/psi/tree/TokenSet;", "SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER", "getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER", "kotlin.idea"})
    private static final class KotlinTypedHandlerTokenSets {
        @NotNull
        public static final KotlinTypedHandlerTokenSets INSTANCE = new KotlinTypedHandlerTokenSets();
        @NotNull
        private static final TokenSet CONTROL_FLOW_EXPRESSIONS;
        @NotNull
        private static final TokenSet SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER;

        private KotlinTypedHandlerTokenSets() {
        }

        @NotNull
        public final TokenSet getCONTROL_FLOW_EXPRESSIONS() {
            return CONTROL_FLOW_EXPRESSIONS;
        }

        @NotNull
        public final TokenSet getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER() {
            return SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER;
        }

        static {
            IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.IF, KtNodeTypes.ELSE, KtNodeTypes.FOR, KtNodeTypes.WHILE, KtNodeTypes.TRY};
            TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
            CONTROL_FLOW_EXPRESSIONS = tokenSet;
            iElementTypeArray = new IElementType[]{KtTokens.RPAR, KtTokens.ELSE_KEYWORD, KtTokens.TRY_KEYWORD};
            TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
            SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER = tokenSet2;
        }
    }
}

