/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleKotlinFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationUtils;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0014J\b\u0010\u0016\u001a\u00020\u0003H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/GradleKotlinJavaFrameworkSupportProvider;", "Lorg/jetbrains/kotlin/idea/gradleJava/configuration/GradleKotlinFrameworkSupportProvider;", "frameworkTypeId", "", "displayName", "(Ljava/lang/String;Ljava/lang/String;)V", "addSupport", "", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "specifyPluginVersionIfNeeded", "", "explicitPluginVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getDependencies", "", "getDescription", "getPluginExpression", "getPluginId", "kotlin.gradle.gradle-java"})
public class GradleKotlinJavaFrameworkSupportProvider
extends GradleKotlinFrameworkSupportProvider {
    public GradleKotlinJavaFrameworkSupportProvider(@NotNull String frameworkTypeId, @Nls @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)frameworkTypeId, (String)"frameworkTypeId");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Icon icon = KotlinIcons.SMALL_LOGO;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SMALL_LOGO");
        super(frameworkTypeId, displayName, icon);
    }

    public /* synthetic */ GradleKotlinJavaFrameworkSupportProvider(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "KOTLIN";
        }
        if ((n & 2) != 0) {
            string2 = KotlinIdeaGradleBundle.message("framework.support.provider.kotlin.jvm.display.name", new Object[0]);
        }
        this(string, string2);
    }

    @Override
    @NotNull
    protected String getPluginId() {
        return "kotlin";
    }

    @Override
    @NotNull
    protected String getPluginExpression() {
        return "id 'org.jetbrains.kotlin.jvm'";
    }

    @Override
    @NotNull
    protected List<String> getDependencies(@Nullable Sdk sdk2) {
        return CollectionsKt.listOf((Object)KotlinProjectConfigurationUtils.getJvmStdlibArtifactId(sdk2, KotlinPluginLayout.getStandaloneCompilerVersion()));
    }

    @Override
    public void addSupport(@NotNull BuildScriptDataBuilder buildScriptData, @NotNull Module module2, @Nullable Sdk sdk2, boolean specifyPluginVersionIfNeeded, @Nullable IdeKotlinVersion explicitPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)buildScriptData, (String)"buildScriptData");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        super.addSupport(buildScriptData, module2, sdk2, specifyPluginVersionIfNeeded, explicitPluginVersion);
        JvmTarget jvmTarget2 = KotlinProjectConfigurationUtils.getDefaultJvmTarget(sdk2, KotlinPluginLayout.getStandaloneCompilerVersion());
        if (jvmTarget2 != null) {
            String description2 = jvmTarget2.getDescription();
            buildScriptData.addOther("compileKotlin {\n    kotlinOptions.jvmTarget = \"" + description2 + "\"\n}\n\n");
            buildScriptData.addOther("compileTestKotlin {\n    kotlinOptions.jvmTarget = \"" + description2 + "\"\n}\n");
        }
    }

    @Override
    @NotNull
    protected String getDescription() {
        return KotlinIdeaGradleBundle.message("description.text.a.single.platform.kotlin.library.or.application.targeting.the.jvm", new Object[0]);
    }

    public GradleKotlinJavaFrameworkSupportProvider() {
        this(null, null, 3, null);
    }
}

