/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting.roots;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.storage.GistStorage;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.scripting.LastModifiedFiles;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootData;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootDataSerializerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootDataSerializer;", "", "()V", "buildRootDataGist", "Lcom/intellij/util/gist/storage/GistStorage$Gist;", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentBuildRoot", "Ljava/lang/ThreadLocal;", "Lcom/intellij/openapi/vfs/VirtualFile;", "read", "buildRoot", "remove", "", "write", "data", "Externalizer", "kotlin.gradle.gradle-java"})
public final class GradleBuildRootDataSerializer {
    @NotNull
    public static final GradleBuildRootDataSerializer INSTANCE = new GradleBuildRootDataSerializer();
    @NotNull
    private static final ThreadLocal<VirtualFile> currentBuildRoot = new ThreadLocal();
    @NotNull
    private static final GistStorage.Gist<GradleBuildRootData> buildRootDataGist;

    private GradleBuildRootDataSerializer() {
    }

    @Nullable
    public final GradleBuildRootData read(@NotNull VirtualFile buildRoot) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        currentBuildRoot.set(buildRoot);
        return (GradleBuildRootData)buildRootDataGist.getGlobalData(buildRoot, 0).data();
    }

    public final void write(@NotNull VirtualFile buildRoot, @Nullable GradleBuildRootData data2) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        currentBuildRoot.set(buildRoot);
        buildRootDataGist.putGlobalData(buildRoot, (Object)data2, 0);
    }

    public final void remove(@NotNull VirtualFile buildRoot) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        this.write(buildRoot, null);
        LastModifiedFiles.Companion.remove(buildRoot);
    }

    static {
        GistStorage.Gist gist = GistStorage.getInstance().newGist("GradleBuildRootData", 1, (DataExternalizer)Externalizer.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)gist, (String)"newGist(...)");
        buildRootDataGist = gist;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootDataSerializer$Externalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootData;", "()V", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value", "kotlin.gradle.gradle-java"})
    private static final class Externalizer
    implements DataExternalizer<GradleBuildRootData> {
        @NotNull
        public static final Externalizer INSTANCE = new Externalizer();

        private Externalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull GradleBuildRootData value2) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            GradleBuildRootDataSerializerKt.writeKotlinDslScriptModels(out, value2);
        }

        @NotNull
        public GradleBuildRootData read(@NotNull DataInput in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            String string = ((VirtualFile)currentBuildRoot.get()).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return GradleBuildRootDataSerializerKt.readKotlinDslScriptModels(in, string);
        }
    }
}

