/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.i18n;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/i18n/KotlinInvalidBundleOrPropertyInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getDisplayName", "", "kotlin.i18n"})
public final class KotlinInvalidBundleOrPropertyInspection
extends AbstractKotlinInspection {
    @NotNull
    public String getDisplayName() {
        String string = JavaI18nBundle.message((String)"inspection.unresolved.property.key.reference.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            private final void processResourceBundleReference(ResourceBundleReference ref, KtStringTemplateExpression template2) {
                ResolveResult[] resolveResultArray = ref.multiResolve(true);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                if (((Object[])resolveResultArray).length == 0) {
                    Object[] objectArray = new Object[]{ref.getCanonicalText()};
                    this.$holder.registerProblem((PsiElement)template2, JavaI18nBundle.message((String)"inspection.invalid.resource.bundle.reference", (Object[])objectArray), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new TextRange(0, template2.getTextLength()), new LocalQuickFix[0]);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final void processPropertyReference(PropertyReference ref, KtStringTemplateExpression template2) {
                int expectedArgumentCount;
                int actualArgumentCount;
                KtValueArgument messageArgument;
                void this_$iv$iv$iv;
                void this_$iv$iv;
                Object v4;
                Property property2;
                block19: {
                    if (ref.isSoft()) {
                        return;
                    }
                    ResolveResult[] resolveResultArray = ref.multiResolve(true);
                    Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                    ResolveResult resolveResult = (ResolveResult)ArraysKt.firstOrNull((Object[])resolveResultArray);
                    Object[] objectArray = resolveResult != null ? resolveResult.getElement() : null;
                    Property property3 = property2 = objectArray instanceof Property ? (Property)objectArray : null;
                    if (property2 == null) {
                        objectArray = new Object[]{ref.getCanonicalText()};
                        String string = JavaI18nBundle.message((String)"inspection.unresolved.property.key.reference.message", (Object[])objectArray);
                        objectArray = ref.getQuickFixes();
                        this.$holder.registerProblem((PsiElement)template2, string, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new TextRange(0, template2.getTextLength()), (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
                        return;
                    }
                    Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)template2));
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (E element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtValueArgument)) continue;
                        v4 = element$iv;
                        break block19;
                    }
                    v4 = null;
                }
                KtValueArgument ktValueArgument = v4;
                if (ktValueArgument == null) {
                    return;
                }
                KtValueArgument argument2 = ktValueArgument;
                if (!Intrinsics.areEqual((Object)argument2.getArgumentExpression(), (Object)KtPsiUtil.deparenthesize((KtExpression)((KtExpression)template2)))) {
                    return;
                }
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)argument2;
                boolean $i$f$getStrictParentOfType22 = false;
                KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
                if (ktCallExpression == null) {
                    return;
                }
                KtCallExpression callExpression2 = ktCallExpression;
                int keyArgumentIndex = callExpression2.getValueArguments().indexOf(argument2);
                if (keyArgumentIndex < 0) {
                    return;
                }
                boolean $i$f$analyze = false;
                Project project2 = ((KtElement)callExpression2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                KtAnalysisSessionProvider $i$f$getStrictParentOfType22 = KtAnalysisSessionProvider.Companion.getInstance(project2);
                boolean $i$f$analyse = false;
                void var10_16 = this_$iv$iv;
                KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)callExpression2);
                boolean $i$f$analyse2 = false;
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                try {
                    KtAnalysisSession $this$processPropertyReference_u24lambda_u240 = analysisSession$iv$iv$iv;
                    boolean bl = false;
                    KtLifetimeOwner ktLifetimeOwner = $this$processPropertyReference_u24lambda_u240.resolveCall((KtElement)callExpression2);
                    if (ktLifetimeOwner == null || (ktLifetimeOwner = KtCallKt.singleFunctionCallOrNull((KtCallInfo)ktLifetimeOwner)) == null || (ktLifetimeOwner = (KtFunctionLikeSymbol)KtCallKt.getSymbol((KtCallableMemberCall)ktLifetimeOwner)) == null) {
                        return;
                    }
                    KtLifetimeOwner callable2 = ktLifetimeOwner;
                    if (((KtFunctionLikeSymbol)callable2).getValueParameters().size() != keyArgumentIndex + 2) {
                        return;
                    }
                    if (!((KtValueParameterSymbol)CollectionsKt.last(((KtFunctionLikeSymbol)callable2).getValueParameters())).isVararg()) {
                        return;
                    }
                    Unit unit2 = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                    this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                }
                int argsSize = callExpression2.getValueArguments().size();
                KtValueArgument ktValueArgument2 = messageArgument = argsSize > keyArgumentIndex + 1 ? (KtValueArgument)callExpression2.getValueArguments().get(keyArgumentIndex + 1) : null;
                boolean bl = ktValueArgument2 != null ? ktValueArgument2.isSpread() : false;
                if (bl) {
                    return;
                }
                String string = property2.getValue();
                if (string == null) {
                    string = "";
                }
                if ((actualArgumentCount = argsSize - keyArgumentIndex - 1) < (expectedArgumentCount = JavaI18nUtil.getPropertyValuePlaceholdersCount((String)string))) {
                    Object[] objectArray = new Object[]{ref.getCanonicalText(), expectedArgumentCount, actualArgumentCount};
                    String string2 = JavaI18nBundle.message((String)"property.has.more.parameters.than.passed", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    String description2 = string2;
                    this.$holder.registerProblem((PsiElement)template2, description2, ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                }
            }

            public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                PsiReference[] psiReferenceArray = expression2.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                for (PsiReference ref : psiReferenceArray) {
                    PsiReference psiReference = ref;
                    if (psiReference instanceof ResourceBundleReference) {
                        Intrinsics.checkNotNull((Object)ref);
                        this.processResourceBundleReference((ResourceBundleReference)ref, expression2);
                        continue;
                    }
                    if (!(psiReference instanceof PropertyReference)) continue;
                    Intrinsics.checkNotNull((Object)ref);
                    this.processPropertyReference((PropertyReference)ref, expression2);
                }
            }
        };
    }
}

